/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.autoscaler.state;

import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.autoscaler.DelayedScaleDown;
import org.apache.flink.autoscaler.JobAutoScalerContext;
import org.apache.flink.autoscaler.ScalingSummary;
import org.apache.flink.autoscaler.ScalingTracking;
import org.apache.flink.autoscaler.metrics.CollectedMetrics;
import org.apache.flink.autoscaler.state.AutoScalerStateStore;
import org.apache.flink.autoscaler.tuning.ConfigChanges;
import org.apache.flink.runtime.jobgraph.JobVertexID;

public class InMemoryAutoScalerStateStore<KEY, Context extends JobAutoScalerContext<KEY>>
implements AutoScalerStateStore<KEY, Context> {
    private final Map<KEY, Map<JobVertexID, SortedMap<Instant, ScalingSummary>>> scalingHistoryStore = new ConcurrentHashMap<KEY, Map<JobVertexID, SortedMap<Instant, ScalingSummary>>>();
    private final Map<KEY, SortedMap<Instant, CollectedMetrics>> collectedMetricsStore = new ConcurrentHashMap<KEY, SortedMap<Instant, CollectedMetrics>>();
    private final Map<KEY, Map<String, String>> parallelismOverridesStore = new ConcurrentHashMap<KEY, Map<String, String>>();
    private final Map<KEY, ConfigChanges> tmConfigOverrides;
    private final Map<KEY, ScalingTracking> scalingTrackingStore = new ConcurrentHashMap<KEY, ScalingTracking>();
    private final Map<KEY, DelayedScaleDown> delayedScaleDownStore;

    public InMemoryAutoScalerStateStore() {
        this.tmConfigOverrides = new ConcurrentHashMap<KEY, ConfigChanges>();
        this.delayedScaleDownStore = new ConcurrentHashMap<KEY, DelayedScaleDown>();
    }

    @Override
    public void storeScalingHistory(Context jobContext, Map<JobVertexID, SortedMap<Instant, ScalingSummary>> scalingHistory) {
        this.scalingHistoryStore.put(((JobAutoScalerContext)jobContext).getJobKey(), scalingHistory);
    }

    @Override
    @Nonnull
    public Map<JobVertexID, SortedMap<Instant, ScalingSummary>> getScalingHistory(Context jobContext) {
        return Optional.ofNullable(this.scalingHistoryStore.get(((JobAutoScalerContext)jobContext).getJobKey())).orElse(new HashMap());
    }

    @Override
    public void storeScalingTracking(Context jobContext, ScalingTracking scalingTracking) {
        this.scalingTrackingStore.put(((JobAutoScalerContext)jobContext).getJobKey(), scalingTracking);
    }

    @Override
    public ScalingTracking getScalingTracking(Context jobContext) {
        return Optional.ofNullable(this.scalingTrackingStore.get(((JobAutoScalerContext)jobContext).getJobKey())).orElse(new ScalingTracking());
    }

    @Override
    public void removeScalingHistory(Context jobContext) {
        this.scalingHistoryStore.remove(((JobAutoScalerContext)jobContext).getJobKey());
    }

    @Override
    public void storeCollectedMetrics(Context jobContext, SortedMap<Instant, CollectedMetrics> metrics) {
        this.collectedMetricsStore.put(((JobAutoScalerContext)jobContext).getJobKey(), metrics);
    }

    @Override
    @Nonnull
    public SortedMap<Instant, CollectedMetrics> getCollectedMetrics(Context jobContext) {
        return Optional.ofNullable(this.collectedMetricsStore.get(((JobAutoScalerContext)jobContext).getJobKey())).orElse(new TreeMap());
    }

    @Override
    public void removeCollectedMetrics(Context jobContext) {
        this.collectedMetricsStore.remove(((JobAutoScalerContext)jobContext).getJobKey());
    }

    @Override
    public void storeParallelismOverrides(Context jobContext, Map<String, String> parallelismOverrides) {
        this.parallelismOverridesStore.put(((JobAutoScalerContext)jobContext).getJobKey(), parallelismOverrides);
    }

    @Override
    @Nonnull
    public Map<String, String> getParallelismOverrides(Context jobContext) {
        return Optional.ofNullable(this.parallelismOverridesStore.get(((JobAutoScalerContext)jobContext).getJobKey())).orElse(new HashMap());
    }

    @Override
    public void storeConfigChanges(Context jobContext, ConfigChanges configChanges) {
        this.tmConfigOverrides.put(((JobAutoScalerContext)jobContext).getJobKey(), configChanges);
    }

    @Override
    @Nonnull
    public ConfigChanges getConfigChanges(Context jobContext) {
        return Optional.ofNullable(this.tmConfigOverrides.get(((JobAutoScalerContext)jobContext).getJobKey())).orElse(new ConfigChanges());
    }

    @Override
    public void removeConfigChanges(Context jobContext) {
        this.tmConfigOverrides.remove(((JobAutoScalerContext)jobContext).getJobKey());
    }

    @Override
    public void removeParallelismOverrides(Context jobContext) {
        this.parallelismOverridesStore.remove(((JobAutoScalerContext)jobContext).getJobKey());
    }

    @Override
    public void storeDelayedScaleDown(Context jobContext, DelayedScaleDown delayedScaleDown) {
        this.delayedScaleDownStore.put(((JobAutoScalerContext)jobContext).getJobKey(), delayedScaleDown);
    }

    @Override
    @Nonnull
    public DelayedScaleDown getDelayedScaleDown(Context jobContext) {
        return Optional.ofNullable(this.delayedScaleDownStore.get(((JobAutoScalerContext)jobContext).getJobKey())).orElse(new DelayedScaleDown());
    }

    @Override
    public void clearAll(Context jobContext) {
        this.scalingHistoryStore.remove(((JobAutoScalerContext)jobContext).getJobKey());
        this.parallelismOverridesStore.remove(((JobAutoScalerContext)jobContext).getJobKey());
        this.collectedMetricsStore.remove(((JobAutoScalerContext)jobContext).getJobKey());
        this.tmConfigOverrides.remove(((JobAutoScalerContext)jobContext).getJobKey());
        this.scalingTrackingStore.remove(((JobAutoScalerContext)jobContext).getJobKey());
        this.delayedScaleDownStore.remove(((JobAutoScalerContext)jobContext).getJobKey());
    }

    @Override
    public void flush(Context jobContext) {
    }

    @VisibleForTesting
    public boolean hasDataFor(Context jobContext) {
        Object k = ((JobAutoScalerContext)jobContext).getJobKey();
        return Stream.of(this.scalingHistoryStore, this.parallelismOverridesStore, this.collectedMetricsStore, this.tmConfigOverrides, this.scalingTrackingStore, this.delayedScaleDownStore).anyMatch(m -> m.containsKey(k));
    }

    @Override
    public void close() throws Exception {
    }
}

