/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.autoscaler.state;

import java.time.Instant;
import java.util.Map;
import java.util.SortedMap;
import javax.annotation.Nonnull;
import org.apache.flink.annotation.Experimental;
import org.apache.flink.autoscaler.DelayedScaleDown;
import org.apache.flink.autoscaler.JobAutoScalerContext;
import org.apache.flink.autoscaler.ScalingSummary;
import org.apache.flink.autoscaler.ScalingTracking;
import org.apache.flink.autoscaler.metrics.CollectedMetrics;
import org.apache.flink.autoscaler.tuning.ConfigChanges;
import org.apache.flink.runtime.jobgraph.JobVertexID;

@Experimental
public interface AutoScalerStateStore<KEY, Context extends JobAutoScalerContext<KEY>>
extends AutoCloseable {
    public void storeScalingHistory(Context var1, Map<JobVertexID, SortedMap<Instant, ScalingSummary>> var2) throws Exception;

    @Nonnull
    public Map<JobVertexID, SortedMap<Instant, ScalingSummary>> getScalingHistory(Context var1) throws Exception;

    public void storeScalingTracking(Context var1, ScalingTracking var2) throws Exception;

    public ScalingTracking getScalingTracking(Context var1) throws Exception;

    public void removeScalingHistory(Context var1) throws Exception;

    public void storeCollectedMetrics(Context var1, SortedMap<Instant, CollectedMetrics> var2) throws Exception;

    @Nonnull
    public SortedMap<Instant, CollectedMetrics> getCollectedMetrics(Context var1) throws Exception;

    public void removeCollectedMetrics(Context var1) throws Exception;

    public void storeParallelismOverrides(Context var1, Map<String, String> var2) throws Exception;

    @Nonnull
    public Map<String, String> getParallelismOverrides(Context var1) throws Exception;

    public void removeParallelismOverrides(Context var1) throws Exception;

    public void storeConfigChanges(Context var1, ConfigChanges var2) throws Exception;

    @Nonnull
    public ConfigChanges getConfigChanges(Context var1) throws Exception;

    public void removeConfigChanges(Context var1) throws Exception;

    public void storeDelayedScaleDown(Context var1, DelayedScaleDown var2) throws Exception;

    @Nonnull
    public DelayedScaleDown getDelayedScaleDown(Context var1) throws Exception;

    public void clearAll(Context var1) throws Exception;

    public void flush(Context var1) throws Exception;
}

