/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.autoscaler.metrics;

import java.util.Set;

public enum ScalingMetric {
    LOAD(true),
    TRUE_PROCESSING_RATE(true),
    OBSERVED_TPR(true),
    TARGET_DATA_RATE(true),
    CATCH_UP_DATA_RATE(false),
    LAG(false),
    PARALLELISM(false),
    RECOMMENDED_PARALLELISM(false),
    MAX_PARALLELISM(false),
    NUM_SOURCE_PARTITIONS(false),
    SCALE_UP_RATE_THRESHOLD(false),
    SCALE_DOWN_RATE_THRESHOLD(false),
    EXPECTED_PROCESSING_RATE(false),
    NUM_RECORDS_IN(false),
    NUM_RECORDS_OUT(false),
    ACCUMULATED_BUSY_TIME(false),
    GC_PRESSURE(false),
    HEAP_MEMORY_USED(true),
    MANAGED_MEMORY_USED(true),
    METASPACE_MEMORY_USED(true),
    HEAP_MAX_USAGE_RATIO(true),
    NUM_TASK_SLOTS_USED(false);

    private final boolean calculateAverage;
    public static final Set<ScalingMetric> REPORTED_VERTEX_METRICS;

    private ScalingMetric(boolean calculateAverage) {
        this.calculateAverage = calculateAverage;
    }

    public boolean isCalculateAverage() {
        return this.calculateAverage;
    }

    static {
        REPORTED_VERTEX_METRICS = Set.of(LOAD, TRUE_PROCESSING_RATE, TARGET_DATA_RATE, CATCH_UP_DATA_RATE, LAG, PARALLELISM, RECOMMENDED_PARALLELISM, MAX_PARALLELISM, NUM_SOURCE_PARTITIONS, SCALE_UP_RATE_THRESHOLD, SCALE_DOWN_RATE_THRESHOLD, EXPECTED_PROCESSING_RATE);
    }
}

