/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.autoscaler.metrics;

import java.time.Duration;
import java.time.Instant;
import java.time.temporal.TemporalAmount;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.annotation.Nonnull;
import org.apache.flink.autoscaler.JobAutoScalerContext;
import org.apache.flink.autoscaler.ScalingSummary;
import org.apache.flink.autoscaler.ScalingTracking;
import org.apache.flink.autoscaler.config.AutoScalerOptions;
import org.apache.flink.autoscaler.state.AutoScalerStateStore;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.jobgraph.JobVertexID;

public class ScalingHistoryUtils {
    public static <KEY, Context extends JobAutoScalerContext<KEY>> void addToScalingHistoryAndStore(AutoScalerStateStore<KEY, Context> stateStore, Context context, Instant now, Map<JobVertexID, ScalingSummary> summaries) throws Exception {
        ScalingHistoryUtils.addToScalingHistoryAndStore(stateStore, context, ScalingHistoryUtils.getTrimmedScalingHistory(stateStore, context, now), now, summaries);
    }

    public static <KEY, Context extends JobAutoScalerContext<KEY>> void addToScalingHistoryAndStore(AutoScalerStateStore<KEY, Context> stateStore, Context context, Map<JobVertexID, SortedMap<Instant, ScalingSummary>> scalingHistory, Instant now, Map<JobVertexID, ScalingSummary> summaries) throws Exception {
        summaries.forEach((id, summary) -> scalingHistory.computeIfAbsent((JobVertexID)id, j -> new TreeMap()).put(now, summary));
        stateStore.storeScalingHistory(context, scalingHistory);
    }

    public static <KEY, Context extends JobAutoScalerContext<KEY>> void updateVertexList(AutoScalerStateStore<KEY, Context> stateStore, Context ctx, Instant now, Set<JobVertexID> vertexSet) throws Exception {
        Map<JobVertexID, SortedMap<Instant, ScalingSummary>> trimmedScalingHistory = ScalingHistoryUtils.getTrimmedScalingHistory(stateStore, ctx, now);
        if (trimmedScalingHistory.keySet().removeIf(v -> !vertexSet.contains(v))) {
            stateStore.storeScalingHistory(ctx, trimmedScalingHistory);
        }
    }

    @Nonnull
    public static <KEY, Context extends JobAutoScalerContext<KEY>> Map<JobVertexID, SortedMap<Instant, ScalingSummary>> getTrimmedScalingHistory(AutoScalerStateStore<KEY, Context> autoScalerStateStore, Context context, Instant now) throws Exception {
        Configuration conf = context.getConfiguration();
        return ScalingHistoryUtils.trimScalingHistory(now, conf, autoScalerStateStore.getScalingHistory(context));
    }

    public static Map<JobVertexID, SortedMap<Instant, ScalingSummary>> trimScalingHistory(Instant now, Configuration conf, Map<JobVertexID, SortedMap<Instant, ScalingSummary>> scalingHistory) {
        Instant expectedStartTime = now.minus((TemporalAmount)conf.get(AutoScalerOptions.VERTEX_SCALING_HISTORY_AGE));
        TreeMap<JobVertexID, SortedMap<Instant, ScalingSummary>> result = new TreeMap<JobVertexID, SortedMap<Instant, ScalingSummary>>(scalingHistory);
        Iterator<Map.Entry<JobVertexID, SortedMap<Instant, ScalingSummary>>> entryIt = result.entrySet().iterator();
        while (entryIt.hasNext()) {
            Map.Entry<JobVertexID, SortedMap<Instant, ScalingSummary>> entry = entryIt.next();
            entry.setValue(new TreeMap<Instant, ScalingSummary>(entry.getValue().tailMap(expectedStartTime)));
            SortedMap<Instant, ScalingSummary> vertexHistory = entry.getValue();
            while (vertexHistory.size() > (Integer)conf.get(AutoScalerOptions.VERTEX_SCALING_HISTORY_COUNT)) {
                vertexHistory.remove(vertexHistory.firstKey());
            }
            if (!vertexHistory.isEmpty()) continue;
            entryIt.remove();
        }
        return result;
    }

    @Nonnull
    public static <KEY, Context extends JobAutoScalerContext<KEY>> ScalingTracking getTrimmedScalingTracking(AutoScalerStateStore<KEY, Context> autoScalerStateStore, Context context, Instant now) throws Exception {
        Configuration conf = context.getConfiguration();
        ScalingTracking scalingTracking = autoScalerStateStore.getScalingTracking(context);
        scalingTracking.removeOldRecords(now, (Duration)conf.get(AutoScalerOptions.VERTEX_SCALING_HISTORY_AGE), (Integer)conf.get(AutoScalerOptions.VERTEX_SCALING_HISTORY_COUNT));
        return scalingTracking;
    }
}

