/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.autoscaler.metrics;

import java.util.function.Function;
import org.apache.flink.runtime.rest.messages.job.metrics.AggregatedMetric;

public enum MetricAggregator {
    AVG(AggregatedMetric::getAvg),
    MAX(AggregatedMetric::getMax),
    MIN(AggregatedMetric::getMin);

    private final Function<AggregatedMetric, Double> getter;

    private MetricAggregator(Function<AggregatedMetric, Double> getter) {
        this.getter = getter;
    }

    public double get(AggregatedMetric metric) {
        if (metric != null) {
            return this.getter.apply(metric);
        }
        return Double.NaN;
    }
}

