/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.autoscaler.metrics;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.flink.runtime.rest.messages.job.metrics.AggregatedMetric;

public enum FlinkMetric {
    BUSY_TIME_PER_SEC(s -> s.equals("busyTimeMsPerSecond")),
    SOURCE_TASK_NUM_RECORDS_IN_PER_SEC(s -> s.startsWith("Source__") && s.endsWith(".numRecordsInPerSecond")),
    SOURCE_TASK_NUM_RECORDS_OUT(s -> s.startsWith("Source__") && s.endsWith(".numRecordsOut")),
    SOURCE_TASK_NUM_RECORDS_OUT_PER_SEC(s -> s.startsWith("Source__") && s.endsWith(".numRecordsOutPerSecond")),
    SOURCE_TASK_NUM_RECORDS_IN(s -> s.startsWith("Source__") && s.endsWith(".numRecordsIn")),
    PENDING_RECORDS(s -> s.endsWith(".pendingRecords")),
    BACKPRESSURE_TIME_PER_SEC(s -> s.equals("backPressuredTimeMsPerSecond")),
    HEAP_MEMORY_MAX(s -> s.equals("Status.JVM.Memory.Heap.Max")),
    HEAP_MEMORY_USED(s -> s.equals("Status.JVM.Memory.Heap.Used")),
    MANAGED_MEMORY_USED(s -> s.equals("Status.Flink.Memory.Managed.Used")),
    METASPACE_MEMORY_USED(s -> s.equals("Status.JVM.Memory.Metaspace.Used")),
    TOTAL_GC_TIME_PER_SEC(s -> s.equals("Status.JVM.GarbageCollector.All.TimeMsPerSecond")),
    NUM_TASK_SLOTS_TOTAL(s -> s.equals("taskSlotsTotal")),
    NUM_TASK_SLOTS_AVAILABLE(s -> s.equals("taskSlotsAvailable"));

    public static final Map<FlinkMetric, AggregatedMetric> FINISHED_METRICS;
    public final Predicate<String> predicate;

    private FlinkMetric(Predicate<String> predicate) {
        this.predicate = predicate;
    }

    public Optional<String> findAny(Collection<String> metrics) {
        return metrics.stream().filter(this.predicate).findAny();
    }

    public List<String> findAll(Collection<String> metrics) {
        return metrics.stream().filter(this.predicate).collect(Collectors.toList());
    }

    private static AggregatedMetric zero() {
        return new AggregatedMetric("", 0.0, 0.0, 0.0, 0.0, 0.0);
    }

    static {
        FINISHED_METRICS = Map.of(BUSY_TIME_PER_SEC, FlinkMetric.zero(), PENDING_RECORDS, FlinkMetric.zero(), SOURCE_TASK_NUM_RECORDS_IN_PER_SEC, FlinkMetric.zero(), SOURCE_TASK_NUM_RECORDS_IN, FlinkMetric.zero(), SOURCE_TASK_NUM_RECORDS_OUT, FlinkMetric.zero());
    }
}

