/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.autoscaler.metrics;

import org.apache.flink.autoscaler.metrics.ScalingMetrics;

public class EvaluatedScalingMetric {
    private double current;
    private double average;

    public EvaluatedScalingMetric(double current, double average) {
        this.current = ScalingMetrics.roundMetric(current);
        this.average = ScalingMetrics.roundMetric(average);
    }

    public static EvaluatedScalingMetric of(double current) {
        return new EvaluatedScalingMetric(current, Double.NaN);
    }

    public static EvaluatedScalingMetric avg(double average) {
        return new EvaluatedScalingMetric(Double.NaN, average);
    }

    public double getCurrent() {
        return this.current;
    }

    public double getAverage() {
        return this.average;
    }

    public void setCurrent(double current) {
        this.current = current;
    }

    public void setAverage(double average) {
        this.average = average;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EvaluatedScalingMetric)) {
            return false;
        }
        EvaluatedScalingMetric other = (EvaluatedScalingMetric)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (Double.compare(this.getCurrent(), other.getCurrent()) != 0) {
            return false;
        }
        return Double.compare(this.getAverage(), other.getAverage()) == 0;
    }

    protected boolean canEqual(Object other) {
        return other instanceof EvaluatedScalingMetric;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $current = Double.doubleToLongBits(this.getCurrent());
        result = result * 59 + (int)($current >>> 32 ^ $current);
        long $average = Double.doubleToLongBits(this.getAverage());
        result = result * 59 + (int)($average >>> 32 ^ $average);
        return result;
    }

    public String toString() {
        return "EvaluatedScalingMetric(current=" + this.getCurrent() + ", average=" + this.getAverage() + ")";
    }

    public EvaluatedScalingMetric() {
    }
}

