/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.autoscaler.metrics;

import java.time.Instant;
import java.util.SortedMap;
import org.apache.flink.autoscaler.metrics.CollectedMetrics;
import org.apache.flink.autoscaler.topology.JobTopology;

public class CollectedMetricHistory {
    final JobTopology jobTopology;
    final SortedMap<Instant, CollectedMetrics> metricHistory;
    final Instant jobRunningTs;
    private boolean fullyCollected;

    public CollectedMetricHistory(JobTopology jobTopology, SortedMap<Instant, CollectedMetrics> metricHistory, Instant jobRunningTs) {
        this.jobTopology = jobTopology;
        this.metricHistory = metricHistory;
        this.jobRunningTs = jobRunningTs;
    }

    public JobTopology getJobTopology() {
        return this.jobTopology;
    }

    public SortedMap<Instant, CollectedMetrics> getMetricHistory() {
        return this.metricHistory;
    }

    public Instant getJobRunningTs() {
        return this.jobRunningTs;
    }

    public boolean isFullyCollected() {
        return this.fullyCollected;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CollectedMetricHistory)) {
            return false;
        }
        CollectedMetricHistory other = (CollectedMetricHistory)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isFullyCollected() != other.isFullyCollected()) {
            return false;
        }
        JobTopology this$jobTopology = this.getJobTopology();
        JobTopology other$jobTopology = other.getJobTopology();
        if (this$jobTopology == null ? other$jobTopology != null : !((Object)this$jobTopology).equals(other$jobTopology)) {
            return false;
        }
        SortedMap<Instant, CollectedMetrics> this$metricHistory = this.getMetricHistory();
        SortedMap<Instant, CollectedMetrics> other$metricHistory = other.getMetricHistory();
        if (this$metricHistory == null ? other$metricHistory != null : !this$metricHistory.equals(other$metricHistory)) {
            return false;
        }
        Instant this$jobRunningTs = this.getJobRunningTs();
        Instant other$jobRunningTs = other.getJobRunningTs();
        return !(this$jobRunningTs == null ? other$jobRunningTs != null : !((Object)this$jobRunningTs).equals(other$jobRunningTs));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CollectedMetricHistory;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isFullyCollected() ? 79 : 97);
        JobTopology $jobTopology = this.getJobTopology();
        result = result * 59 + ($jobTopology == null ? 43 : ((Object)$jobTopology).hashCode());
        SortedMap<Instant, CollectedMetrics> $metricHistory = this.getMetricHistory();
        result = result * 59 + ($metricHistory == null ? 43 : $metricHistory.hashCode());
        Instant $jobRunningTs = this.getJobRunningTs();
        result = result * 59 + ($jobRunningTs == null ? 43 : ((Object)$jobRunningTs).hashCode());
        return result;
    }

    public String toString() {
        return "CollectedMetricHistory(jobTopology=" + this.getJobTopology() + ", metricHistory=" + this.getMetricHistory() + ", jobRunningTs=" + this.getJobRunningTs() + ", fullyCollected=" + this.isFullyCollected() + ")";
    }

    public void setFullyCollected(boolean fullyCollected) {
        this.fullyCollected = fullyCollected;
    }
}

