/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.autoscaler.metrics;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.autoscaler.metrics.EvaluatedMetrics;
import org.apache.flink.autoscaler.metrics.EvaluatedScalingMetric;
import org.apache.flink.autoscaler.metrics.ScalingMetric;
import org.apache.flink.metrics.Counter;
import org.apache.flink.metrics.MetricGroup;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AutoscalerFlinkMetrics {
    private static final Logger LOG = LoggerFactory.getLogger(AutoscalerFlinkMetrics.class);
    @VisibleForTesting
    public static final String CURRENT = "Current";
    @VisibleForTesting
    public static final String AVERAGE = "Average";
    @VisibleForTesting
    public static final String JOB_VERTEX_ID = "jobVertexID";
    private final Counter numScalings;
    private final Counter numErrors;
    private final Counter numBalanced;
    private final MetricGroup metricGroup;
    private boolean scalingMetricsInitialized;

    public AutoscalerFlinkMetrics(MetricGroup metricGroup) {
        this.numScalings = metricGroup.counter("scalings");
        this.numErrors = metricGroup.counter("errors");
        this.numBalanced = metricGroup.counter("balanced");
        this.metricGroup = metricGroup;
    }

    public void incrementScaling() {
        this.numScalings.inc();
    }

    public void incrementError() {
        this.numErrors.inc();
    }

    public void incrementBalanced() {
        this.numBalanced.inc();
    }

    public void registerScalingMetrics(List<JobVertexID> jobVertices, Supplier<EvaluatedMetrics> metricsSupplier) {
        if (this.scalingMetricsInitialized) {
            return;
        }
        this.scalingMetricsInitialized = true;
        LOG.info("Registering scaling metrics");
        for (JobVertexID jobVertexID : jobVertices) {
            MetricGroup jobVertexGroup = this.metricGroup.addGroup(JOB_VERTEX_ID, jobVertexID.toHexString());
            for (ScalingMetric scalingMetric : ScalingMetric.REPORTED_VERTEX_METRICS) {
                MetricGroup scalingMetricGroup = jobVertexGroup.addGroup(scalingMetric.name());
                scalingMetricGroup.gauge(CURRENT, () -> Optional.ofNullable((EvaluatedMetrics)metricsSupplier.get()).map(EvaluatedMetrics::getVertexMetrics).map(m -> (Map)m.get(jobVertexID)).map(metrics -> (EvaluatedScalingMetric)metrics.get((Object)scalingMetric)).map(EvaluatedScalingMetric::getCurrent).orElse(Double.NaN));
                if (!scalingMetric.isCalculateAverage()) continue;
                scalingMetricGroup.gauge(AVERAGE, () -> Optional.ofNullable((EvaluatedMetrics)metricsSupplier.get()).map(EvaluatedMetrics::getVertexMetrics).map(m -> (Map)m.get(jobVertexID)).map(metrics -> (EvaluatedScalingMetric)metrics.get((Object)scalingMetric)).map(EvaluatedScalingMetric::getAverage).orElse(Double.NaN));
            }
        }
    }

    public static void initRecommendedParallelism(Map<JobVertexID, Map<ScalingMetric, EvaluatedScalingMetric>> evaluatedMetrics) {
        evaluatedMetrics.forEach((jobVertexID, evaluatedScalingMetricMap) -> evaluatedScalingMetricMap.put(ScalingMetric.RECOMMENDED_PARALLELISM, (EvaluatedScalingMetric)evaluatedScalingMetricMap.get((Object)ScalingMetric.PARALLELISM)));
    }

    @VisibleForTesting
    public static void resetRecommendedParallelism(Map<JobVertexID, Map<ScalingMetric, EvaluatedScalingMetric>> evaluatedMetrics) {
        evaluatedMetrics.forEach((jobVertexID, evaluatedScalingMetricMap) -> evaluatedScalingMetricMap.put(ScalingMetric.RECOMMENDED_PARALLELISM, null));
    }

    @VisibleForTesting
    public long getNumScalingsCount() {
        return this.numScalings.getCount();
    }

    @VisibleForTesting
    public long getNumErrorsCount() {
        return this.numErrors.getCount();
    }

    @VisibleForTesting
    public long getNumBalancedCount() {
        return this.numBalanced.getCount();
    }

    @VisibleForTesting
    public MetricGroup getMetricGroup() {
        return this.metricGroup;
    }
}

