/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.autoscaler.event;

import org.apache.flink.annotation.Experimental;

@Experimental
public class VertexScalingReport {
    private String vertexId;
    private int currentParallelism;
    private int newParallelism;
    private double currentProcessCapacity;
    private double expectedProcessCapacity;
    private double targetDataRate;

    public String getVertexId() {
        return this.vertexId;
    }

    public int getCurrentParallelism() {
        return this.currentParallelism;
    }

    public int getNewParallelism() {
        return this.newParallelism;
    }

    public double getCurrentProcessCapacity() {
        return this.currentProcessCapacity;
    }

    public double getExpectedProcessCapacity() {
        return this.expectedProcessCapacity;
    }

    public double getTargetDataRate() {
        return this.targetDataRate;
    }

    public void setVertexId(String vertexId) {
        this.vertexId = vertexId;
    }

    public void setCurrentParallelism(int currentParallelism) {
        this.currentParallelism = currentParallelism;
    }

    public void setNewParallelism(int newParallelism) {
        this.newParallelism = newParallelism;
    }

    public void setCurrentProcessCapacity(double currentProcessCapacity) {
        this.currentProcessCapacity = currentProcessCapacity;
    }

    public void setExpectedProcessCapacity(double expectedProcessCapacity) {
        this.expectedProcessCapacity = expectedProcessCapacity;
    }

    public void setTargetDataRate(double targetDataRate) {
        this.targetDataRate = targetDataRate;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof VertexScalingReport)) {
            return false;
        }
        VertexScalingReport other = (VertexScalingReport)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getCurrentParallelism() != other.getCurrentParallelism()) {
            return false;
        }
        if (this.getNewParallelism() != other.getNewParallelism()) {
            return false;
        }
        if (Double.compare(this.getCurrentProcessCapacity(), other.getCurrentProcessCapacity()) != 0) {
            return false;
        }
        if (Double.compare(this.getExpectedProcessCapacity(), other.getExpectedProcessCapacity()) != 0) {
            return false;
        }
        if (Double.compare(this.getTargetDataRate(), other.getTargetDataRate()) != 0) {
            return false;
        }
        String this$vertexId = this.getVertexId();
        String other$vertexId = other.getVertexId();
        return !(this$vertexId == null ? other$vertexId != null : !this$vertexId.equals(other$vertexId));
    }

    protected boolean canEqual(Object other) {
        return other instanceof VertexScalingReport;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getCurrentParallelism();
        result = result * 59 + this.getNewParallelism();
        long $currentProcessCapacity = Double.doubleToLongBits(this.getCurrentProcessCapacity());
        result = result * 59 + (int)($currentProcessCapacity >>> 32 ^ $currentProcessCapacity);
        long $expectedProcessCapacity = Double.doubleToLongBits(this.getExpectedProcessCapacity());
        result = result * 59 + (int)($expectedProcessCapacity >>> 32 ^ $expectedProcessCapacity);
        long $targetDataRate = Double.doubleToLongBits(this.getTargetDataRate());
        result = result * 59 + (int)($targetDataRate >>> 32 ^ $targetDataRate);
        String $vertexId = this.getVertexId();
        result = result * 59 + ($vertexId == null ? 43 : $vertexId.hashCode());
        return result;
    }

    public String toString() {
        return "VertexScalingReport(vertexId=" + this.getVertexId() + ", currentParallelism=" + this.getCurrentParallelism() + ", newParallelism=" + this.getNewParallelism() + ", currentProcessCapacity=" + this.getCurrentProcessCapacity() + ", expectedProcessCapacity=" + this.getExpectedProcessCapacity() + ", targetDataRate=" + this.getTargetDataRate() + ")";
    }

    public VertexScalingReport() {
    }

    public VertexScalingReport(String vertexId, int currentParallelism, int newParallelism, double currentProcessCapacity, double expectedProcessCapacity, double targetDataRate) {
        this.vertexId = vertexId;
        this.currentParallelism = currentParallelism;
        this.newParallelism = newParallelism;
        this.currentProcessCapacity = currentProcessCapacity;
        this.expectedProcessCapacity = expectedProcessCapacity;
        this.targetDataRate = targetDataRate;
    }
}

