/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.autoscaler.event;

import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.flink.annotation.Experimental;
import org.apache.flink.autoscaler.event.VertexScalingReport;

@Experimental
public class AutoscalerEventUtils {
    private static final Pattern SCALING_REPORT_SEPARATOR = Pattern.compile("\\{(.+?)\\}");
    private static final Pattern VERTEX_SCALING_REPORT_PATTERN = Pattern.compile("Vertex ID (.*?) \\| Parallelism (.*?) -> (.*?) \\| Processing capacity (.*?) -> (.*?) \\| Target data rate (.*)");

    public static List<VertexScalingReport> parseVertexScalingReports(String scalingReport) {
        List<String> originalVertexScalingReports = AutoscalerEventUtils.extractOriginalVertexScalingReports(scalingReport);
        return originalVertexScalingReports.stream().map(AutoscalerEventUtils::extractVertexScalingReport).collect(Collectors.toList());
    }

    private static List<String> extractOriginalVertexScalingReports(String scalingReport) {
        ArrayList<String> result = new ArrayList<String>();
        Matcher m = SCALING_REPORT_SEPARATOR.matcher(scalingReport);
        while (m.find()) {
            result.add(m.group(1));
        }
        return result;
    }

    private static VertexScalingReport extractVertexScalingReport(String vertexScalingReportStr) {
        VertexScalingReport vertexScalingReport = new VertexScalingReport();
        Matcher m = VERTEX_SCALING_REPORT_PATTERN.matcher(vertexScalingReportStr);
        if (m.find()) {
            vertexScalingReport.setVertexId(m.group(1));
            vertexScalingReport.setCurrentParallelism(Integer.parseInt(m.group(2)));
            vertexScalingReport.setNewParallelism(Integer.parseInt(m.group(3)));
            vertexScalingReport.setCurrentProcessCapacity(AutoscalerEventUtils.convertStringToDouble(m.group(4)));
            vertexScalingReport.setExpectedProcessCapacity(AutoscalerEventUtils.convertStringToDouble(m.group(5)));
            vertexScalingReport.setTargetDataRate(AutoscalerEventUtils.convertStringToDouble(m.group(6)));
        }
        return vertexScalingReport;
    }

    private static double convertStringToDouble(String str) {
        try {
            return NumberFormat.getInstance().parse(str).doubleValue();
        }
        catch (ParseException e) {
            return Double.parseDouble(str);
        }
    }
}

