/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.autoscaler.event;

import java.time.Duration;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.flink.annotation.Experimental;
import org.apache.flink.autoscaler.JobAutoScalerContext;
import org.apache.flink.autoscaler.ScalingSummary;
import org.apache.flink.autoscaler.metrics.ScalingMetric;
import org.apache.flink.runtime.jobgraph.JobVertexID;

@Experimental
public interface AutoScalerEventHandler<KEY, Context extends JobAutoScalerContext<KEY>>
extends AutoCloseable {
    public static final String SCALING_SUMMARY_ENTRY = "{ Vertex ID %s | Parallelism %d -> %d | Processing capacity %.2f -> %.2f | Target data rate %.2f}";
    public static final String SCALING_EXECUTION_DISABLED_REASON = "%s:%s, recommended parallelism change:";
    public static final String SCALING_SUMMARY_HEADER_SCALING_EXECUTION_DISABLED = "Scaling execution disabled by config ";
    public static final String SCALING_SUMMARY_HEADER_SCALING_EXECUTION_ENABLED = "Scaling execution enabled, begin scaling vertices:";
    public static final String SCALING_REPORT_REASON = "ScalingReport";
    public static final String SCALING_REPORT_KEY = "ScalingExecutor";

    public void handleEvent(Context var1, Type var2, String var3, String var4, @Nullable String var5, @Nullable Duration var6);

    default public void handleException(Context context, String reason, Throwable e) {
        String message = e.getMessage();
        if (message == null) {
            message = StringUtils.abbreviate((String)ExceptionUtils.getStackTrace((Throwable)e), (int)2048);
        }
        this.handleEvent(context, Type.Warning, reason, message, null, null);
    }

    default public void handleScalingEvent(Context context, Map<JobVertexID, ScalingSummary> scalingSummaries, String message, Duration interval) {
        String scalingReport = AutoScalerEventHandler.scalingReport(scalingSummaries, message);
        this.handleEvent(context, Type.Normal, SCALING_REPORT_REASON, scalingReport, SCALING_REPORT_KEY, interval);
    }

    public static String scalingReport(Map<JobVertexID, ScalingSummary> scalingSummaries, String message) {
        StringBuilder sb = new StringBuilder(message);
        scalingSummaries.forEach((v, s) -> sb.append(String.format(SCALING_SUMMARY_ENTRY, v, s.getCurrentParallelism(), s.getNewParallelism(), s.getMetrics().get((Object)ScalingMetric.TRUE_PROCESSING_RATE).getAverage(), s.getMetrics().get((Object)ScalingMetric.EXPECTED_PROCESSING_RATE).getCurrent(), s.getMetrics().get((Object)ScalingMetric.TARGET_DATA_RATE).getAverage())));
        return sb.toString();
    }

    public static String getParallelismHashCode(Map<JobVertexID, ScalingSummary> scalingSummaryHashMap) {
        return Integer.toString(scalingSummaryHashMap.entrySet().stream().collect(Collectors.toMap(e -> ((JobVertexID)e.getKey()).toString(), e -> String.format("Parallelism %d -> %d", ((ScalingSummary)e.getValue()).getCurrentParallelism(), ((ScalingSummary)e.getValue()).getNewParallelism()))).hashCode() & Integer.MAX_VALUE);
    }

    public static enum Type {
        Normal,
        Warning;

    }
}

