/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.autoscaler;

import java.time.Duration;
import java.time.Instant;
import java.util.Map;
import java.util.Optional;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.apache.flink.annotation.Experimental;
import org.apache.flink.autoscaler.ScalingRecord;
import org.apache.flink.autoscaler.ScalingSummary;
import org.apache.flink.autoscaler.config.AutoScalerOptions;
import org.apache.flink.autoscaler.topology.JobTopology;
import org.apache.flink.autoscaler.topology.VertexInfo;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonIgnore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Experimental
public class ScalingTracking {
    private static final Logger LOG = LoggerFactory.getLogger(ScalingTracking.class);
    private final TreeMap<Instant, ScalingRecord> scalingRecords = new TreeMap();

    public void addScalingRecord(Instant startTimestamp, ScalingRecord scalingRecord) {
        this.scalingRecords.put(startTimestamp, scalingRecord);
    }

    @JsonIgnore
    public Optional<Map.Entry<Instant, ScalingRecord>> getLatestScalingRecordEntry() {
        if (!this.scalingRecords.isEmpty()) {
            return Optional.of(this.scalingRecords.lastEntry());
        }
        return Optional.empty();
    }

    public boolean recordRestartDurationIfTrackedAndParallelismMatches(Instant jobRunningTs, JobTopology jobTopology, Map<JobVertexID, SortedMap<Instant, ScalingSummary>> scalingHistory) {
        return this.getLatestScalingRecordEntry().map(entry -> {
            ScalingRecord value = (ScalingRecord)entry.getValue();
            Instant scalingTimestamp = (Instant)entry.getKey();
            if (value.getRestartDuration() == null) {
                Map<JobVertexID, Integer> targetParallelism = ScalingTracking.getTargetParallelismOfScaledVertices(scalingTimestamp, scalingHistory);
                if (ScalingTracking.targetParallelismMatchesActual(targetParallelism, jobTopology.getVertexInfos())) {
                    value.setRestartDuration(Duration.between(scalingTimestamp, jobRunningTs));
                    LOG.debug("Recorded restart duration of {} seconds (from {} till {})", new Object[]{Duration.between(scalingTimestamp, jobRunningTs).getSeconds(), scalingTimestamp, jobRunningTs});
                    return true;
                }
            } else {
                LOG.debug("Cannot record restart duration because already set in the latest record: {}", (Object)value.getRestartDuration());
            }
            return false;
        }).orElse(false);
    }

    private static Map<JobVertexID, Integer> getTargetParallelismOfScaledVertices(Instant scalingTimestamp, Map<JobVertexID, SortedMap<Instant, ScalingSummary>> scalingHistory) {
        return scalingHistory.entrySet().stream().filter(entry -> ((SortedMap)entry.getValue()).containsKey(scalingTimestamp)).collect(Collectors.toMap(Map.Entry::getKey, entry -> ((ScalingSummary)((SortedMap)entry.getValue()).get(scalingTimestamp)).getNewParallelism()));
    }

    private static boolean targetParallelismMatchesActual(Map<JobVertexID, Integer> targetParallelisms, Map<JobVertexID, VertexInfo> vertexInfoMap) {
        return targetParallelisms.entrySet().stream().allMatch(entry -> {
            boolean isEqual;
            JobVertexID vertexID = (JobVertexID)entry.getKey();
            Integer targetParallelism = (Integer)entry.getValue();
            VertexInfo vertexInfo = (VertexInfo)vertexInfoMap.get(vertexID);
            int actualParallelism = vertexInfo == null ? -1 : vertexInfo.getParallelism();
            boolean bl = isEqual = actualParallelism == targetParallelism;
            if (!isEqual) {
                LOG.debug("Vertex {} actual parallelism {} does not match target parallelism {}", new Object[]{vertexID, actualParallelism, targetParallelism});
            }
            return isEqual;
        });
    }

    public Duration getMaxRestartTimeOrDefault(Configuration conf) {
        long maxRestartTime = -1L;
        if (((Boolean)conf.get(AutoScalerOptions.PREFER_TRACKED_RESTART_TIME)).booleanValue()) {
            for (Map.Entry<Instant, ScalingRecord> entry : this.scalingRecords.entrySet()) {
                Duration restartDuration = entry.getValue().getRestartDuration();
                if (restartDuration == null) continue;
                maxRestartTime = Math.max(restartDuration.toSeconds(), maxRestartTime);
            }
            LOG.debug("Maximum tracked restart time: {}", (Object)maxRestartTime);
        }
        Duration restartTimeFromConfig = (Duration)conf.get(AutoScalerOptions.RESTART_TIME);
        long maxRestartTimeFromConfig = ((Duration)conf.get(AutoScalerOptions.TRACKED_RESTART_TIME_LIMIT)).toSeconds();
        return maxRestartTime == -1L ? restartTimeFromConfig : Duration.ofSeconds(Math.min(maxRestartTime, maxRestartTimeFromConfig));
    }

    public void removeOldRecords(Instant now, Duration keptTimeSpan, int keptNumRecords) {
        Optional<Map.Entry<Instant, ScalingRecord>> latestRecord = this.getLatestScalingRecordEntry();
        Instant cutoffTime = now.minus(keptTimeSpan);
        this.scalingRecords.headMap(cutoffTime).clear();
        while (this.scalingRecords.size() > keptNumRecords) {
            this.scalingRecords.pollFirstEntry();
        }
        latestRecord.ifPresent(record -> this.scalingRecords.put((Instant)record.getKey(), (ScalingRecord)record.getValue()));
    }

    public static ScalingTrackingBuilder builder() {
        return new ScalingTrackingBuilder();
    }

    public TreeMap<Instant, ScalingRecord> getScalingRecords() {
        return this.scalingRecords;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ScalingTracking)) {
            return false;
        }
        ScalingTracking other = (ScalingTracking)o;
        if (!other.canEqual(this)) {
            return false;
        }
        TreeMap<Instant, ScalingRecord> this$scalingRecords = this.getScalingRecords();
        TreeMap<Instant, ScalingRecord> other$scalingRecords = other.getScalingRecords();
        return !(this$scalingRecords == null ? other$scalingRecords != null : !((Object)this$scalingRecords).equals(other$scalingRecords));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ScalingTracking;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        TreeMap<Instant, ScalingRecord> $scalingRecords = this.getScalingRecords();
        result = result * 59 + ($scalingRecords == null ? 43 : ((Object)$scalingRecords).hashCode());
        return result;
    }

    public String toString() {
        return "ScalingTracking(scalingRecords=" + this.getScalingRecords() + ")";
    }

    public static class ScalingTrackingBuilder {
        ScalingTrackingBuilder() {
        }

        public ScalingTracking build() {
            return new ScalingTracking();
        }

        public String toString() {
            return "ScalingTracking.ScalingTrackingBuilder()";
        }
    }
}

