/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.autoscaler;

import java.util.Map;
import org.apache.flink.autoscaler.metrics.EvaluatedScalingMetric;
import org.apache.flink.autoscaler.metrics.ScalingMetric;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonIgnore;

public class ScalingSummary {
    private int currentParallelism;
    private int newParallelism;
    private Map<ScalingMetric, EvaluatedScalingMetric> metrics;

    public ScalingSummary(int currentParallelism, int newParallelism, Map<ScalingMetric, EvaluatedScalingMetric> metrics) {
        if (currentParallelism == newParallelism) {
            throw new IllegalArgumentException("Current parallelism should not be equal to newParallelism during scaling.");
        }
        this.currentParallelism = currentParallelism;
        this.newParallelism = newParallelism;
        this.metrics = metrics;
    }

    @JsonIgnore
    public boolean isScaledUp() {
        return this.newParallelism > this.currentParallelism;
    }

    public int getCurrentParallelism() {
        return this.currentParallelism;
    }

    public int getNewParallelism() {
        return this.newParallelism;
    }

    public Map<ScalingMetric, EvaluatedScalingMetric> getMetrics() {
        return this.metrics;
    }

    public void setCurrentParallelism(int currentParallelism) {
        this.currentParallelism = currentParallelism;
    }

    public void setNewParallelism(int newParallelism) {
        this.newParallelism = newParallelism;
    }

    public void setMetrics(Map<ScalingMetric, EvaluatedScalingMetric> metrics) {
        this.metrics = metrics;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ScalingSummary)) {
            return false;
        }
        ScalingSummary other = (ScalingSummary)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getCurrentParallelism() != other.getCurrentParallelism()) {
            return false;
        }
        if (this.getNewParallelism() != other.getNewParallelism()) {
            return false;
        }
        Map<ScalingMetric, EvaluatedScalingMetric> this$metrics = this.getMetrics();
        Map<ScalingMetric, EvaluatedScalingMetric> other$metrics = other.getMetrics();
        return !(this$metrics == null ? other$metrics != null : !((Object)this$metrics).equals(other$metrics));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ScalingSummary;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getCurrentParallelism();
        result = result * 59 + this.getNewParallelism();
        Map<ScalingMetric, EvaluatedScalingMetric> $metrics = this.getMetrics();
        result = result * 59 + ($metrics == null ? 43 : ((Object)$metrics).hashCode());
        return result;
    }

    public String toString() {
        return "ScalingSummary(currentParallelism=" + this.getCurrentParallelism() + ", newParallelism=" + this.getNewParallelism() + ", metrics=" + this.getMetrics() + ")";
    }

    public ScalingSummary() {
    }
}

