/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.autoscaler;

import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Experimental;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.JobStatus;
import org.apache.flink.client.program.rest.RestClusterClient;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.MemorySize;
import org.apache.flink.configuration.TaskManagerOptions;
import org.apache.flink.metrics.MetricGroup;
import org.apache.flink.util.function.SupplierWithException;

@Experimental
public class JobAutoScalerContext<KEY> {
    private final KEY jobKey;
    @Nullable
    private final JobID jobID;
    @Nullable
    private final JobStatus jobStatus;
    private final Configuration configuration;
    private final MetricGroup metricGroup;
    private final SupplierWithException<RestClusterClient<String>, Exception> restClientSupplier;

    public Optional<Double> getTaskManagerCpu() {
        return Optional.empty();
    }

    public Optional<MemorySize> getTaskManagerMemory() {
        return Optional.ofNullable((MemorySize)this.getConfiguration().get(TaskManagerOptions.TOTAL_PROCESS_MEMORY));
    }

    public RestClusterClient<String> getRestClusterClient() throws Exception {
        return (RestClusterClient)this.restClientSupplier.get();
    }

    public static <KEY> JobAutoScalerContextBuilder<KEY> builder() {
        return new JobAutoScalerContextBuilder();
    }

    public JobAutoScalerContextBuilder<KEY> toBuilder() {
        return new JobAutoScalerContextBuilder<KEY>().jobKey(this.jobKey).jobID(this.jobID).jobStatus(this.jobStatus).configuration(this.configuration).metricGroup(this.metricGroup).restClientSupplier(this.restClientSupplier);
    }

    public JobAutoScalerContext(KEY jobKey, @Nullable JobID jobID, @Nullable JobStatus jobStatus, Configuration configuration, MetricGroup metricGroup, SupplierWithException<RestClusterClient<String>, Exception> restClientSupplier) {
        this.jobKey = jobKey;
        this.jobID = jobID;
        this.jobStatus = jobStatus;
        this.configuration = configuration;
        this.metricGroup = metricGroup;
        this.restClientSupplier = restClientSupplier;
    }

    public String toString() {
        return "JobAutoScalerContext(jobKey=" + this.getJobKey() + ", jobID=" + this.getJobID() + ", jobStatus=" + this.getJobStatus() + ", configuration=" + this.getConfiguration() + ", metricGroup=" + this.getMetricGroup() + ")";
    }

    public KEY getJobKey() {
        return this.jobKey;
    }

    @Nullable
    public JobID getJobID() {
        return this.jobID;
    }

    @Nullable
    public JobStatus getJobStatus() {
        return this.jobStatus;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public MetricGroup getMetricGroup() {
        return this.metricGroup;
    }

    public static class JobAutoScalerContextBuilder<KEY> {
        private KEY jobKey;
        private JobID jobID;
        private JobStatus jobStatus;
        private Configuration configuration;
        private MetricGroup metricGroup;
        private SupplierWithException<RestClusterClient<String>, Exception> restClientSupplier;

        JobAutoScalerContextBuilder() {
        }

        public JobAutoScalerContextBuilder<KEY> jobKey(KEY jobKey) {
            this.jobKey = jobKey;
            return this;
        }

        public JobAutoScalerContextBuilder<KEY> jobID(@Nullable JobID jobID) {
            this.jobID = jobID;
            return this;
        }

        public JobAutoScalerContextBuilder<KEY> jobStatus(@Nullable JobStatus jobStatus) {
            this.jobStatus = jobStatus;
            return this;
        }

        public JobAutoScalerContextBuilder<KEY> configuration(Configuration configuration) {
            this.configuration = configuration;
            return this;
        }

        public JobAutoScalerContextBuilder<KEY> metricGroup(MetricGroup metricGroup) {
            this.metricGroup = metricGroup;
            return this;
        }

        public JobAutoScalerContextBuilder<KEY> restClientSupplier(SupplierWithException<RestClusterClient<String>, Exception> restClientSupplier) {
            this.restClientSupplier = restClientSupplier;
            return this;
        }

        public JobAutoScalerContext<KEY> build() {
            return new JobAutoScalerContext<KEY>(this.jobKey, this.jobID, this.jobStatus, this.configuration, this.metricGroup, this.restClientSupplier);
        }

        public String toString() {
            return "JobAutoScalerContext.JobAutoScalerContextBuilder(jobKey=" + this.jobKey + ", jobID=" + this.jobID + ", jobStatus=" + this.jobStatus + ", configuration=" + this.configuration + ", metricGroup=" + this.metricGroup + ", restClientSupplier=" + this.restClientSupplier + ")";
        }
    }
}

