/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.autoscaler;

import java.time.Instant;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import javax.annotation.Nonnull;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonIgnore;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.flink.util.Preconditions;

public class DelayedScaleDown {
    private final Map<JobVertexID, VertexDelayedScaleDownInfo> delayedVertices = new HashMap<JobVertexID, VertexDelayedScaleDownInfo>();
    @JsonIgnore
    private boolean updated = false;

    @Nonnull
    public VertexDelayedScaleDownInfo triggerScaleDown(JobVertexID vertex, Instant triggerTime, int parallelism, boolean outsideUtilizationBound) {
        this.updated = true;
        VertexDelayedScaleDownInfo vertexDelayedScaleDownInfo = this.delayedVertices.computeIfAbsent(vertex, k -> new VertexDelayedScaleDownInfo(triggerTime));
        vertexDelayedScaleDownInfo.recordRecommendedParallelism(triggerTime, parallelism, outsideUtilizationBound);
        return vertexDelayedScaleDownInfo;
    }

    void clearVertex(JobVertexID vertex) {
        VertexDelayedScaleDownInfo removed = this.delayedVertices.remove(vertex);
        if (removed != null) {
            this.updated = true;
        }
    }

    void clearAll() {
        if (this.delayedVertices.isEmpty()) {
            return;
        }
        this.delayedVertices.clear();
        this.updated = true;
    }

    public Map<JobVertexID, VertexDelayedScaleDownInfo> getDelayedVertices() {
        return this.delayedVertices;
    }

    public boolean isUpdated() {
        return this.updated;
    }

    public static class VertexDelayedScaleDownInfo {
        private final Instant firstTriggerTime;
        private final LinkedList<RecommendedParallelism> recommendedParallelisms;

        public VertexDelayedScaleDownInfo(Instant firstTriggerTime) {
            this.firstTriggerTime = firstTriggerTime;
            this.recommendedParallelisms = new LinkedList();
        }

        @JsonCreator
        public VertexDelayedScaleDownInfo(@JsonProperty(value="firstTriggerTime") Instant firstTriggerTime, @JsonProperty(value="recommendedParallelisms") LinkedList<RecommendedParallelism> recommendedParallelisms) {
            this.firstTriggerTime = firstTriggerTime;
            this.recommendedParallelisms = recommendedParallelisms;
        }

        public void recordRecommendedParallelism(Instant triggerTime, int parallelism, boolean outsideUtilizationBound) {
            while (!this.recommendedParallelisms.isEmpty() && this.recommendedParallelisms.peekLast().getParallelism() <= parallelism) {
                this.recommendedParallelisms.pollLast();
            }
            this.recommendedParallelisms.addLast(new RecommendedParallelism(triggerTime, parallelism, outsideUtilizationBound));
        }

        @JsonIgnore
        public RecommendedParallelism getMaxRecommendedParallelism(Instant windowStartTime) {
            while (!this.recommendedParallelisms.isEmpty() && this.recommendedParallelisms.peekFirst().getTriggerTime().isBefore(windowStartTime)) {
                this.recommendedParallelisms.pollFirst();
            }
            RecommendedParallelism maxRecommendedParallelism = this.recommendedParallelisms.peekFirst();
            Preconditions.checkState((maxRecommendedParallelism != null ? 1 : 0) != 0, (Object)"The getMaxRecommendedParallelism should be called after triggering a scale down, it may be a bug.");
            return maxRecommendedParallelism;
        }

        public Instant getFirstTriggerTime() {
            return this.firstTriggerTime;
        }

        public LinkedList<RecommendedParallelism> getRecommendedParallelisms() {
            return this.recommendedParallelisms;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof VertexDelayedScaleDownInfo)) {
                return false;
            }
            VertexDelayedScaleDownInfo other = (VertexDelayedScaleDownInfo)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Instant this$firstTriggerTime = this.getFirstTriggerTime();
            Instant other$firstTriggerTime = other.getFirstTriggerTime();
            if (this$firstTriggerTime == null ? other$firstTriggerTime != null : !((Object)this$firstTriggerTime).equals(other$firstTriggerTime)) {
                return false;
            }
            LinkedList<RecommendedParallelism> this$recommendedParallelisms = this.getRecommendedParallelisms();
            LinkedList<RecommendedParallelism> other$recommendedParallelisms = other.getRecommendedParallelisms();
            return !(this$recommendedParallelisms == null ? other$recommendedParallelisms != null : !((Object)this$recommendedParallelisms).equals(other$recommendedParallelisms));
        }

        protected boolean canEqual(Object other) {
            return other instanceof VertexDelayedScaleDownInfo;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Instant $firstTriggerTime = this.getFirstTriggerTime();
            result = result * 59 + ($firstTriggerTime == null ? 43 : ((Object)$firstTriggerTime).hashCode());
            LinkedList<RecommendedParallelism> $recommendedParallelisms = this.getRecommendedParallelisms();
            result = result * 59 + ($recommendedParallelisms == null ? 43 : ((Object)$recommendedParallelisms).hashCode());
            return result;
        }

        public String toString() {
            return "DelayedScaleDown.VertexDelayedScaleDownInfo(firstTriggerTime=" + this.getFirstTriggerTime() + ", recommendedParallelisms=" + this.getRecommendedParallelisms() + ")";
        }
    }

    public static class RecommendedParallelism {
        @Nonnull
        private final Instant triggerTime;
        private final int parallelism;
        private final boolean outsideUtilizationBound;

        @JsonCreator
        public RecommendedParallelism(@Nonnull @JsonProperty(value="triggerTime") Instant triggerTime, @JsonProperty(value="parallelism") int parallelism, @JsonProperty(value="outsideUtilizationBound") boolean outsideUtilizationBound) {
            this.triggerTime = triggerTime;
            this.parallelism = parallelism;
            this.outsideUtilizationBound = outsideUtilizationBound;
        }

        @Nonnull
        public Instant getTriggerTime() {
            return this.triggerTime;
        }

        public int getParallelism() {
            return this.parallelism;
        }

        public boolean isOutsideUtilizationBound() {
            return this.outsideUtilizationBound;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof RecommendedParallelism)) {
                return false;
            }
            RecommendedParallelism other = (RecommendedParallelism)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getParallelism() != other.getParallelism()) {
                return false;
            }
            if (this.isOutsideUtilizationBound() != other.isOutsideUtilizationBound()) {
                return false;
            }
            Instant this$triggerTime = this.getTriggerTime();
            Instant other$triggerTime = other.getTriggerTime();
            return !(this$triggerTime == null ? other$triggerTime != null : !((Object)this$triggerTime).equals(other$triggerTime));
        }

        protected boolean canEqual(Object other) {
            return other instanceof RecommendedParallelism;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getParallelism();
            result = result * 59 + (this.isOutsideUtilizationBound() ? 79 : 97);
            Instant $triggerTime = this.getTriggerTime();
            result = result * 59 + ($triggerTime == null ? 43 : ((Object)$triggerTime).hashCode());
            return result;
        }

        public String toString() {
            return "DelayedScaleDown.RecommendedParallelism(triggerTime=" + this.getTriggerTime() + ", parallelism=" + this.getParallelism() + ", outsideUtilizationBound=" + this.isOutsideUtilizationBound() + ")";
        }
    }
}

