/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.architecture.rules;

import com.tngtech.archunit.base.DescribedPredicate;
import com.tngtech.archunit.core.domain.JavaClass;
import com.tngtech.archunit.junit.ArchTag;
import com.tngtech.archunit.junit.ArchTags;
import com.tngtech.archunit.junit.ArchTest;
import com.tngtech.archunit.lang.ArchRule;
import com.tngtech.archunit.lang.syntax.elements.GivenClassesConjunction;
import com.tngtech.archunit.library.freeze.FreezingArchRule;
import com.tngtech.archunit.thirdparty.com.google.common.base.Joiner;
import org.apache.flink.annotation.Public;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.architecture.common.GivenJavaClasses;
import org.apache.flink.architecture.common.Predicates;

public class ConnectorRules {
    private static final String[] CONNECTOR_PACKAGES = new String[]{"org.apache.flink.connector..", "org.apache.flink.streaming.connectors.."};
    private static final String[] UTIL_PACKAGES = new String[]{"org.apache.flink.util.."};
    @ArchTest
    @ArchTags(value={@ArchTag(value="org.apache.flink.testutils.junit.FailsOnJava11"), @ArchTag(value="org.apache.flink.testutils.junit.FailsOnJava17")})
    public static final ArchRule CONNECTOR_CLASSES_ONLY_DEPEND_ON_PUBLIC_API = FreezingArchRule.freeze((ArchRule)((ArchRule)((GivenClassesConjunction)GivenJavaClasses.javaClassesThat((DescribedPredicate)JavaClass.Predicates.resideInAnyPackage((String[])CONNECTOR_PACKAGES)).and().areNotAnnotatedWith(Deprecated.class)).should().onlyDependOnClassesThat(ConnectorRules.areFlinkClassesThatResideOutsideOfConnectorPackagesAndArePublic().or(JavaClass.Predicates.resideOutsideOfPackages((String[])new String[]{"org.apache.flink.."})).or(JavaClass.Predicates.resideInAnyPackage((String[])CONNECTOR_PACKAGES)).or(JavaClass.Predicates.resideInAnyPackage((String[])UTIL_PACKAGES))).as("Connector production code must depend only on public API when outside of connector packages")));

    private static DescribedPredicate<JavaClass> areFlinkClassesThatResideOutsideOfConnectorPackagesAndArePublic() {
        return JavaClass.Predicates.resideInAPackage((String)"org.apache.flink..").and(JavaClass.Predicates.resideOutsideOfPackages((String[])CONNECTOR_PACKAGES)).and(Predicates.areDirectlyAnnotatedWithAtLeastOneOf((Class[])new Class[]{Public.class, PublicEvolving.class}).or(ConnectorRules.areEnclosedInPublicClasses())).as("are flink classes that reside outside of connector packages and that are public", new Object[]{Joiner.on((String)"', '").join((Object[])CONNECTOR_PACKAGES)});
    }

    private static DescribedPredicate<JavaClass> areEnclosedInPublicClasses() {
        return JavaClass.Predicates.belongTo((DescribedPredicate)Predicates.areDirectlyAnnotatedWithAtLeastOneOf((Class[])new Class[]{Public.class, PublicEvolving.class})).as("are enclosed in public classes", new Object[0]);
    }
}

