/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.architecture.rules;

import com.tngtech.archunit.base.DescribedPredicate;
import com.tngtech.archunit.core.domain.JavaClass;
import com.tngtech.archunit.junit.ArchTest;
import com.tngtech.archunit.lang.ArchRule;
import com.tngtech.archunit.lang.syntax.ArchRuleDefinition;
import com.tngtech.archunit.lang.syntax.elements.FieldsShouldConjunction;
import com.tngtech.archunit.lang.syntax.elements.GivenClassesConjunction;
import com.tngtech.archunit.lang.syntax.elements.GivenFieldsConjunction;
import com.tngtech.archunit.library.freeze.FreezingArchRule;
import org.apache.flink.annotation.Public;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.architecture.common.Conditions;
import org.apache.flink.architecture.common.GivenJavaClasses;
import org.apache.flink.architecture.common.Predicates;
import org.apache.flink.architecture.common.SourcePredicates;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.table.factories.DynamicTableFactory;
import org.apache.flink.table.factories.FactoryUtil;

public class TableApiRules {
    @ArchTest
    public static final ArchRule CONFIG_OPTIONS_IN_OPTIONS_CLASSES = ((FieldsShouldConjunction)((GivenFieldsConjunction)ArchRuleDefinition.fields().that(Predicates.arePublicStaticOfType(ConfigOption.class)).and().areDeclaredInClassesThat(SourcePredicates.areJavaClasses().and(JavaClass.Predicates.resideInAPackage((String)"org.apache.flink.table..")))).should().beDeclaredInClassesThat().haveSimpleNameEndingWith("Options")).orShould().beDeclaredIn(FactoryUtil.class);
    @ArchTest
    public static final ArchRule TABLE_FACTORIES_CONTAIN_NO_CONFIG_OPTIONS = (ArchRule)((GivenFieldsConjunction)ArchRuleDefinition.noFields().that(Predicates.arePublicStaticOfType(ConfigOption.class)).and().areDeclaredInClassesThat(SourcePredicates.areJavaClasses().and(JavaClass.Predicates.resideInAPackage((String)"org.apache.flink.table..")))).should().beDeclaredInClassesThat().implement(DynamicTableFactory.class);
    @ArchTest
    public static final ArchRule CONNECTOR_OPTIONS_PACKAGE = FreezingArchRule.freeze((ArchRule)((ArchRule)((GivenClassesConjunction)((GivenClassesConjunction)((GivenClassesConjunction)GivenJavaClasses.javaClassesThat().haveSimpleNameEndingWith("ConnectorOptions")).or().haveSimpleNameEndingWith("FormatOptions")).and().haveSimpleNameNotContaining("Json")).should().resideInAPackage("org.apache.flink..table").andShould(Conditions.fulfill((DescribedPredicate)Predicates.areDirectlyAnnotatedWithAtLeastOneOf((Class[])new Class[]{PublicEvolving.class, Public.class}))).as("Options for connectors and formats should reside in a consistent package and be public API.")));
}

