/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.architecture.common;

import com.tngtech.archunit.base.DescribedPredicate;
import com.tngtech.archunit.core.domain.JavaClass;
import com.tngtech.archunit.core.domain.JavaField;
import com.tngtech.archunit.core.domain.JavaModifier;
import com.tngtech.archunit.core.domain.properties.CanBeAnnotated;
import com.tngtech.archunit.lang.conditions.ArchPredicates;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.flink.architecture.common.JavaFieldPredicates;

public class Predicates {
    @SafeVarargs
    public static DescribedPredicate<JavaClass> areDirectlyAnnotatedWithAtLeastOneOf(Class<? extends Annotation> ... annotations) {
        return Arrays.stream(annotations).map(CanBeAnnotated.Predicates::annotatedWith).reduce((p, pOther) -> p.or(pOther)).orElseThrow(IllegalArgumentException::new).forSubtype();
    }

    public static DescribedPredicate<JavaClass> containAnyFieldsInClassHierarchyThat(DescribedPredicate<? super JavaField> predicate) {
        return new ContainAnyFieldsThatPredicate<JavaField>("fields", JavaClass::getAllFields, predicate);
    }

    public static DescribedPredicate<JavaField> arePublicStaticOfType(Class<?> clazz) {
        return Predicates.areFieldOfType(clazz, JavaModifier.PUBLIC, JavaModifier.STATIC);
    }

    public static DescribedPredicate<JavaField> areFieldOfType(Class<?> clazz, JavaModifier ... modifiers) {
        return DescribedPredicate.describe((String)String.format("are %s, and of type %s", Arrays.stream(modifiers).map(Enum::toString).map(String::toLowerCase).collect(Collectors.joining(", ")), clazz.getSimpleName()), field -> field.getModifiers().containsAll(Arrays.asList(modifiers)) && field.getRawType().isEquivalentTo(clazz));
    }

    public static DescribedPredicate<JavaField> arePublicFinalOfType(Class<?> clazz) {
        return ArchPredicates.is(JavaFieldPredicates.ofType(clazz)).and(JavaFieldPredicates.isPublic()).and(JavaFieldPredicates.isFinal()).and(JavaFieldPredicates.isNotStatic());
    }

    public static DescribedPredicate<JavaField> arePublicStaticFinalAssignableTo(Class<?> clazz) {
        return ArchPredicates.is(JavaFieldPredicates.isAssignableTo(clazz)).and(JavaFieldPredicates.isPublic()).and(JavaFieldPredicates.isStatic()).and(JavaFieldPredicates.isFinal());
    }

    public static DescribedPredicate<JavaField> arePublicStaticFinalOfType(Class<?> clazz) {
        return Predicates.arePublicStaticOfType(clazz).and(JavaFieldPredicates.isFinal());
    }

    public static DescribedPredicate<JavaField> arePublicFinalOfTypeWithAnnotation(Class<?> clazz, Class<? extends Annotation> annotationType) {
        return Predicates.arePublicFinalOfType(clazz).and(JavaFieldPredicates.annotatedWith(annotationType));
    }

    public static DescribedPredicate<JavaField> arePublicStaticFinalOfTypeWithAnnotation(Class<?> clazz, Class<? extends Annotation> annotationType) {
        return Predicates.arePublicStaticFinalOfType(clazz).and(JavaFieldPredicates.annotatedWith(annotationType));
    }

    public static DescribedPredicate<JavaField> areStaticFinalOfTypeWithAnnotation(Class<?> clazz, Class<? extends Annotation> annotationType) {
        return Predicates.areFieldOfType(clazz, JavaModifier.STATIC, JavaModifier.FINAL).and(JavaFieldPredicates.annotatedWith(annotationType));
    }

    @SafeVarargs
    public static <T> DescribedPredicate<T> exactlyOneOf(DescribedPredicate<? super T> ... other) {
        return DescribedPredicate.describe((String)("only one of the following predicates match:\n" + Arrays.stream(other).map(dp -> "* " + dp + "\n").collect(Collectors.joining())), t -> Arrays.stream(other).map(dp -> dp.test(t)).reduce(false, Boolean::logicalXor));
    }

    private Predicates() {
    }

    private static class ContainAnyFieldsThatPredicate<T extends JavaField>
    extends DescribedPredicate<JavaClass> {
        private final Function<JavaClass, Set<T>> getFields;
        private final DescribedPredicate<? super T> predicate;

        ContainAnyFieldsThatPredicate(String fieldDescription, Function<JavaClass, Set<T>> getFields, DescribedPredicate<? super T> predicate) {
            super("contain any " + fieldDescription + " that " + predicate.getDescription(), new Object[0]);
            this.getFields = getFields;
            this.predicate = predicate;
        }

        public boolean test(JavaClass input) {
            for (JavaField member : this.getFields.apply(input)) {
                if (!this.predicate.test((Object)member)) continue;
                return true;
            }
            return false;
        }
    }
}

