/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.webconsole.internal.core;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.apache.felix.webconsole.SimpleWebConsolePlugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;
import org.osgi.service.packageadmin.PackageAdmin;

abstract class BaseUpdateInstallHelper
implements Runnable {
    private final SimpleWebConsolePlugin plugin;
    private final File bundleFile;
    private final boolean refreshPackages;
    private Thread updateThread;
    static /* synthetic */ Class class$org$osgi$service$packageadmin$PackageAdmin;

    BaseUpdateInstallHelper(SimpleWebConsolePlugin plugin, String name, File bundleFile, boolean refreshPackages) {
        this.plugin = plugin;
        this.bundleFile = bundleFile;
        this.refreshPackages = refreshPackages;
        this.updateThread = new Thread((Runnable)this, name);
        this.updateThread.setDaemon(true);
    }

    protected File getBundleFile() {
        return this.bundleFile;
    }

    protected abstract Bundle doRun(InputStream var1) throws BundleException;

    protected final Object getService(String serviceName) {
        return this.plugin.getService(serviceName);
    }

    protected final SimpleWebConsolePlugin getLog() {
        return this.plugin;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Bundle doRun() throws Exception {
        Bundle bundle;
        FileInputStream bundleStream = null;
        try {
            bundleStream = new FileInputStream(this.bundleFile);
            bundle = this.doRun(bundleStream);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(bundleStream);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)bundleStream);
        return bundle;
    }

    final void start() {
        if (this.updateThread != null) {
            this.updateThread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void run() {
        this.sleepSilently(500L);
        try {
            PackageAdmin pa = this.refreshPackages ? (PackageAdmin)this.getService((class$org$osgi$service$packageadmin$PackageAdmin == null ? (class$org$osgi$service$packageadmin$PackageAdmin = BaseUpdateInstallHelper.class$("org.osgi.service.packageadmin.PackageAdmin")) : class$org$osgi$service$packageadmin$PackageAdmin).getName()) : null;
            Bundle bundle = this.doRun();
            if (pa != null && bundle != null) {
                this.sleepSilently(2000L);
                pa.refreshPackages(new Bundle[]{bundle});
            }
        }
        catch (Exception ioe) {
            this.getLog().log(1, "Cannot install or update bundle from " + this.bundleFile, ioe);
        }
        finally {
            if (this.bundleFile != null) {
                this.bundleFile.delete();
            }
            this.updateThread = null;
        }
    }

    protected void sleepSilently(long msecs) {
        try {
            Thread.sleep(msecs);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

