/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.webconsole.internal.servlet;

import java.io.IOException;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.GenericServlet;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.felix.webconsole.AbstractWebConsolePlugin;
import org.apache.felix.webconsole.Action;
import org.apache.felix.webconsole.Render;
import org.apache.felix.webconsole.internal.Logger;
import org.apache.felix.webconsole.internal.OsgiManagerPlugin;
import org.apache.felix.webconsole.internal.servlet.ConfigurationListener;
import org.apache.felix.webconsole.internal.servlet.OsgiManagerHttpContext;
import org.apache.felix.webconsole.internal.servlet.RenderBridge;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.http.HttpContext;
import org.osgi.service.http.HttpService;
import org.osgi.util.tracker.ServiceTracker;

public class OsgiManager
extends GenericServlet {
    private static final long serialVersionUID = 1L;
    public static final String ATTR_LABEL_MAP = (class$org$apache$felix$webconsole$internal$servlet$OsgiManager == null ? (class$org$apache$felix$webconsole$internal$servlet$OsgiManager = OsgiManager.class$("org.apache.felix.webconsole.internal.servlet.OsgiManager")) : class$org$apache$felix$webconsole$internal$servlet$OsgiManager).getName() + ".labelMap";
    public static final String ATTR_APP_ROOT = (class$org$apache$felix$webconsole$internal$servlet$OsgiManager == null ? (class$org$apache$felix$webconsole$internal$servlet$OsgiManager = OsgiManager.class$("org.apache.felix.webconsole.internal.servlet.OsgiManager")) : class$org$apache$felix$webconsole$internal$servlet$OsgiManager).getName() + ".appRoot";
    public static final String PARAM_NO_REDIRECT_AFTER_ACTION = "_noredir_";
    private static final String PROP_MANAGER_ROOT = "manager.root";
    private static final String PROP_DEFAULT_RENDER = "default.render";
    private static final String PROP_REALM = "realm";
    private static final String PROP_USER_NAME = "username";
    private static final String PROP_PASSWORD = "password";
    private static final String DEFAULT_PAGE = "bundles";
    private static final String DEFAULT_REALM = "OSGi Management Console";
    private static final String DEFAULT_USER_NAME = "admin";
    private static final String DEFAULT_PASSWORD = "admin";
    private static final String DEFAULT_MANAGER_ROOT = "/system/console";
    private static final Class[] PLUGIN_CLASSES = new Class[]{class$org$apache$felix$webconsole$internal$compendium$ComponentConfigurationPrinter == null ? (class$org$apache$felix$webconsole$internal$compendium$ComponentConfigurationPrinter = OsgiManager.class$("org.apache.felix.webconsole.internal.compendium.ComponentConfigurationPrinter")) : class$org$apache$felix$webconsole$internal$compendium$ComponentConfigurationPrinter, class$org$apache$felix$webconsole$internal$compendium$ComponentsServlet == null ? (class$org$apache$felix$webconsole$internal$compendium$ComponentsServlet = OsgiManager.class$("org.apache.felix.webconsole.internal.compendium.ComponentsServlet")) : class$org$apache$felix$webconsole$internal$compendium$ComponentsServlet, class$org$apache$felix$webconsole$internal$compendium$ConfigManager == null ? (class$org$apache$felix$webconsole$internal$compendium$ConfigManager = OsgiManager.class$("org.apache.felix.webconsole.internal.compendium.ConfigManager")) : class$org$apache$felix$webconsole$internal$compendium$ConfigManager, class$org$apache$felix$webconsole$internal$core$BundlesServlet == null ? (class$org$apache$felix$webconsole$internal$core$BundlesServlet = OsgiManager.class$("org.apache.felix.webconsole.internal.core.BundlesServlet")) : class$org$apache$felix$webconsole$internal$core$BundlesServlet, class$org$apache$felix$webconsole$internal$core$InstallAction == null ? (class$org$apache$felix$webconsole$internal$core$InstallAction = OsgiManager.class$("org.apache.felix.webconsole.internal.core.InstallAction")) : class$org$apache$felix$webconsole$internal$core$InstallAction, class$org$apache$felix$webconsole$internal$core$SetStartLevelAction == null ? (class$org$apache$felix$webconsole$internal$core$SetStartLevelAction = OsgiManager.class$("org.apache.felix.webconsole.internal.core.SetStartLevelAction")) : class$org$apache$felix$webconsole$internal$core$SetStartLevelAction, class$org$apache$felix$webconsole$internal$misc$ConfigurationRender == null ? (class$org$apache$felix$webconsole$internal$misc$ConfigurationRender = OsgiManager.class$("org.apache.felix.webconsole.internal.misc.ConfigurationRender")) : class$org$apache$felix$webconsole$internal$misc$ConfigurationRender, class$org$apache$felix$webconsole$internal$system$GCAction == null ? (class$org$apache$felix$webconsole$internal$system$GCAction = OsgiManager.class$("org.apache.felix.webconsole.internal.system.GCAction")) : class$org$apache$felix$webconsole$internal$system$GCAction, class$org$apache$felix$webconsole$internal$system$ShutdownAction == null ? (class$org$apache$felix$webconsole$internal$system$ShutdownAction = OsgiManager.class$("org.apache.felix.webconsole.internal.system.ShutdownAction")) : class$org$apache$felix$webconsole$internal$system$ShutdownAction, class$org$apache$felix$webconsole$internal$system$ShutdownRender == null ? (class$org$apache$felix$webconsole$internal$system$ShutdownRender = OsgiManager.class$("org.apache.felix.webconsole.internal.system.ShutdownRender")) : class$org$apache$felix$webconsole$internal$system$ShutdownRender, class$org$apache$felix$webconsole$internal$system$VMStatRender == null ? (class$org$apache$felix$webconsole$internal$system$VMStatRender = OsgiManager.class$("org.apache.felix.webconsole.internal.system.VMStatRender")) : class$org$apache$felix$webconsole$internal$system$VMStatRender, class$org$apache$felix$webconsole$internal$obr$BundleRepositoryRender == null ? (class$org$apache$felix$webconsole$internal$obr$BundleRepositoryRender = OsgiManager.class$("org.apache.felix.webconsole.internal.obr.BundleRepositoryRender")) : class$org$apache$felix$webconsole$internal$obr$BundleRepositoryRender, class$org$apache$felix$webconsole$internal$misc$LicenseServlet == null ? (class$org$apache$felix$webconsole$internal$misc$LicenseServlet = OsgiManager.class$("org.apache.felix.webconsole.internal.misc.LicenseServlet")) : class$org$apache$felix$webconsole$internal$misc$LicenseServlet, class$org$apache$felix$webconsole$internal$obr$RefreshRepoAction == null ? (class$org$apache$felix$webconsole$internal$obr$RefreshRepoAction = OsgiManager.class$("org.apache.felix.webconsole.internal.obr.RefreshRepoAction")) : class$org$apache$felix$webconsole$internal$obr$RefreshRepoAction, class$org$apache$felix$webconsole$internal$obr$InstallFromRepoAction == null ? (class$org$apache$felix$webconsole$internal$obr$InstallFromRepoAction = OsgiManager.class$("org.apache.felix.webconsole.internal.obr.InstallFromRepoAction")) : class$org$apache$felix$webconsole$internal$obr$InstallFromRepoAction, class$org$apache$felix$webconsole$internal$misc$ShellServlet == null ? (class$org$apache$felix$webconsole$internal$misc$ShellServlet = OsgiManager.class$("org.apache.felix.webconsole.internal.misc.ShellServlet")) : class$org$apache$felix$webconsole$internal$misc$ShellServlet};
    private BundleContext bundleContext;
    private Logger log;
    private ServiceTracker httpServiceTracker;
    private HttpService httpService;
    private ServiceTracker operationsTracker;
    private ServiceTracker rendersTracker;
    private ServiceTracker pluginsTracker;
    private ServiceRegistration configurationListener;
    private Map plugins = new HashMap();
    private Map labelMap = new HashMap();
    private Map operations = new HashMap();
    private Servlet defaultRender;
    private String defaultRenderName;
    private String webManagerRoot;
    private Dictionary configuration;
    static /* synthetic */ Class class$org$apache$felix$webconsole$internal$servlet$OsgiManager;
    static /* synthetic */ Class class$org$apache$felix$webconsole$internal$compendium$ComponentConfigurationPrinter;
    static /* synthetic */ Class class$org$apache$felix$webconsole$internal$compendium$ComponentsServlet;
    static /* synthetic */ Class class$org$apache$felix$webconsole$internal$compendium$ConfigManager;
    static /* synthetic */ Class class$org$apache$felix$webconsole$internal$core$BundlesServlet;
    static /* synthetic */ Class class$org$apache$felix$webconsole$internal$core$InstallAction;
    static /* synthetic */ Class class$org$apache$felix$webconsole$internal$core$SetStartLevelAction;
    static /* synthetic */ Class class$org$apache$felix$webconsole$internal$misc$ConfigurationRender;
    static /* synthetic */ Class class$org$apache$felix$webconsole$internal$system$GCAction;
    static /* synthetic */ Class class$org$apache$felix$webconsole$internal$system$ShutdownAction;
    static /* synthetic */ Class class$org$apache$felix$webconsole$internal$system$ShutdownRender;
    static /* synthetic */ Class class$org$apache$felix$webconsole$internal$system$VMStatRender;
    static /* synthetic */ Class class$org$apache$felix$webconsole$internal$obr$BundleRepositoryRender;
    static /* synthetic */ Class class$org$apache$felix$webconsole$internal$misc$LicenseServlet;
    static /* synthetic */ Class class$org$apache$felix$webconsole$internal$obr$RefreshRepoAction;
    static /* synthetic */ Class class$org$apache$felix$webconsole$internal$obr$InstallFromRepoAction;
    static /* synthetic */ Class class$org$apache$felix$webconsole$internal$misc$ShellServlet;
    static /* synthetic */ Class class$org$osgi$service$http$HttpService;

    public OsgiManager(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
        this.log = new Logger(bundleContext);
        this.updateConfiguration(null);
        try {
            this.configurationListener = ConfigurationListener.create(this);
        }
        catch (Throwable t) {
            // empty catch block
        }
        this.operationsTracker = new OperationServiceTracker(this);
        this.operationsTracker.open();
        this.rendersTracker = new RenderServiceTracker(this);
        this.rendersTracker.open();
        this.pluginsTracker = new PluginServiceTracker(this);
        this.pluginsTracker.open();
        this.httpServiceTracker = new HttpServiceTracker(this);
        this.httpServiceTracker.open();
        for (int i = 0; i < PLUGIN_CLASSES.length; ++i) {
            Class pluginClass = PLUGIN_CLASSES[i];
            try {
                Object plugin = pluginClass.newInstance();
                if (plugin instanceof OsgiManagerPlugin) {
                    ((OsgiManagerPlugin)plugin).activate(bundleContext);
                }
                if (plugin instanceof AbstractWebConsolePlugin) {
                    AbstractWebConsolePlugin amp = (AbstractWebConsolePlugin)((Object)plugin);
                    this.bindServlet(amp.getLabel(), (Servlet)amp);
                    continue;
                }
                if (plugin instanceof Action) {
                    this.bindOperation((Action)plugin);
                }
                if (!(plugin instanceof Render)) continue;
                this.bindRender((Render)plugin);
                continue;
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
    }

    public void dispose() {
        if (this.configurationListener != null) {
            this.configurationListener.unregister();
            this.configurationListener = null;
        }
        if (this.operationsTracker != null) {
            this.operationsTracker.close();
            this.operationsTracker = null;
        }
        if (this.rendersTracker != null) {
            this.rendersTracker.close();
            this.rendersTracker = null;
        }
        if (this.pluginsTracker != null) {
            this.pluginsTracker.close();
            this.pluginsTracker = null;
        }
        if (this.httpServiceTracker != null) {
            this.httpServiceTracker.close();
            this.httpServiceTracker = null;
        }
        Iterator pi = this.plugins.values().iterator();
        while (pi.hasNext()) {
            Object plugin = pi.next();
            if (!(plugin instanceof OsgiManagerPlugin)) continue;
            ((OsgiManagerPlugin)plugin).deactivate();
        }
        this.defaultRender = null;
        this.plugins.clear();
        this.labelMap.clear();
        this.operations.clear();
        if (this.log != null) {
            this.log.dispose();
        }
        this.bundleContext = null;
    }

    public void service(ServletRequest req, ServletResponse res) throws ServletException, IOException {
        Servlet plugin;
        HttpServletRequest request = (HttpServletRequest)req;
        HttpServletResponse response = (HttpServletResponse)res;
        if (this.handleAction(request, response)) {
            return;
        }
        if (request.getPathInfo() == null || request.getPathInfo().equals("/")) {
            String path = request.getRequestURI();
            if (!path.endsWith("/")) {
                path = path.concat("/");
            }
            path = path.concat(this.defaultRenderName);
            response.sendRedirect(path);
            return;
        }
        String label = request.getPathInfo();
        int slash = label.indexOf("/", 1);
        if (slash < 2) {
            slash = label.length();
        }
        if ((plugin = (Servlet)this.plugins.get(label = label.substring(1, slash))) == null) {
            response.sendError(404);
            return;
        }
        req.setAttribute(ATTR_LABEL_MAP, (Object)this.labelMap);
        req.setAttribute(ATTR_APP_ROOT, (Object)(request.getContextPath() + request.getServletPath()));
        plugin.service(req, res);
    }

    protected boolean handleAction(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        Action action;
        String actionName = AbstractWebConsolePlugin.getParameter(req, "action");
        if (actionName != null && (action = (Action)this.operations.get(actionName)) != null) {
            boolean redirect = true;
            try {
                redirect = action.performAction(req, resp);
            }
            catch (IOException ioe) {
                this.log(ioe.getMessage(), ioe);
            }
            catch (ServletException se) {
                this.log(se.getMessage(), se.getRootCause());
            }
            if (PARAM_NO_REDIRECT_AFTER_ACTION.equals(AbstractWebConsolePlugin.getParameter(req, PARAM_NO_REDIRECT_AFTER_ACTION))) {
                resp.setStatus(200);
                resp.setContentType("text/html");
                resp.getWriter().println("Ok");
                return true;
            }
            if (redirect) {
                String uri = req.getRequestURI();
                resp.sendRedirect(uri);
            }
            return true;
        }
        return false;
    }

    BundleContext getBundleContext() {
        return this.bundleContext;
    }

    protected synchronized void bindHttpService(HttpService httpService) {
        Dictionary config = this.getConfiguration();
        String realm = this.getProperty(config, PROP_REALM, DEFAULT_REALM);
        String userId = this.getProperty(config, PROP_USER_NAME, "admin");
        String password = this.getProperty(config, PROP_PASSWORD, "admin");
        try {
            OsgiManagerHttpContext httpContext = new OsgiManagerHttpContext(httpService, realm, userId, password);
            Dictionary servletConfig = this.toStringConfig(config);
            httpService.registerServlet(this.webManagerRoot, (Servlet)this, servletConfig, (HttpContext)httpContext);
            httpService.registerResources(this.webManagerRoot + "/res", "/res", (HttpContext)httpContext);
        }
        catch (Exception e) {
            this.log.log(1, "Problem setting up", e);
        }
        this.httpService = httpService;
    }

    protected synchronized void unbindHttpService(HttpService httpService) {
        httpService.unregister(this.webManagerRoot + "/res");
        httpService.unregister(this.webManagerRoot);
        if (this.httpService == httpService) {
            this.httpService = null;
        }
    }

    protected void bindServlet(String label, Servlet servlet) {
        try {
            String title;
            servlet.init(this.getServletConfig());
            this.plugins.put(label, servlet);
            if (servlet instanceof GenericServlet && (title = ((GenericServlet)servlet).getServletName()) != null) {
                this.labelMap.put(label, title);
            }
            if (this.defaultRender == null) {
                this.defaultRender = servlet;
            } else if (label.equals(this.defaultRenderName)) {
                this.defaultRender = servlet;
            }
        }
        catch (ServletException servletException) {
            // empty catch block
        }
    }

    protected void unbindServlet(String label) {
        Servlet servlet = (Servlet)this.plugins.remove(label);
        if (servlet != null) {
            this.labelMap.remove(label);
            if (this.defaultRender == servlet) {
                this.defaultRender = this.plugins.isEmpty() ? null : (Servlet)this.plugins.values().iterator().next();
            }
            servlet.destroy();
        }
    }

    protected void bindOperation(Action operation) {
        this.operations.put(operation.getName(), operation);
    }

    protected void unbindOperation(Action operation) {
        this.operations.remove(operation.getName());
    }

    protected void bindRender(Render render) {
        RenderBridge bridge = new RenderBridge(render);
        bridge.activate(this.getBundleContext());
        this.bindServlet(render.getName(), (Servlet)bridge);
    }

    protected void unbindRender(Render render) {
        this.unbindServlet(render.getName());
    }

    private Dictionary getConfiguration() {
        return this.configuration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateConfiguration(Dictionary config) {
        HttpService httpService;
        if (config == null) {
            config = new Hashtable();
        }
        this.configuration = config;
        this.defaultRenderName = this.getProperty(config, PROP_DEFAULT_RENDER, DEFAULT_PAGE);
        if (this.defaultRenderName != null && this.plugins.get(this.defaultRenderName) != null) {
            this.defaultRender = (Servlet)this.plugins.get(this.defaultRenderName);
        }
        this.webManagerRoot = this.getProperty(config, PROP_MANAGER_ROOT, DEFAULT_MANAGER_ROOT);
        if (!this.webManagerRoot.startsWith("/")) {
            this.webManagerRoot = "/" + this.webManagerRoot;
        }
        if ((httpService = this.httpService) != null) {
            OsgiManager osgiManager = this;
            synchronized (osgiManager) {
                this.unbindHttpService(httpService);
                this.bindHttpService(httpService);
            }
        }
    }

    private String getProperty(Dictionary config, String name, String def) {
        Object value = config.get(name);
        if (value instanceof String) {
            return (String)value;
        }
        if (value == null) {
            return def;
        }
        return String.valueOf(value);
    }

    private Dictionary toStringConfig(Dictionary config) {
        Hashtable<String, String> stringConfig = new Hashtable<String, String>();
        Enumeration ke = config.keys();
        while (ke.hasMoreElements()) {
            Object key = ke.nextElement();
            ((Dictionary)stringConfig).put(key.toString(), String.valueOf(config.get(key)));
        }
        return stringConfig;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class PluginServiceTracker
    extends ServiceTracker {
        private final OsgiManager osgiManager;

        PluginServiceTracker(OsgiManager osgiManager) {
            super(osgiManager.getBundleContext(), "javax.servlet.Servlet", null);
            this.osgiManager = osgiManager;
        }

        public Object addingService(ServiceReference reference) {
            Object label = reference.getProperty("felix.webconsole.label");
            if (label instanceof String) {
                Object operation = super.addingService(reference);
                if (operation instanceof Servlet) {
                    this.osgiManager.bindServlet((String)label, (Servlet)operation);
                }
                return operation;
            }
            return null;
        }

        public void removedService(ServiceReference reference, Object service) {
            Object label = reference.getProperty("felix.webconsole.label");
            if (label instanceof String) {
                this.osgiManager.unbindServlet((String)label);
            }
            super.removedService(reference, service);
        }
    }

    private static class RenderServiceTracker
    extends ServiceTracker {
        private final OsgiManager osgiManager;

        RenderServiceTracker(OsgiManager osgiManager) {
            super(osgiManager.getBundleContext(), Render.SERVICE, null);
            this.osgiManager = osgiManager;
        }

        public Object addingService(ServiceReference reference) {
            Object operation = super.addingService(reference);
            if (operation instanceof Render) {
                this.osgiManager.bindRender((Render)operation);
            }
            return operation;
        }

        public void removedService(ServiceReference reference, Object service) {
            if (service instanceof Render) {
                this.osgiManager.bindRender((Render)service);
            }
            super.removedService(reference, service);
        }
    }

    private static class OperationServiceTracker
    extends ServiceTracker {
        private final OsgiManager osgiManager;

        OperationServiceTracker(OsgiManager osgiManager) {
            super(osgiManager.getBundleContext(), Action.SERVICE, null);
            this.osgiManager = osgiManager;
        }

        public Object addingService(ServiceReference reference) {
            Object operation = super.addingService(reference);
            if (operation instanceof Action) {
                this.osgiManager.bindOperation((Action)operation);
            }
            return operation;
        }

        public void removedService(ServiceReference reference, Object service) {
            if (service instanceof Action) {
                this.osgiManager.bindOperation((Action)service);
            }
            super.removedService(reference, service);
        }
    }

    private static class HttpServiceTracker
    extends ServiceTracker {
        private final OsgiManager osgiManager;

        HttpServiceTracker(OsgiManager osgiManager) {
            super(osgiManager.getBundleContext(), (class$org$osgi$service$http$HttpService == null ? (class$org$osgi$service$http$HttpService = OsgiManager.class$("org.osgi.service.http.HttpService")) : class$org$osgi$service$http$HttpService).getName(), null);
            this.osgiManager = osgiManager;
        }

        public Object addingService(ServiceReference reference) {
            Object operation = super.addingService(reference);
            if (operation instanceof HttpService) {
                this.osgiManager.bindHttpService((HttpService)operation);
            }
            return operation;
        }

        public void removedService(ServiceReference reference, Object service) {
            if (service instanceof HttpService) {
                this.osgiManager.unbindHttpService((HttpService)service);
            }
            super.removedService(reference, service);
        }
    }
}

