/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.webconsole.internal.compendium;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Iterator;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.felix.scr.Component;
import org.apache.felix.scr.Reference;
import org.apache.felix.scr.ScrService;
import org.apache.felix.webconsole.internal.BaseWebConsolePlugin;
import org.apache.felix.webconsole.internal.Util;
import org.apache.felix.webconsole.internal.servlet.OsgiManager;
import org.json.JSONException;
import org.json.JSONWriter;
import org.osgi.framework.ServiceReference;

public class ComponentsServlet
extends BaseWebConsolePlugin {
    public static final String NAME = "components";
    public static final String LABEL = "Components";
    public static final String COMPONENT_ID = "componentId";
    public static final String OPERATION = "action";
    public static final String OPERATION_ENABLE = "enable";
    public static final String OPERATION_DISABLE = "disable";
    private static final String SCR_SERVICE = (class$org$apache$felix$scr$ScrService == null ? (class$org$apache$felix$scr$ScrService = ComponentsServlet.class$("org.apache.felix.scr.ScrService")) : class$org$apache$felix$scr$ScrService).getName();
    static /* synthetic */ Class class$org$apache$felix$scr$ScrService;

    public String getTitle() {
        return LABEL;
    }

    public String getLabel() {
        return NAME;
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException {
        long componentId;
        Component component;
        ScrService scrService = this.getScrService();
        if (scrService != null && (component = scrService.getComponent(componentId = this.getComponentId(request))) != null) {
            String op = request.getParameter(OPERATION);
            if (OPERATION_ENABLE.equals(op)) {
                component.enable();
            } else if (OPERATION_DISABLE.equals(op)) {
                component.disable();
            }
            this.sendAjaxDetails(component, response);
        }
    }

    protected void renderContent(HttpServletRequest request, HttpServletResponse response) throws IOException {
        PrintWriter pw = response.getWriter();
        String appRoot = (String)request.getAttribute(OsgiManager.ATTR_APP_ROOT);
        pw.println("<script src='" + appRoot + "/res/ui/datatable.js' language='JavaScript'></script>");
        Util.startScript(pw);
        pw.print("var components = ");
        this.renderResult(request, pw);
        pw.println(";");
        pw.println("renderDataTable( components );");
        Util.endScript(pw);
    }

    private void renderResult(HttpServletRequest request, PrintWriter pw) throws IOException {
        JSONWriter jw = new JSONWriter((Writer)pw);
        try {
            jw.object();
            jw.key("numActions");
            jw.value(2L);
            ScrService scrService = this.getScrService();
            if (scrService == null) {
                jw.key("error");
                jw.value((Object)"Apache Felix Declarative Service required for this function");
            } else {
                Component component;
                Component[] components = null;
                boolean details = false;
                long componentId = this.getComponentId(request);
                if (componentId >= 0L && (component = scrService.getComponent(componentId)) != null) {
                    components = new Component[]{component};
                    details = true;
                }
                if (components == null) {
                    components = scrService.getComponents();
                }
                if (components == null || components.length == 0) {
                    jw.key("error");
                    jw.value((Object)"No components installed currently");
                } else {
                    TreeMap<String, Component> componentMap = new TreeMap<String, Component>();
                    for (int i = 0; i < components.length; ++i) {
                        Component component2 = components[i];
                        componentMap.put(component2.getName(), component2);
                    }
                    jw.key("data");
                    jw.array();
                    Iterator ci = componentMap.values().iterator();
                    while (ci.hasNext()) {
                        this.component(jw, (Component)ci.next(), details);
                    }
                    jw.endArray();
                }
            }
            jw.endObject();
        }
        catch (JSONException je) {
            throw new IOException(je.toString());
        }
    }

    private void sendAjaxDetails(Component component, HttpServletResponse response) throws IOException {
        response.setContentType("text/javascript");
        JSONWriter jw = new JSONWriter((Writer)response.getWriter());
        try {
            if (component != null) {
                this.component(jw, component, true);
            }
        }
        catch (JSONException je) {
            throw new IOException(je.toString());
        }
    }

    private void component(JSONWriter jw, Component component, boolean details) throws JSONException {
        String id = String.valueOf(component.getId());
        String name = component.getName();
        int state = component.getState();
        jw.object();
        jw.key("id");
        jw.value((Object)id);
        jw.key("name");
        jw.value((Object)name);
        jw.key("state");
        jw.value((Object)ComponentsServlet.toStateString(state));
        jw.key("actions");
        jw.array();
        jw.object();
        jw.key("name");
        jw.value((Object)"Enable");
        jw.key("link");
        jw.value((Object)OPERATION_ENABLE);
        jw.key("enabled");
        jw.value(state == 1);
        jw.endObject();
        jw.object();
        jw.key("name");
        jw.value((Object)"Disable");
        jw.key("link");
        jw.value((Object)OPERATION_DISABLE);
        jw.key("enabled");
        jw.value(state != 1 && state != 256);
        jw.endObject();
        jw.endArray();
        if (details) {
            this.gatherComponentDetails(jw, component);
        }
        jw.endObject();
    }

    private void gatherComponentDetails(JSONWriter jw, Component component) throws JSONException {
        jw.key("props");
        jw.array();
        this.keyVal(jw, "Bundle", component.getBundle().getSymbolicName() + " (" + component.getBundle().getBundleId() + ")");
        this.keyVal(jw, "Default State", component.isDefaultEnabled() ? "enabled" : "disabled");
        this.keyVal(jw, "Activation", component.isImmediate() ? "immediate" : "delayed");
        this.listServices(jw, component);
        this.listReferences(jw, component);
        this.listProperties(jw, component);
        jw.endArray();
    }

    private void listServices(JSONWriter jw, Component component) {
        String[] services = component.getServices();
        if (services == null) {
            return;
        }
        this.keyVal(jw, "Service Type", component.isServiceFactory() ? "service factory" : "service");
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < services.length; ++i) {
            if (i > 0) {
                buf.append("<br />");
            }
            buf.append(services[i]);
        }
        this.keyVal(jw, "Services", buf.toString());
    }

    private void listReferences(JSONWriter jw, Component component) {
        Reference[] refs = component.getReferences();
        if (refs != null) {
            for (int i = 0; i < refs.length; ++i) {
                StringBuffer buf = new StringBuffer();
                buf.append(refs[i].isSatisfied() ? "Satisfied" : "Unsatisfied").append("<br />");
                buf.append("Service Name: ").append(refs[i].getServiceName()).append("<br />");
                if (refs[i].getTarget() != null) {
                    buf.append("Target Filter: ").append(refs[i].getTarget()).append("<br />");
                }
                buf.append("Multiple: ").append(refs[i].isMultiple() ? "multiple" : "single").append("<br />");
                buf.append("Optional: ").append(refs[i].isOptional() ? "optional" : "mandatory").append("<br />");
                buf.append("Policy: ").append(refs[i].isStatic() ? "static" : "dynamic").append("<br />");
                ServiceReference[] boundRefs = refs[i].getServiceReferences();
                if (boundRefs != null && boundRefs.length > 0) {
                    for (int j = 0; j < boundRefs.length; ++j) {
                        if (j > 0) {
                            buf.append("<br />");
                        }
                        buf.append("Bound Service ID ");
                        buf.append(boundRefs[j].getProperty("service.id"));
                        String name = (String)boundRefs[j].getProperty("component.name");
                        if (name == null && (name = (String)boundRefs[j].getProperty("service.pid")) == null) {
                            name = (String)boundRefs[j].getProperty("service.description");
                        }
                        if (name == null) continue;
                        buf.append(" (");
                        buf.append(name);
                        buf.append(")");
                    }
                } else {
                    buf.append("No Services bound");
                }
                buf.append("<br />");
                this.keyVal(jw, "Reference " + refs[i].getName(), buf.toString());
            }
        }
    }

    private void listProperties(JSONWriter jw, Component component) {
        Dictionary props = component.getProperties();
        if (props != null) {
            StringBuffer buf = new StringBuffer();
            TreeSet keys = new TreeSet(Collections.list(props.keys()));
            Iterator ki = keys.iterator();
            while (ki.hasNext()) {
                String key = (String)ki.next();
                buf.append(key).append(" = ");
                Object prop = props.get(key);
                if (prop.getClass().isArray()) {
                    prop = Arrays.asList((Object[])prop);
                }
                buf.append(prop);
                if (!ki.hasNext()) continue;
                buf.append("<br />");
            }
            this.keyVal(jw, "Properties", buf.toString());
        }
    }

    private void keyVal(JSONWriter jw, String key, Object value) {
        if (key != null && value != null) {
            try {
                jw.object();
                jw.key("key");
                jw.value((Object)key);
                jw.key("value");
                jw.value(value);
                jw.endObject();
            }
            catch (JSONException je) {
                // empty catch block
            }
        }
    }

    static String toStateString(int state) {
        switch (state) {
            case 1: {
                return "disabled";
            }
            case 2: {
                return "enabled";
            }
            case 4: {
                return "unsatisifed";
            }
            case 8: {
                return "activating";
            }
            case 16: {
                return "active";
            }
            case 32: {
                return "registered";
            }
            case 64: {
                return "factory";
            }
            case 128: {
                return "deactivating";
            }
            case 256: {
                return "destroyed";
            }
        }
        return String.valueOf(state);
    }

    protected long getComponentId(HttpServletRequest request) {
        String componentIdPar = request.getParameter(COMPONENT_ID);
        if (componentIdPar == null) {
            String info = request.getPathInfo();
            componentIdPar = info.substring(info.lastIndexOf(47) + 1);
        }
        try {
            return Long.parseLong(componentIdPar);
        }
        catch (NumberFormatException numberFormatException) {
            return -1L;
        }
    }

    private ScrService getScrService() {
        return (ScrService)this.getService(SCR_SERVICE);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

