/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.webconsole.plugins.packageadmin.internal;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.felix.webconsole.SimpleWebConsolePlugin;
import org.apache.felix.webconsole.WebConsoleUtil;
import org.apache.felix.webconsole.plugins.packageadmin.internal.ExportedPackageComparator;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.service.packageadmin.ExportedPackage;
import org.osgi.service.packageadmin.PackageAdmin;

class WebConsolePlugin
extends SimpleWebConsolePlugin {
    private static final String LABEL = "depfinder";
    private static final String TITLE = "%pluginTitle";
    private static final String[] CSS = new String[]{"/depfinder/res/plugin.css"};
    private static final Comparator EXPORT_PACKAGE_COMPARATOR = new ExportedPackageComparator();
    private final PackageAdmin pa;
    private final BundleContext bc;
    private final String TEMPLATE;

    WebConsolePlugin(BundleContext bc, Object pa) {
        super(LABEL, TITLE, CSS);
        this.pa = (PackageAdmin)pa;
        this.bc = bc;
        this.TEMPLATE = this.readTemplateFile("/res/plugin.html");
    }

    protected final void renderContent(HttpServletRequest req, HttpServletResponse response) throws ServletException, IOException {
        response.getWriter().print(this.TEMPLATE);
    }

    protected final void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        JSONObject json;
        block4: {
            try {
                String action = req.getParameter("action");
                if ("deps".equals(action)) {
                    json = WebConsolePlugin.doFindDependencies(req, this.pa);
                    break block4;
                }
                if ("dups".equals(action)) {
                    Map packages = WebConsolePlugin.collectExportedPackages(this.pa, this.bc);
                    json = WebConsolePlugin.doFindDuplicates(packages);
                    break block4;
                }
                throw new ServletException("Invalid action: " + action);
            }
            catch (JSONException e) {
                throw new ServletException((Throwable)e);
            }
        }
        WebConsoleUtil.setNoCache((HttpServletResponse)resp);
        resp.setContentType("application/json; utf-8");
        resp.getWriter().println(json);
    }

    static final Map collectExportedPackages(PackageAdmin pa, BundleContext bundleContext) {
        TreeMap<String, TreeSet<ExportedPackage>> exports = new TreeMap<String, TreeSet<ExportedPackage>>();
        Bundle[] bundles = bundleContext.getBundles();
        for (int i = 0; bundles != null && i < bundles.length; ++i) {
            Bundle bundle = bundles[i];
            ExportedPackage[] bundleExports = pa.getExportedPackages(bundle);
            for (int j = 0; bundleExports != null && j < bundleExports.length; ++j) {
                ExportedPackage exportedPackage = bundleExports[j];
                TreeSet<ExportedPackage> exportSet = (TreeSet<ExportedPackage>)exports.get(exportedPackage.getName());
                if (exportSet == null) {
                    exportSet = new TreeSet<ExportedPackage>(EXPORT_PACKAGE_COMPARATOR);
                    exports.put(exportedPackage.getName(), exportSet);
                }
                exportSet.add(exportedPackage);
            }
        }
        return exports;
    }

    private static final JSONObject doFindDependencies(HttpServletRequest req, PackageAdmin pa) throws JSONException {
        JSONObject json = new JSONObject();
        String findField = req.getParameter("plugin.find");
        if (findField != null) {
            Set packageNames = WebConsolePlugin.getPackageNames(findField);
            LinkedHashSet exportingBundles = new LinkedHashSet();
            Iterator i = packageNames.iterator();
            while (i.hasNext()) {
                String name = (String)i.next();
                json.append("packages", (Object)WebConsolePlugin.getPackageInfo(name, pa, exportingBundles));
            }
            JSONObject mavenJson = new JSONObject();
            json.put("maven", (Object)mavenJson);
            Iterator i2 = exportingBundles.iterator();
            while (i2.hasNext()) {
                Bundle bundle = (Bundle)i2.next();
                mavenJson.putOpt(String.valueOf(bundle.getBundleId()), (Object)WebConsolePlugin.getMavenInfo(bundle));
            }
        }
        return json;
    }

    private static final JSONArray doFindDuplicates(Map exports) throws JSONException {
        JSONArray ret = new JSONArray();
        Iterator entryIter = exports.entrySet().iterator();
        while (entryIter.hasNext()) {
            Map.Entry exportEntry = entryIter.next();
            Set exportSet = (Set)exportEntry.getValue();
            if (exportSet.size() <= 1) continue;
            JSONObject container = new JSONObject();
            ret.put((Object)container);
            Iterator packageIter = exportSet.iterator();
            while (packageIter.hasNext()) {
                ExportedPackage exportedPackage = (ExportedPackage)packageIter.next();
                JSONObject json = WebConsolePlugin.toJSON(exportedPackage);
                Bundle[] importers = exportedPackage.getImportingBundles();
                for (int j = 0; importers != null && j < importers.length; ++j) {
                    json.append("importers", (Object)WebConsolePlugin.toJSON(importers[j], new JSONObject()));
                }
                container.put("name", (Object)exportedPackage.getName()).append("entries", (Object)json);
            }
        }
        return ret;
    }

    private static final JSONObject toJSON(Bundle bundle, JSONObject json) throws JSONException {
        json.put("bid", bundle.getBundleId());
        json.putOpt("bsn", (Object)bundle.getSymbolicName());
        return json;
    }

    private static final JSONObject toJSON(ExportedPackage pkg) throws JSONException {
        JSONObject ret = new JSONObject();
        ret.put("version", (Object)pkg.getVersion());
        return WebConsolePlugin.toJSON(pkg.getExportingBundle(), ret);
    }

    private static final JSONObject getPackageInfo(String packageName, PackageAdmin pa, Set exportingBundles) throws JSONException {
        JSONObject ret = new JSONObject();
        ExportedPackage[] exports = pa.getExportedPackages(packageName);
        for (int i = 0; exports != null && i < exports.length; ++i) {
            ExportedPackage x = exports[i];
            ret.append("exporters", (Object)WebConsolePlugin.toJSON(x));
            exportingBundles.add(x.getExportingBundle());
        }
        return ret.put("name", (Object)packageName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final JSONObject getMavenInfo(Bundle bundle) {
        JSONObject ret = null;
        Enumeration entries = bundle.findEntries("META-INF/maven", "pom.properties", true);
        if (entries != null) {
            URL u = (URL)entries.nextElement();
            Properties props = new Properties();
            InputStream is = null;
            try {
                is = u.openStream();
                props.load(u.openStream());
                ret = new JSONObject((Map)props);
            }
            catch (IOException e) {
            }
            finally {
                IOUtils.closeQuietly((InputStream)is);
            }
        }
        return ret;
    }

    static final Set getPackageNames(String findField) {
        StringTokenizer tok = new StringTokenizer(findField, " \t\n\f\r");
        TreeSet<String> result = new TreeSet<String>();
        while (tok.hasMoreTokens()) {
            int idx;
            String part = tok.nextToken().trim();
            if (part.length() <= 0 || (idx = part.lastIndexOf(46)) == -1) continue;
            char firstCharAfterLastDot = part.charAt(idx + 1);
            if (Character.isUpperCase(firstCharAfterLastDot)) {
                result.add(part.substring(0, idx));
                continue;
            }
            result.add(part);
        }
        return result;
    }
}

