/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.scrplugin.processing;

import java.lang.reflect.Array;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.AutoDetect;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Modified;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.References;
import org.apache.felix.scr.annotations.Service;
import org.apache.felix.scr.annotations.Services;
import org.apache.felix.scrplugin.SCRDescriptorException;
import org.apache.felix.scrplugin.SCRDescriptorFailureException;
import org.apache.felix.scrplugin.SpecVersion;
import org.apache.felix.scrplugin.annotations.AnnotationProcessor;
import org.apache.felix.scrplugin.annotations.ClassAnnotation;
import org.apache.felix.scrplugin.annotations.FieldAnnotation;
import org.apache.felix.scrplugin.annotations.MethodAnnotation;
import org.apache.felix.scrplugin.annotations.ScannedAnnotation;
import org.apache.felix.scrplugin.annotations.ScannedClass;
import org.apache.felix.scrplugin.description.AbstractDescription;
import org.apache.felix.scrplugin.description.ClassDescription;
import org.apache.felix.scrplugin.description.ComponentConfigurationPolicy;
import org.apache.felix.scrplugin.description.ComponentDescription;
import org.apache.felix.scrplugin.description.PropertyDescription;
import org.apache.felix.scrplugin.description.PropertyType;
import org.apache.felix.scrplugin.description.PropertyUnbounded;
import org.apache.felix.scrplugin.description.ReferenceCardinality;
import org.apache.felix.scrplugin.description.ReferenceDescription;
import org.apache.felix.scrplugin.description.ReferencePolicy;
import org.apache.felix.scrplugin.description.ReferencePolicyOption;
import org.apache.felix.scrplugin.description.ReferenceStrategy;
import org.apache.felix.scrplugin.description.ServiceDescription;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SCRAnnotationProcessor
implements AnnotationProcessor {
    private static final String[] PROPERTY_VALUE_PROCESSING = new String[]{"String", "value", "String", "classValue", "Long", "longValue", "Double", "doubleValue", "Float", "floatValue", "Integer", "intValue", "Byte", "byteValue", "Char", "charValue", "Boolean", "boolValue", "Short", "shortValue", "Password", "passwordValue"};

    public String getName() {
        return "Apache Felix SCR Annotation Processor";
    }

    public void process(ScannedClass scannedClass, ClassDescription describedClass) throws SCRDescriptorFailureException, SCRDescriptorException {
        List servicesTags;
        List componentTags = scannedClass.getClassAnnotations(Component.class.getName());
        scannedClass.processed((Collection)componentTags);
        for (ClassAnnotation cad : componentTags) {
            describedClass.add((AbstractDescription)this.createComponent(cad, scannedClass));
        }
        List componentDescs = describedClass.getDescriptions(ComponentDescription.class);
        ComponentDescription found = null;
        if (!componentDescs.isEmpty()) {
            found = (ComponentDescription)componentDescs.get(0);
        }
        if (found != null) {
            ComponentDescription cd = found;
            List methodTags = scannedClass.getMethodAnnotations(null);
            for (MethodAnnotation m : methodTags) {
                if (m.getName().equals(Activate.class.getName())) {
                    cd.setActivate(m.getAnnotatedMethod().getName());
                    scannedClass.processed((ScannedAnnotation)m);
                    continue;
                }
                if (m.getName().equals(Deactivate.class.getName())) {
                    cd.setDeactivate(m.getAnnotatedMethod().getName());
                    scannedClass.processed((ScannedAnnotation)m);
                    continue;
                }
                if (!m.getName().equals(Modified.class.getName())) continue;
                cd.setModified(m.getAnnotatedMethod().getName());
                scannedClass.processed((ScannedAnnotation)m);
            }
        }
        ArrayList<ClassAnnotation> allServiceTags = new ArrayList<ClassAnnotation>();
        List serviceTags = scannedClass.getClassAnnotations(Service.class.getName());
        if (serviceTags.size() > 0) {
            scannedClass.processed((Collection)serviceTags);
            allServiceTags.addAll(serviceTags);
        }
        if ((servicesTags = scannedClass.getClassAnnotations(Services.class.getName())).size() > 0) {
            scannedClass.processed((Collection)servicesTags);
            for (ClassAnnotation cad : servicesTags) {
                ClassAnnotation[] values = (ClassAnnotation[])cad.getValue("value");
                if (values == null) continue;
                allServiceTags.addAll(Arrays.asList(values));
            }
        }
        if (allServiceTags.size() > 0) {
            describedClass.add((AbstractDescription)this.createService(allServiceTags, scannedClass));
        }
        List referencesClassTags = scannedClass.getClassAnnotations(References.class.getName());
        scannedClass.processed((Collection)referencesClassTags);
        for (ClassAnnotation cad : referencesClassTags) {
            ClassAnnotation[] values = (ClassAnnotation[])cad.getValue("value");
            if (values == null) continue;
            this.createReferences(Arrays.asList(values), describedClass);
        }
        List refClassTags = scannedClass.getClassAnnotations(Reference.class.getName());
        scannedClass.processed((Collection)refClassTags);
        this.createReferences(refClassTags, describedClass);
        List refFieldTags = scannedClass.getFieldAnnotations(Reference.class.getName());
        scannedClass.processed((Collection)refFieldTags);
        this.createReferences(refFieldTags, describedClass);
        List propsClassTags = scannedClass.getClassAnnotations(Properties.class.getName());
        scannedClass.processed((Collection)propsClassTags);
        for (ClassAnnotation cad : propsClassTags) {
            ClassAnnotation[] values = (ClassAnnotation[])cad.getValue("value");
            if (values == null) continue;
            this.createProperties(Arrays.asList(values), describedClass);
        }
        List propClassTags = scannedClass.getClassAnnotations(Property.class.getName());
        scannedClass.processed((Collection)propClassTags);
        this.createProperties(propClassTags, describedClass);
        List propFieldTags = scannedClass.getFieldAnnotations(Property.class.getName());
        scannedClass.processed((Collection)propFieldTags);
        this.createProperties(propFieldTags, describedClass);
    }

    public int getRanking() {
        return 1000;
    }

    private ComponentDescription createComponent(ClassAnnotation cad, ScannedClass scannedClass) {
        ComponentDescription component = new ComponentDescription((ScannedAnnotation)cad);
        boolean classIsAbstract = Modifier.isAbstract(scannedClass.getScannedClass().getModifiers());
        component.setAbstract(cad.getBooleanValue("componentAbstract", classIsAbstract));
        component.setCreatePid(cad.getBooleanValue("createPid", true));
        component.setName(cad.getStringValue("name", scannedClass.getScannedClass().getName()));
        component.setLabel(cad.getStringValue("label", null));
        component.setDescription(cad.getStringValue("description", null));
        component.setCreateDs(cad.getBooleanValue("ds", true));
        component.setCreateMetatype(cad.getBooleanValue("metatype", false));
        if (cad.getValue("enabled") != null) {
            component.setEnabled(Boolean.valueOf(cad.getBooleanValue("enabled", true)));
        }
        if (cad.getValue("specVersion") != null) {
            component.setSpecVersion(SpecVersion.fromName((String)cad.getValue("specVersion").toString()));
        }
        component.setFactory(cad.getStringValue("factory", null));
        if (cad.getValue("immediate") != null) {
            component.setImmediate(Boolean.valueOf(cad.getBooleanValue("immediate", false)));
        }
        component.setInherit(cad.getBooleanValue("inherit", true));
        component.setConfigurationPolicy(ComponentConfigurationPolicy.valueOf((String)cad.getEnumValue("policy", ComponentConfigurationPolicy.OPTIONAL.name())));
        component.setSetMetatypeFactoryPid(cad.getBooleanValue("configurationFactory", false));
        component.setConfigurationPid(cad.getStringValue("configurationPid", null));
        return component;
    }

    private ServiceDescription createService(List<ClassAnnotation> descs, ScannedClass scannedClass) {
        ServiceDescription service = new ServiceDescription((ScannedAnnotation)descs.get(0));
        ArrayList<String> listedInterfaces = new ArrayList<String>();
        for (ClassAnnotation d : descs) {
            String[] interfaces;
            if (d.getBooleanValue("serviceFactory", false)) {
                service.setServiceFactory(true);
            }
            if (d.getValue("value") == null) continue;
            for (String t : interfaces = (String[])d.getValue("value")) {
                listedInterfaces.add(t);
            }
        }
        if (listedInterfaces.size() > 0 && !listedInterfaces.contains(AutoDetect.class.getName())) {
            for (String i : listedInterfaces) {
                service.addInterface(i);
            }
        } else {
            this.addInterfaces(service, scannedClass.getScannedClass());
        }
        return service;
    }

    private void addInterfaces(ServiceDescription service, Class<?> javaClass) {
        if (javaClass != null) {
            Class<?>[] interfaces;
            for (Class<?> i : interfaces = javaClass.getInterfaces()) {
                service.addInterface(i.getName());
                this.addInterfaces(service, i);
            }
            this.addInterfaces(service, javaClass.getSuperclass());
        }
    }

    private void createReferences(List<? extends ScannedAnnotation> descs, ClassDescription describedClass) {
        for (ScannedAnnotation scannedAnnotation : descs) {
            FieldAnnotation fieldAnnotation;
            ReferenceDescription ref = new ReferenceDescription(scannedAnnotation);
            if (scannedAnnotation instanceof FieldAnnotation) {
                fieldAnnotation = (FieldAnnotation)scannedAnnotation;
                ref.setField(fieldAnnotation.getAnnotatedField());
            } else {
                fieldAnnotation = null;
            }
            ref.setName(scannedAnnotation.getStringValue("name", fieldAnnotation != null ? fieldAnnotation.getAnnotatedField().getName() : null));
            String defaultInterfaceName = null;
            if (fieldAnnotation != null) {
                defaultInterfaceName = fieldAnnotation.getAnnotatedField().getType().isArray() ? fieldAnnotation.getAnnotatedField().getType().getComponentType().getName() : fieldAnnotation.getAnnotatedField().getType().getName();
            }
            ref.setInterfaceName(scannedAnnotation.getStringValue("referenceInterface", defaultInterfaceName));
            ref.setTarget(scannedAnnotation.getStringValue("target", null));
            ref.setCardinality(ReferenceCardinality.valueOf((String)scannedAnnotation.getEnumValue("cardinality", ReferenceCardinality.MANDATORY_UNARY.name())));
            ref.setPolicy(ReferencePolicy.valueOf((String)scannedAnnotation.getEnumValue("policy", ReferencePolicy.STATIC.name())));
            ref.setPolicyOption(ReferencePolicyOption.valueOf((String)scannedAnnotation.getEnumValue("policyOption", ReferencePolicyOption.RELUCTANT.name())));
            ref.setStrategy(ReferenceStrategy.valueOf((String)scannedAnnotation.getEnumValue("strategy", ReferenceStrategy.EVENT.name())));
            ref.setBind(scannedAnnotation.getStringValue("bind", null));
            ref.setUnbind(scannedAnnotation.getStringValue("unbind", null));
            ref.setUpdated(scannedAnnotation.getStringValue("updated", null));
            describedClass.add((AbstractDescription)ref);
        }
    }

    private void createProperties(List<? extends ScannedAnnotation> descs, ClassDescription describedClass) throws SCRDescriptorFailureException, SCRDescriptorException {
        for (ScannedAnnotation scannedAnnotation : descs) {
            ScannedAnnotation[] options;
            Object value;
            int i;
            PropertyDescription prop = new PropertyDescription(scannedAnnotation);
            FieldAnnotation fieldAnnotation = scannedAnnotation instanceof FieldAnnotation ? (FieldAnnotation)scannedAnnotation : null;
            String type = null;
            String[] values = null;
            for (int index = 0; type == null && index < PROPERTY_VALUE_PROCESSING.length; index += 2) {
                String propType = PROPERTY_VALUE_PROCESSING[index];
                String propName = PROPERTY_VALUE_PROCESSING[index + 1];
                Object propValue = scannedAnnotation.getValue(propName);
                if (propValue == null || !propValue.getClass().isArray()) continue;
                type = propType;
                values = new String[Array.getLength(propValue)];
                for (i = 0; i < values.length; ++i) {
                    values[i] = Array.get(propValue, i).toString();
                }
            }
            String name = scannedAnnotation.getStringValue("name", null);
            if (values != null) {
                prop.setType(PropertyType.valueOf(type));
                if (values.length == 1) {
                    prop.setValue((String)values[0]);
                } else {
                    prop.setMultiValue(values);
                }
                if (name == null && (value = fieldAnnotation.getAnnotatedFieldValue()) != null) {
                    name = value.toString();
                }
            } else if (fieldAnnotation != null) {
                String[] newValues;
                if (name != null) {
                    value = fieldAnnotation.getAnnotatedFieldValue();
                    if (value != null) {
                        if (value.getClass().isArray()) {
                            newValues = new String[Array.getLength(value)];
                            for (i = 0; i < newValues.length; ++i) {
                                newValues[i] = Array.get(value, i).toString();
                            }
                            prop.setMultiValue(newValues);
                            prop.setType(PropertyType.from(fieldAnnotation.getAnnotatedField().getType().getComponentType()));
                        } else {
                            prop.setType(PropertyType.from(value.getClass()));
                            prop.setValue(value.toString());
                        }
                    }
                } else if (Modifier.isStatic(fieldAnnotation.getAnnotatedField().getModifiers())) {
                    value = fieldAnnotation.getAnnotatedFieldValue();
                    if (value != null) {
                        name = value.toString();
                    }
                } else {
                    name = fieldAnnotation.getAnnotatedField().getName();
                    value = fieldAnnotation.getAnnotatedFieldValue();
                    if (value != null) {
                        if (value.getClass().isArray()) {
                            newValues = new String[Array.getLength(value)];
                            for (i = 0; i < newValues.length; ++i) {
                                newValues[i] = Array.get(value, i).toString();
                            }
                            prop.setMultiValue(newValues);
                            prop.setType(PropertyType.from(fieldAnnotation.getAnnotatedField().getType().getComponentType()));
                        } else {
                            prop.setType(PropertyType.from(value.getClass()));
                            prop.setValue(value.toString());
                        }
                    }
                }
            }
            prop.setName(name);
            prop.setLabel(scannedAnnotation.getStringValue("label", null));
            prop.setDescription(scannedAnnotation.getStringValue("description", null));
            if (prop.getType() == null) {
                prop.setType(PropertyType.String);
            }
            if (scannedAnnotation.getValue("propertyPrivate") != null) {
                prop.setPrivate(Boolean.valueOf(scannedAnnotation.getBooleanValue("propertyPrivate", false)));
            }
            PropertyUnbounded pu = PropertyUnbounded.valueOf((String)scannedAnnotation.getEnumValue("unbounded", PropertyUnbounded.DEFAULT.name()));
            prop.setUnbounded(pu);
            if (pu == PropertyUnbounded.DEFAULT) {
                prop.setCardinality(scannedAnnotation.getIntegerValue("cardinality", 0));
                if (prop.getMultiValue() != null && prop.getCardinality() == 0) {
                    prop.setUnbounded(PropertyUnbounded.ARRAY);
                }
            } else {
                prop.setCardinality(0);
            }
            if (prop.getValue() != null) {
                if (prop.getUnbounded() == PropertyUnbounded.ARRAY || prop.getUnbounded() == PropertyUnbounded.VECTOR) {
                    prop.setMultiValue(new String[]{prop.getValue()});
                } else if (prop.getCardinality() < -1 || prop.getCardinality() > 1) {
                    prop.setMultiValue(new String[]{prop.getValue()});
                }
            }
            if ((options = (ScannedAnnotation[])scannedAnnotation.getValue("options")) != null) {
                ArrayList<String> propertyOptions = new ArrayList<String>();
                for (ScannedAnnotation po : options) {
                    propertyOptions.add(po.getStringValue("name", ""));
                    propertyOptions.add(po.getStringValue("value", ""));
                }
                prop.setOptions(propertyOptions.toArray(new String[propertyOptions.size()]));
            }
            describedClass.add((AbstractDescription)prop);
        }
    }
}

