/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.logback.internal;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.spi.CallerData;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.LoggerContextListener;
import ch.qos.logback.classic.spi.LoggerContextVO;
import ch.qos.logback.classic.spi.LoggingEvent;
import ch.qos.logback.classic.spi.ThrowableProxy;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.osgi.framework.Bundle;
import org.osgi.service.log.LogEntry;
import org.osgi.service.log.LogLevel;
import org.osgi.service.log.LogListener;
import org.osgi.service.log.admin.LoggerAdmin;
import org.osgi.service.log.admin.LoggerContext;
import org.slf4j.ILoggerFactory;
import org.slf4j.impl.StaticLoggerBinder;

public class LogbackLogListener
implements LogListener,
LoggerContextListener {
    private static final String EVENTS_BUNDLE = "Events.Bundle";
    private static final String EVENTS_FRAMEWORK = "Events.Framework";
    private static final String EVENTS_SERVICE = "Events.Service";
    private static final String LOG_SERVICE = "LogService";
    volatile ch.qos.logback.classic.LoggerContext loggerContext;
    volatile Logger rootLogger;
    volatile LoggerContextVO loggerContextVO;
    final Map<String, LogLevel> initialLogLevels;
    final LoggerContext osgiLoggerContext;

    public LogbackLogListener(LoggerAdmin loggerAdmin) {
        this.osgiLoggerContext = loggerAdmin.getLoggerContext(null);
        this.initialLogLevels = this.osgiLoggerContext.getLogLevels();
        ILoggerFactory loggerFactory = StaticLoggerBinder.getSingleton().getLoggerFactory();
        if (!(loggerFactory instanceof ch.qos.logback.classic.LoggerContext)) {
            throw new IllegalStateException("This bundle only works with logback-classic");
        }
        this.onStart((ch.qos.logback.classic.LoggerContext)loggerFactory);
        this.loggerContext.addListener((LoggerContextListener)this);
    }

    public boolean isResetResistant() {
        return true;
    }

    public void logged(final LogEntry entry) {
        String loggerName = entry.getLoggerName();
        String message = entry.getMessage();
        Object[] arguments = null;
        Level level = this.from(entry.getLogLevel());
        final AtomicBoolean avoidCallerData = new AtomicBoolean();
        if (EVENTS_BUNDLE.equals(loggerName) || EVENTS_FRAMEWORK.equals(loggerName) || LOG_SERVICE.equals(loggerName)) {
            loggerName = this.formatBundle(entry.getBundle(), loggerName);
            avoidCallerData.set(true);
        } else if (EVENTS_SERVICE.equals(loggerName)) {
            loggerName = this.formatBundle(entry.getBundle(), loggerName);
            message = message + " {}";
            arguments = new Object[]{entry.getServiceReference()};
            avoidCallerData.set(true);
        }
        Logger logger = this.loggerContext.getLogger(loggerName);
        if (!logger.equals(this.rootLogger) && !logger.isEnabledFor(level)) {
            return;
        }
        LoggingEvent le = new LoggingEvent(){
            private volatile StackTraceElement[] callerData;

            public StackTraceElement[] getCallerData() {
                if (avoidCallerData.get() || this.callerData != null) {
                    return this.callerData;
                }
                this.callerData = LogbackLogListener.this.getCallerData0(entry.getLocation());
                return this.callerData;
            }
        };
        le.setArgumentArray(arguments);
        le.setMessage(message);
        le.setLevel(level);
        le.setLoggerContextRemoteView(this.loggerContextVO);
        le.setLoggerName(loggerName);
        le.setThreadName(entry.getThreadInfo());
        le.setThrowableProxy(this.getThrowableProxy(entry.getException()));
        le.setTimeStamp(entry.getTime());
        this.rootLogger.callAppenders((ILoggingEvent)le);
    }

    public void onLevelChange(Logger logger, Level level) {
        Map updatedLevels = this.osgiLoggerContext.getLogLevels();
        if (Level.OFF.equals(level)) {
            updatedLevels.remove(logger.getName());
        } else {
            updatedLevels.put(logger.getName(), this.from(level));
        }
        this.osgiLoggerContext.setLogLevels(updatedLevels);
    }

    public void onStart(ch.qos.logback.classic.LoggerContext context) {
        this.loggerContext = context;
        this.rootLogger = this.loggerContext.getLogger("ROOT");
        this.loggerContextVO = this.loggerContext.getLoggerContextRemoteView();
        Map<String, LogLevel> updatedLevels = this.updateLevels(this.loggerContext, this.initialLogLevels);
        this.osgiLoggerContext.setLogLevels(updatedLevels);
    }

    public void onStop(ch.qos.logback.classic.LoggerContext context) {
        this.osgiLoggerContext.setLogLevels(this.initialLogLevels);
    }

    public void onReset(ch.qos.logback.classic.LoggerContext context) {
        this.onStart(context);
    }

    String formatBundle(Bundle bundle, String loggerName) {
        return loggerName + "." + bundle.getSymbolicName();
    }

    LogLevel from(Level level) {
        if (Level.ALL.equals(level)) {
            return LogLevel.TRACE;
        }
        if (Level.DEBUG.equals(level)) {
            return LogLevel.DEBUG;
        }
        if (Level.ERROR.equals(level)) {
            return LogLevel.ERROR;
        }
        if (Level.INFO.equals(level)) {
            return LogLevel.INFO;
        }
        if (Level.TRACE.equals(level)) {
            return LogLevel.TRACE;
        }
        if (Level.WARN.equals(level)) {
            return LogLevel.WARN;
        }
        return LogLevel.WARN;
    }

    Level from(LogLevel logLevel) {
        switch (logLevel) {
            case AUDIT: {
                return Level.TRACE;
            }
            case DEBUG: {
                return Level.DEBUG;
            }
            case ERROR: {
                return Level.ERROR;
            }
            case INFO: {
                return Level.INFO;
            }
            case TRACE: {
                return Level.TRACE;
            }
        }
        return Level.WARN;
    }

    StackTraceElement[] getCallerData0(StackTraceElement stackTraceElement) {
        StackTraceElement[] callerData = CallerData.extract((Throwable)new Throwable(), (String)org.osgi.service.log.Logger.class.getName(), (int)this.loggerContext.getMaxCallerDataDepth(), (List)this.loggerContext.getFrameworkPackages());
        if (stackTraceElement != null) {
            if (callerData.length == 0) {
                callerData = new StackTraceElement[]{stackTraceElement};
            } else {
                StackTraceElement[] copy = new StackTraceElement[callerData.length + 1];
                copy[0] = stackTraceElement;
                System.arraycopy(callerData, 0, copy, 1, callerData.length);
                callerData = copy;
            }
        }
        return callerData;
    }

    ThrowableProxy getThrowableProxy(Throwable t) {
        if (t == null) {
            return null;
        }
        ThrowableProxy throwableProxy = new ThrowableProxy(t);
        if (this.loggerContext.isPackagingDataEnabled()) {
            throwableProxy.calculatePackagingData();
        }
        return throwableProxy;
    }

    Map<String, LogLevel> updateLevels(ch.qos.logback.classic.LoggerContext loggerContext, Map<String, LogLevel> levels) {
        HashMap<String, LogLevel> copy = new HashMap<String, LogLevel>(levels);
        Logger root = loggerContext.getLogger("ROOT");
        LogLevel rootLevel = this.from(root.getLevel());
        copy.put("ROOT", rootLevel);
        copy.put(EVENTS_BUNDLE, LogLevel.TRACE);
        copy.put(EVENTS_FRAMEWORK, LogLevel.TRACE);
        copy.put(EVENTS_SERVICE, LogLevel.TRACE);
        copy.put(LOG_SERVICE, LogLevel.TRACE);
        for (Logger logger : loggerContext.getLoggerList()) {
            String name = logger.getName();
            Level level = logger.getLevel();
            if (level == null) continue;
            copy.remove(name);
            if (level == Level.OFF) continue;
            copy.put(name, this.from(level));
        }
        return copy;
    }
}

