/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.logback.internal;

import java.util.AbstractMap;
import org.apache.felix.logback.internal.LogbackLogListener;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.log.LogListener;
import org.osgi.service.log.LogReaderService;
import org.osgi.service.log.admin.LoggerAdmin;
import org.osgi.util.tracker.ServiceTracker;

public class Activator
implements BundleActivator {
    private volatile ServiceTracker<LoggerAdmin, LRST> lat;

    public void start(final BundleContext bundleContext) throws Exception {
        this.lat = new ServiceTracker<LoggerAdmin, LRST>(bundleContext, LoggerAdmin.class, null){

            public LRST addingService(ServiceReference<LoggerAdmin> reference) {
                LoggerAdmin loggerAdmin = (LoggerAdmin)bundleContext.getService(reference);
                LRST lrst = new LRST(bundleContext, loggerAdmin);
                lrst.open();
                return lrst;
            }

            public void removedService(ServiceReference<LoggerAdmin> reference, LRST lrst) {
                lrst.close();
            }
        };
        this.lat.open();
    }

    public void stop(BundleContext bundleContext) throws Exception {
        this.lat.close();
    }

    class Pair
    extends AbstractMap.SimpleEntry<LogReaderService, LogbackLogListener> {
        private static final long serialVersionUID = 1L;

        public Pair(LogReaderService logReaderService, LogbackLogListener logbackLogListener) {
            super(logReaderService, logbackLogListener);
        }
    }

    class LRST
    extends ServiceTracker<LogReaderService, Pair> {
        private final LoggerAdmin loggerAdmin;

        public LRST(BundleContext context, LoggerAdmin loggerAdmin) {
            super(context, LogReaderService.class, null);
            this.loggerAdmin = loggerAdmin;
        }

        public Pair addingService(ServiceReference<LogReaderService> reference) {
            LogReaderService logReaderService = (LogReaderService)this.context.getService(reference);
            LogbackLogListener logbackLogListener = new LogbackLogListener(this.loggerAdmin);
            logReaderService.addLogListener((LogListener)logbackLogListener);
            return new Pair(logReaderService, logbackLogListener);
        }

        public void removedService(ServiceReference<LogReaderService> reference, Pair pair) {
            ((LogReaderService)pair.getKey()).removeLogListener((LogListener)pair.getValue());
        }
    }
}

