/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.org.apache.felix.ipojo.webconsole;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.felix.ipojo.ComponentInstance;
import org.apache.felix.ipojo.Factory;
import org.apache.felix.ipojo.HandlerFactory;
import org.apache.felix.ipojo.InstanceManager;
import org.apache.felix.ipojo.Pojo;
import org.apache.felix.ipojo.annotations.Component;
import org.apache.felix.ipojo.annotations.Invalidate;
import org.apache.felix.ipojo.annotations.Provides;
import org.apache.felix.ipojo.annotations.Requires;
import org.apache.felix.ipojo.annotations.ServiceProperty;
import org.apache.felix.ipojo.architecture.Architecture;
import org.apache.felix.ipojo.architecture.ComponentTypeDescription;
import org.apache.felix.ipojo.architecture.HandlerDescription;
import org.apache.felix.ipojo.architecture.InstanceDescription;
import org.apache.felix.ipojo.architecture.PropertyDescription;
import org.apache.felix.ipojo.handlers.dependency.DependencyDescription;
import org.apache.felix.ipojo.handlers.dependency.DependencyHandlerDescription;
import org.apache.felix.ipojo.handlers.providedservice.ProvidedServiceDescription;
import org.apache.felix.ipojo.handlers.providedservice.ProvidedServiceHandlerDescription;
import org.apache.felix.webconsole.AbstractWebConsolePlugin;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(immediate=true)
@Provides(specifications={Servlet.class})
public class IPOJOServlet
extends AbstractWebConsolePlugin
implements Pojo {
    private InstanceManager __IM;
    public static final String FACTORY = "factory";
    public static final String INSTANCE = "instance";
    public static final String HANDLER = "handler";
    public static final String ALL = "all";
    private static final long serialVersionUID = 1L;
    private boolean __Fm_label;
    @ServiceProperty(name="felix.webconsole.label")
    private String m_label;
    private boolean __Fm_title;
    @ServiceProperty(name="felix.webconsole.title")
    private String m_title;
    private boolean __Fm_archs;
    @Requires(optional=true, specification="org.apache.felix.ipojo.architecture.Architecture")
    private List<Architecture> m_archs;
    private boolean __Fm_factories;
    @Requires(optional=true, specification="org.apache.felix.ipojo.Factory")
    private List<Factory> m_factories;
    private boolean __Fm_handlers;
    @Requires(optional=true, specification="org.apache.felix.ipojo.HandlerFactory")
    private List<HandlerFactory> m_handlers;
    private boolean __Mstop;
    private boolean __MgetLabel;
    private boolean __MgetTitle;
    private boolean __MgetValidCount;
    private boolean __MgetInvalidCount;
    private boolean __MrenderContent$javax_servlet_http_HttpServletRequest$javax_servlet_http_HttpServletResponse;
    private boolean __MprintFactoryDetail$java_io_PrintWriter$java_lang_String;
    private boolean __MgetProperties$org_apache_felix_ipojo_architecture_PropertyDescription__;
    private boolean __MprintInstanceList$java_io_PrintWriter;
    private boolean __MaddEntry$java_io_PrintWriter$java_lang_String$java_lang_String;
    private boolean __MaddEntry$java_lang_String$java_lang_String;
    private boolean __MgetFactoryLinkIfPossible$org_apache_felix_ipojo_architecture_InstanceDescription;
    private boolean __MgetInvalidHandlerList$org_apache_felix_ipojo_architecture_HandlerDescription__;
    private boolean __MprintInstanceDetail$java_io_PrintWriter$java_lang_String;
    private boolean __MgetInstanceLink$java_lang_String;
    private boolean __MgetServiceProperties$java_util_Properties;
    private boolean __MgetInstanceList$java_lang_String;
    private boolean __MgetServiceReferenceList$java_util_List;
    private boolean __MgetProvidedServiceDetail$org_apache_felix_ipojo_architecture_HandlerDescription;
    private boolean __MgetRequiredServiceDetail$org_apache_felix_ipojo_architecture_HandlerDescription;
    private boolean __MgetInstanceDescriptionByName$java_lang_String;
    private boolean __MprintFactoryList$java_io_PrintWriter;
    private boolean __MprintHandlerList$java_io_PrintWriter;
    private boolean __MgetInstanceState$int;
    private boolean __MgetFactoryState$int;
    private boolean __MgetDependencyState$int;
    private boolean __MgetDependencyBindingPolicy$int;
    private boolean __MgetProvidedServiceState$int;

    String __getm_label() {
        if (!this.__Fm_label) {
            return this.m_label;
        }
        return (String)this.__IM.onGet((Object)this, "m_label");
    }

    void __setm_label(String string) {
        if (!this.__Fm_label) {
            this.m_label = string;
            return;
        }
        this.__IM.onSet((Object)this, "m_label", (Object)string);
    }

    String __getm_title() {
        if (!this.__Fm_title) {
            return this.m_title;
        }
        return (String)this.__IM.onGet((Object)this, "m_title");
    }

    void __setm_title(String string) {
        if (!this.__Fm_title) {
            this.m_title = string;
            return;
        }
        this.__IM.onSet((Object)this, "m_title", (Object)string);
    }

    List __getm_archs() {
        if (!this.__Fm_archs) {
            return this.m_archs;
        }
        return (List)this.__IM.onGet((Object)this, "m_archs");
    }

    void __setm_archs(List list) {
        if (!this.__Fm_archs) {
            this.m_archs = list;
            return;
        }
        this.__IM.onSet((Object)this, "m_archs", (Object)list);
    }

    List __getm_factories() {
        if (!this.__Fm_factories) {
            return this.m_factories;
        }
        return (List)this.__IM.onGet((Object)this, "m_factories");
    }

    void __setm_factories(List list) {
        if (!this.__Fm_factories) {
            this.m_factories = list;
            return;
        }
        this.__IM.onSet((Object)this, "m_factories", (Object)list);
    }

    List __getm_handlers() {
        if (!this.__Fm_handlers) {
            return this.m_handlers;
        }
        return (List)this.__IM.onGet((Object)this, "m_handlers");
    }

    void __setm_handlers(List list) {
        if (!this.__Fm_handlers) {
            this.m_handlers = list;
            return;
        }
        this.__IM.onSet((Object)this, "m_handlers", (Object)list);
    }

    public IPOJOServlet(BundleContext bundleContext) {
        this(null, bundleContext);
    }

    private IPOJOServlet(InstanceManager _manager, BundleContext bc) {
        this._setInstanceManager(_manager);
        this.__setm_label("ipojo");
        this.__setm_title("iPOJO");
        this.activate(bc);
    }

    public void stop() {
        if (!this.__Mstop) {
            this.__stop();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "stop", new Object[0]);
            this.__stop();
            this.__IM.onExit((Object)this, "stop", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "stop", throwable);
            throw throwable;
        }
    }

    @Invalidate
    private void __stop() {
        this.deactivate();
    }

    public String getLabel() {
        String string;
        if (!this.__MgetLabel) {
            return this.__getLabel();
        }
        try {
            this.__IM.onEntry((Object)this, "getLabel", new Object[0]);
            string = this.__getLabel();
            this.__IM.onExit((Object)this, "getLabel", (Object)string);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getLabel", throwable);
            throw throwable;
        }
        return string;
    }

    private String __getLabel() {
        return this.__getm_label();
    }

    public String getTitle() {
        String string;
        if (!this.__MgetTitle) {
            return this.__getTitle();
        }
        try {
            this.__IM.onEntry((Object)this, "getTitle", new Object[0]);
            string = this.__getTitle();
            this.__IM.onExit((Object)this, "getTitle", (Object)string);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getTitle", throwable);
            throw throwable;
        }
        return string;
    }

    private String __getTitle() {
        return this.__getm_title();
    }

    private int getValidCount() {
        int n;
        if (!this.__MgetValidCount) {
            return this.__getValidCount();
        }
        try {
            this.__IM.onEntry((Object)this, "getValidCount", new Object[0]);
            n = this.__getValidCount();
            this.__IM.onExit((Object)this, "getValidCount", (Object)new Integer(n));
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getValidCount", throwable);
            throw throwable;
        }
        return n;
    }

    private int __getValidCount() {
        int i = 0;
        for (Architecture a : this.__getm_archs()) {
            if (a.getInstanceDescription().getState() != 2) continue;
            ++i;
        }
        return i;
    }

    private int getInvalidCount() {
        int n;
        if (!this.__MgetInvalidCount) {
            return this.__getInvalidCount();
        }
        try {
            this.__IM.onEntry((Object)this, "getInvalidCount", new Object[0]);
            n = this.__getInvalidCount();
            this.__IM.onExit((Object)this, "getInvalidCount", (Object)new Integer(n));
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getInvalidCount", throwable);
            throw throwable;
        }
        return n;
    }

    private int __getInvalidCount() {
        int i = 0;
        for (Architecture a : this.__getm_archs()) {
            if (a.getInstanceDescription().getState() != 1) continue;
            ++i;
        }
        return i;
    }

    protected void renderContent(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        if (!this.__MrenderContent$javax_servlet_http_HttpServletRequest$javax_servlet_http_HttpServletResponse) {
            this.__renderContent(httpServletRequest, httpServletResponse);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "renderContent$javax_servlet_http_HttpServletRequest$javax_servlet_http_HttpServletResponse", new Object[]{httpServletRequest, httpServletResponse});
            this.__renderContent(httpServletRequest, httpServletResponse);
            this.__IM.onExit((Object)this, "renderContent$javax_servlet_http_HttpServletRequest$javax_servlet_http_HttpServletResponse", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "renderContent$javax_servlet_http_HttpServletRequest$javax_servlet_http_HttpServletResponse", throwable);
            throw throwable;
        }
    }

    private void __renderContent(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        PrintWriter writer = res.getWriter();
        writer.write("<script type=\"text/javascript\"> function setSortable() { \n$(document).ready(function() { \n$(\"#plugin_table\").tablesorter(); \n})};\nsetSortable();</script>");
        writer.write("<div class=\"fullwidth\"><div class=\"statusline\">" + this.__getm_archs().size() + " instances in total, " + this.getValidCount() + " valid instances, " + this.getInvalidCount() + " invalid instances." + "</div></div>");
        writer.write("<form action=\"ipojo\" method=\"get\"><div class=\"fullwidth\"><div class=\"buttons\"><button style=\"margin-left: 30px;\" name=\"instance\" value=\"all\" type=\"submit\">Instances</button><button style=\"margin-left: 30px;\" name=\"factory\" value=\"all\" type=\"submit\">Factories</button><button style=\"margin-left: 30px;\" name=\"handler\" value=\"all\" type=\"submit\">Handlers</button></div></div></form>");
        RequestInfo ri = new RequestInfo(req);
        if (ri.m_type.equals(FACTORY)) {
            if (ri.m_all) {
                this.printFactoryList(writer);
            } else {
                this.printFactoryDetail(writer, ri.m_name);
            }
        }
        if (ri.m_type.equals(INSTANCE)) {
            if (ri.m_all) {
                this.printInstanceList(writer);
            } else {
                this.printInstanceDetail(writer, ri.m_name);
            }
        }
        if (ri.m_type.equals(HANDLER) && ri.m_all) {
            this.printHandlerList(writer);
        }
        writer.write("<form action=\"ipojo\" method=\"get\"><div class=\"fullwidth\"><div class=\"buttons\"><button style=\"margin-left: 30px;\" name=\"instance\" value=\"all\" type=\"submit\">Instances</button><button style=\"margin-left: 30px;\" name=\"factory\" value=\"all\" type=\"submit\">Factories</button><button style=\"margin-left: 30px;\" name=\"handler\" value=\"all\" type=\"submit\">Handlers</button></div></div></form>");
        writer.write("<div class=\"fullwidth\"><div class=\"statusline\">" + this.__getm_archs().size() + " instances in total, " + this.getValidCount() + " valid instances, " + this.getInvalidCount() + " invalid instances." + "</div></div>");
    }

    private void printFactoryDetail(PrintWriter printWriter, String string) {
        if (!this.__MprintFactoryDetail$java_io_PrintWriter$java_lang_String) {
            this.__printFactoryDetail(printWriter, string);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "printFactoryDetail$java_io_PrintWriter$java_lang_String", new Object[]{printWriter, string});
            this.__printFactoryDetail(printWriter, string);
            this.__IM.onExit((Object)this, "printFactoryDetail$java_io_PrintWriter$java_lang_String", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "printFactoryDetail$java_io_PrintWriter$java_lang_String", throwable);
            throw throwable;
        }
    }

    private void __printFactoryDetail(PrintWriter pw, String name) {
        ArrayList<ComponentTypeDescription> fs = new ArrayList<ComponentTypeDescription>();
        for (Factory f : this.__getm_factories()) {
            if (!f.getName().equals(name)) continue;
            fs.add(f.getComponentDescription());
        }
        pw.write("<div class=\"table\">");
        if (fs.isEmpty()) {
            pw.write("<b>Factory not found</b><br>The factory " + name + " does not exist or is private");
        } else {
            for (ComponentTypeDescription factory : fs) {
                pw.write("<table class=\"tablelayout\" border=\"0\"><tbody>");
                this.addEntry(pw, "Factory Name", factory.getName());
                if (factory.getVersion() != null) {
                    this.addEntry(pw, "Factory Version", factory.getVersion());
                }
                this.addEntry(pw, "State", this.getFactoryState(factory.getFactory().getState()));
                this.addEntry(pw, " ", " ");
                if (factory.getprovidedServiceSpecification() != null && factory.getprovidedServiceSpecification().length != 0) {
                    this.addEntry(pw, "Provided Service Specification", Arrays.toString(factory.getprovidedServiceSpecification()));
                }
                if (factory.getProperties() != null && factory.getProperties().length != 0) {
                    this.addEntry(pw, "Properties", this.getProperties(factory.getProperties()));
                }
                this.addEntry(pw, " ", " ");
                this.addEntry(pw, "Required Handlers", factory.getFactory().getRequiredHandlers().toString());
                this.addEntry(pw, "Missing Handlers", factory.getFactory().getMissingHandlers().toString());
                this.addEntry(pw, " ", " ");
                this.addEntry(pw, "Created Instances", this.getInstanceList(factory.getName()));
                this.addEntry(pw, " ", " ");
                this.addEntry(pw, "Architecture", "<div style=\"overflow: auto; width:800px; border: 1px solid #666; background-color: #ccc; padding: 8px;\"><pre>" + factory.getDescription().toString() + "</pre></div>");
                pw.write("</tbody></table>");
            }
        }
        pw.write("</div>");
    }

    private String getProperties(PropertyDescription[] propertyDescriptionArray) {
        String string;
        if (!this.__MgetProperties$org_apache_felix_ipojo_architecture_PropertyDescription__) {
            return this.__getProperties(propertyDescriptionArray);
        }
        try {
            this.__IM.onEntry((Object)this, "getProperties$org_apache_felix_ipojo_architecture_PropertyDescription__", new Object[]{propertyDescriptionArray});
            string = this.__getProperties(propertyDescriptionArray);
            this.__IM.onExit((Object)this, "getProperties$org_apache_felix_ipojo_architecture_PropertyDescription__", (Object)string);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getProperties$org_apache_felix_ipojo_architecture_PropertyDescription__", throwable);
            throw throwable;
        }
        return string;
    }

    private String __getProperties(PropertyDescription[] properties) {
        String s = "<table class=\"tablelayout\" style=\"border-top: 1px solid #6181A9;\"><thead style=\"border-top: 1px solid #6181A9;\"><tr><th>Property Name</th><th>Property Type</th><th>Mandatory</th><th>Immutable</th><th>Value</th></tr></thead><tbody>";
        for (PropertyDescription pd : properties) {
            String name = pd.getName();
            String type = pd.getType();
            boolean mandatory = pd.isMandatory();
            boolean immutable = pd.isImmutable();
            String value = pd.getValue();
            s = s + "<tr><td>" + name + "</td>" + "<td>" + type + "</td>" + "<td>" + "" + mandatory + "</td>" + "<td>" + "" + immutable + "</td>" + "<td>" + (value == null ? "<i>No Value</i>" : value) + "</td>" + "</tr>";
        }
        s = s + "</tbody></table>";
        return s;
    }

    private void printInstanceList(PrintWriter printWriter) {
        if (!this.__MprintInstanceList$java_io_PrintWriter) {
            this.__printInstanceList(printWriter);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "printInstanceList$java_io_PrintWriter", new Object[]{printWriter});
            this.__printInstanceList(printWriter);
            this.__IM.onExit((Object)this, "printInstanceList$java_io_PrintWriter", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "printInstanceList$java_io_PrintWriter", throwable);
            throw throwable;
        }
    }

    private void __printInstanceList(PrintWriter pw) {
        pw.write("<div class=\"table\"><table id=\"plugin_table\" class=\"tablelayout\"><thead><tr><th class=\"col_Name header headerSortDown\">Instance Name</th><th class=\"col_Factory header \">Factory Name</th><th class=\"col_State header \">State</th></tr></thead><tbody>");
        for (Architecture arch : this.__getm_archs()) {
            InstanceDescription id = arch.getInstanceDescription();
            String name = id.getName();
            String factory = id.getComponentDescription().getName();
            String state = this.getInstanceState(id.getState());
            pw.write("<tr><td>" + this.getInstanceLink(name) + "</td>" + "<td>" + factory + "</td>" + "<td>" + state + "</td>" + "</tr>");
        }
        pw.write("</tbody></table>");
    }

    private void addEntry(PrintWriter printWriter, String string, String string2) {
        if (!this.__MaddEntry$java_io_PrintWriter$java_lang_String$java_lang_String) {
            this.__addEntry(printWriter, string, string2);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "addEntry$java_io_PrintWriter$java_lang_String$java_lang_String", new Object[]{printWriter, string, string2});
            this.__addEntry(printWriter, string, string2);
            this.__IM.onExit((Object)this, "addEntry$java_io_PrintWriter$java_lang_String$java_lang_String", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "addEntry$java_io_PrintWriter$java_lang_String$java_lang_String", throwable);
            throw throwable;
        }
    }

    private void __addEntry(PrintWriter pw, String header, String value) {
        pw.write(this.addEntry(header, value));
    }

    private String addEntry(String string, String string2) {
        String string3;
        if (!this.__MaddEntry$java_lang_String$java_lang_String) {
            return this.__addEntry(string, string2);
        }
        try {
            this.__IM.onEntry((Object)this, "addEntry$java_lang_String$java_lang_String", new Object[]{string, string2});
            string3 = this.__addEntry(string, string2);
            this.__IM.onExit((Object)this, "addEntry$java_lang_String$java_lang_String", (Object)string3);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "addEntry$java_lang_String$java_lang_String", throwable);
            throw throwable;
        }
        return string3;
    }

    private String __addEntry(String header, String value) {
        return "<tr><td class=\"aligntop\" nowrap=\"true\" style=\"border: 0px none;\">" + header + "</td>" + "<td class=\"aligntop\" style=\"border: 0px none ;\">" + value + "</td>" + "</tr>";
    }

    private String getFactoryLinkIfPossible(InstanceDescription instanceDescription) {
        String string;
        if (!this.__MgetFactoryLinkIfPossible$org_apache_felix_ipojo_architecture_InstanceDescription) {
            return this.__getFactoryLinkIfPossible(instanceDescription);
        }
        try {
            this.__IM.onEntry((Object)this, "getFactoryLinkIfPossible$org_apache_felix_ipojo_architecture_InstanceDescription", new Object[]{instanceDescription});
            string = this.__getFactoryLinkIfPossible(instanceDescription);
            this.__IM.onExit((Object)this, "getFactoryLinkIfPossible$org_apache_felix_ipojo_architecture_InstanceDescription", (Object)string);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getFactoryLinkIfPossible$org_apache_felix_ipojo_architecture_InstanceDescription", throwable);
            throw throwable;
        }
        return string;
    }

    private String __getFactoryLinkIfPossible(InstanceDescription id) {
        String n = id.getComponentDescription().getName();
        System.out.println("Look for " + n);
        for (Factory f : this.__getm_factories()) {
            if (!f.getName().equals(n)) continue;
            return "<a href=\"ipojo?factory=" + n + "\">" + n + "</a>";
        }
        return n;
    }

    private String getInvalidHandlerList(HandlerDescription[] handlerDescriptionArray) {
        String string;
        if (!this.__MgetInvalidHandlerList$org_apache_felix_ipojo_architecture_HandlerDescription__) {
            return this.__getInvalidHandlerList(handlerDescriptionArray);
        }
        try {
            this.__IM.onEntry((Object)this, "getInvalidHandlerList$org_apache_felix_ipojo_architecture_HandlerDescription__", new Object[]{handlerDescriptionArray});
            string = this.__getInvalidHandlerList(handlerDescriptionArray);
            this.__IM.onExit((Object)this, "getInvalidHandlerList$org_apache_felix_ipojo_architecture_HandlerDescription__", (Object)string);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getInvalidHandlerList$org_apache_felix_ipojo_architecture_HandlerDescription__", throwable);
            throw throwable;
        }
        return string;
    }

    private String __getInvalidHandlerList(HandlerDescription[] hl) {
        ArrayList<String> list = new ArrayList<String>();
        for (HandlerDescription hd : hl) {
            if (hd.isValid()) continue;
            list.add(hd.getHandlerName());
        }
        return ((Object)list).toString();
    }

    private void printInstanceDetail(PrintWriter printWriter, String string) {
        if (!this.__MprintInstanceDetail$java_io_PrintWriter$java_lang_String) {
            this.__printInstanceDetail(printWriter, string);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "printInstanceDetail$java_io_PrintWriter$java_lang_String", new Object[]{printWriter, string});
            this.__printInstanceDetail(printWriter, string);
            this.__IM.onExit((Object)this, "printInstanceDetail$java_io_PrintWriter$java_lang_String", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "printInstanceDetail$java_io_PrintWriter$java_lang_String", throwable);
            throw throwable;
        }
    }

    private void __printInstanceDetail(PrintWriter pw, String name) {
        InstanceDescription desc = this.getInstanceDescriptionByName(name);
        pw.write("<div class=\"table\">");
        if (desc == null) {
            pw.write("<b>Instance not found</b><br>The instance " + name + " does not exist or does not expose its architecture");
        } else {
            pw.write("<table class=\"tablelayout\" border=\"0\"><tbody>");
            this.addEntry(pw, "Instance Name", desc.getName());
            this.addEntry(pw, "Factory", this.getFactoryLinkIfPossible(desc));
            if (desc.getState() == 1) {
                this.addEntry(pw, "Invalid Handlers", this.getInvalidHandlerList(desc.getHandlers()));
            }
            this.addEntry(pw, " ", " ");
            this.addEntry(pw, "Provided Services", this.getProvidedServiceDetail(desc.getHandlerDescription("org.apache.felix.ipojo:provides")));
            this.addEntry(pw, "Required Services", this.getRequiredServiceDetail(desc.getHandlerDescription("org.apache.felix.ipojo:requires")));
            this.addEntry(pw, " ", " ");
            this.addEntry(pw, "Architecture", "<div style=\"overflow: auto; width:800px; border: 1px solid #666; background-color: #ccc; padding: 8px;\"><pre>" + desc.getDescription().toString() + "</pre></div>");
            pw.write("</tbody></table>");
        }
        pw.write("</div>");
    }

    private String getInstanceLink(String string) {
        String string2;
        if (!this.__MgetInstanceLink$java_lang_String) {
            return this.__getInstanceLink(string);
        }
        try {
            this.__IM.onEntry((Object)this, "getInstanceLink$java_lang_String", new Object[]{string});
            string2 = this.__getInstanceLink(string);
            this.__IM.onExit((Object)this, "getInstanceLink$java_lang_String", (Object)string2);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getInstanceLink$java_lang_String", throwable);
            throw throwable;
        }
        return string2;
    }

    private String __getInstanceLink(String name) {
        return "<a href=\"ipojo?instance=" + name + "\">" + name + "</a>";
    }

    private String getServiceProperties(Properties properties) {
        String string;
        if (!this.__MgetServiceProperties$java_util_Properties) {
            return this.__getServiceProperties(properties);
        }
        try {
            this.__IM.onEntry((Object)this, "getServiceProperties$java_util_Properties", new Object[]{properties});
            string = this.__getServiceProperties(properties);
            this.__IM.onExit((Object)this, "getServiceProperties$java_util_Properties", (Object)string);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getServiceProperties$java_util_Properties", throwable);
            throw throwable;
        }
        return string;
    }

    private String __getServiceProperties(Properties properties) {
        String s = "<ul>";
        Enumeration<Object> e = properties.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            String value = properties.get(key).toString();
            s = s + "<li>" + key + " = " + value + "</li>";
        }
        s = s + "</ul>";
        return s;
    }

    private String getInstanceList(String string) {
        String string2;
        if (!this.__MgetInstanceList$java_lang_String) {
            return this.__getInstanceList(string);
        }
        try {
            this.__IM.onEntry((Object)this, "getInstanceList$java_lang_String", new Object[]{string});
            string2 = this.__getInstanceList(string);
            this.__IM.onExit((Object)this, "getInstanceList$java_lang_String", (Object)string2);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getInstanceList$java_lang_String", throwable);
            throw throwable;
        }
        return string2;
    }

    private String __getInstanceList(String factory) {
        String s = "<ul>";
        for (Architecture arch : this.__getm_archs()) {
            String n = arch.getInstanceDescription().getComponentDescription().getName();
            if (!factory.equals(n)) continue;
            s = s + "<li>" + this.getInstanceLink(arch.getInstanceDescription().getName()) + "</li>";
        }
        s = s + "</ul>";
        return s;
    }

    private String getServiceReferenceList(List<ServiceReference> list) {
        String string;
        if (!this.__MgetServiceReferenceList$java_util_List) {
            return this.__getServiceReferenceList(list);
        }
        try {
            this.__IM.onEntry((Object)this, "getServiceReferenceList$java_util_List", new Object[]{list});
            string = this.__getServiceReferenceList(list);
            this.__IM.onExit((Object)this, "getServiceReferenceList$java_util_List", (Object)string);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getServiceReferenceList$java_util_List", throwable);
            throw throwable;
        }
        return string;
    }

    private String __getServiceReferenceList(List<ServiceReference> refs) {
        String s = "<ul>";
        for (ServiceReference ref : refs) {
            s = s + "<li>";
            s = ref.getProperty("instance.name") == null ? s + ref.getProperty("service.id") : s + "<a href=\"ipojo?instance=" + ref.getProperty("instance.name") + "\">" + ref.getProperty("instance.name") + " (" + ref.getProperty("service.id") + ")</a>";
            s = s + "</li>";
        }
        s = s + "</ul>";
        return s;
    }

    private String getProvidedServiceDetail(HandlerDescription handlerDescription) {
        String string;
        if (!this.__MgetProvidedServiceDetail$org_apache_felix_ipojo_architecture_HandlerDescription) {
            return this.__getProvidedServiceDetail(handlerDescription);
        }
        try {
            this.__IM.onEntry((Object)this, "getProvidedServiceDetail$org_apache_felix_ipojo_architecture_HandlerDescription", new Object[]{handlerDescription});
            string = this.__getProvidedServiceDetail(handlerDescription);
            this.__IM.onExit((Object)this, "getProvidedServiceDetail$org_apache_felix_ipojo_architecture_HandlerDescription", (Object)string);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getProvidedServiceDetail$org_apache_felix_ipojo_architecture_HandlerDescription", throwable);
            throw throwable;
        }
        return string;
    }

    private String __getProvidedServiceDetail(HandlerDescription hd) {
        if (hd == null) {
            return "No provided services";
        }
        String r = "";
        ProvidedServiceHandlerDescription desc = (ProvidedServiceHandlerDescription)hd;
        for (ProvidedServiceDescription ps : desc.getProvidedServices()) {
            r = r + "<table border=\"0\"><tbody>";
            r = r + this.addEntry("Specification", Arrays.toString(ps.getServiceSpecifications()));
            r = r + this.addEntry("State", this.getProvidedServiceState(ps.getState()));
            if (ps.getServiceReference() != null) {
                r = r + this.addEntry("Service Id", ((Long)ps.getServiceReference().getProperty("service.id")).toString());
            }
            r = r + this.addEntry("Service Properties", this.getServiceProperties(ps.getProperties()));
            r = r + "</tbody></table>";
            r = r + "<hr style=\"color: #CCCCCC;'\"/>";
        }
        return r;
    }

    private String getRequiredServiceDetail(HandlerDescription handlerDescription) {
        String string;
        if (!this.__MgetRequiredServiceDetail$org_apache_felix_ipojo_architecture_HandlerDescription) {
            return this.__getRequiredServiceDetail(handlerDescription);
        }
        try {
            this.__IM.onEntry((Object)this, "getRequiredServiceDetail$org_apache_felix_ipojo_architecture_HandlerDescription", new Object[]{handlerDescription});
            string = this.__getRequiredServiceDetail(handlerDescription);
            this.__IM.onExit((Object)this, "getRequiredServiceDetail$org_apache_felix_ipojo_architecture_HandlerDescription", (Object)string);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getRequiredServiceDetail$org_apache_felix_ipojo_architecture_HandlerDescription", throwable);
            throw throwable;
        }
        return string;
    }

    private String __getRequiredServiceDetail(HandlerDescription hd) {
        if (hd == null) {
            return "No required services";
        }
        String r = "";
        DependencyHandlerDescription desc = (DependencyHandlerDescription)hd;
        for (DependencyDescription dep : desc.getDependencies()) {
            r = r + "<table border=\"0\" style=\"margin-bottom:5px\"><tbody>";
            r = r + this.addEntry("Specification", dep.getSpecification());
            r = r + this.addEntry("Id", "" + dep.getId());
            r = r + this.addEntry("State", this.getDependencyState(dep.getState()));
            r = r + this.addEntry("Binding Policy", this.getDependencyBindingPolicy(dep.getPolicy()));
            r = r + this.addEntry("Optional", "" + dep.isOptional());
            r = r + this.addEntry("Aggregate", "" + dep.isMultiple());
            if (dep.getFilter() != null) {
                r = r + this.addEntry("Filter", "" + dep.getFilter());
            }
            if (dep.getComparator() != null) {
                r = r + this.addEntry("Comparator", "" + dep.getComparator());
            }
            r = r + this.addEntry("Matching Services", this.getServiceReferenceList(dep.getServiceReferences()));
            r = r + this.addEntry("Used Services", this.getServiceReferenceList(dep.getUsedServices()));
            r = r + "</tbody></table>";
            r = r + "<hr style=\"color: #CCCCCC;'\"/>";
        }
        return r;
    }

    private InstanceDescription getInstanceDescriptionByName(String string) {
        InstanceDescription instanceDescription;
        if (!this.__MgetInstanceDescriptionByName$java_lang_String) {
            return this.__getInstanceDescriptionByName(string);
        }
        try {
            this.__IM.onEntry((Object)this, "getInstanceDescriptionByName$java_lang_String", new Object[]{string});
            instanceDescription = this.__getInstanceDescriptionByName(string);
            this.__IM.onExit((Object)this, "getInstanceDescriptionByName$java_lang_String", (Object)instanceDescription);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getInstanceDescriptionByName$java_lang_String", throwable);
            throw throwable;
        }
        return instanceDescription;
    }

    private InstanceDescription __getInstanceDescriptionByName(String name) {
        for (Architecture arch : this.__getm_archs()) {
            if (!name.equals(arch.getInstanceDescription().getName())) continue;
            return arch.getInstanceDescription();
        }
        return null;
    }

    private void printFactoryList(PrintWriter printWriter) {
        if (!this.__MprintFactoryList$java_io_PrintWriter) {
            this.__printFactoryList(printWriter);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "printFactoryList$java_io_PrintWriter", new Object[]{printWriter});
            this.__printFactoryList(printWriter);
            this.__IM.onExit((Object)this, "printFactoryList$java_io_PrintWriter", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "printFactoryList$java_io_PrintWriter", throwable);
            throw throwable;
        }
    }

    private void __printFactoryList(PrintWriter pw) {
        pw.write("<div class=\"table\"><table id=\"plugin_table\" class=\"tablelayout\"><thead><tr><th class=\"col_Name header headerSortDown\">Factory Name</th><th class=\"col_Bundle header \">Bundle</th><th class=\"col_State header \">State</th></tr></thead><tbody>");
        for (Factory factory : this.__getm_factories()) {
            String name = factory.getName();
            String version = factory.getVersion();
            String state = this.getFactoryState(factory.getState());
            String bundle = factory.getBundleContext().getBundle().getSymbolicName() + " (" + factory.getBundleContext().getBundle().getBundleId() + ")";
            pw.write("<tr><td><a href=\"ipojo?factory=" + name + "\">" + (version == null ? name : name + " (" + version + ")") + "</a></td>" + "<td>" + bundle + "</td>" + "<td>" + state + "</td>" + "</tr>");
        }
        pw.write("</tbody></table>");
    }

    private void printHandlerList(PrintWriter printWriter) {
        if (!this.__MprintHandlerList$java_io_PrintWriter) {
            this.__printHandlerList(printWriter);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "printHandlerList$java_io_PrintWriter", new Object[]{printWriter});
            this.__printHandlerList(printWriter);
            this.__IM.onExit((Object)this, "printHandlerList$java_io_PrintWriter", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "printHandlerList$java_io_PrintWriter", throwable);
            throw throwable;
        }
    }

    private void __printHandlerList(PrintWriter pw) {
        pw.write("<div class=\"table\"><table id=\"plugin_table\" class=\"tablelayout\"><thead><tr><th class=\"col_Name header headerSortDown\">Handler Name</th><th class=\"col_Type header \">Handler Type</th><th class=\"col_Bundle header \">Bundle</th><th class=\"col_State header \">State</th><th class=\"col_MissingHandler header \">Missing Handler</th></tr></thead><tbody>");
        for (HandlerFactory hf : this.__getm_handlers()) {
            String name = hf.getHandlerName();
            String type = hf.getType();
            String state = this.getFactoryState(hf.getState());
            String bundle = hf.getBundleContext().getBundle().getSymbolicName() + " (" + hf.getBundleContext().getBundle().getBundleId() + ")";
            String missing = hf.getMissingHandlers().isEmpty() ? "<i>no missing handlers</i>" : hf.getMissingHandlers().toString();
            pw.write("<tr><td>" + name + "</td>" + "<td>" + type + "</td>" + "<td>" + bundle + "</td>" + "<td>" + state + "</td>" + "<td>" + missing + "</td>" + "</tr>");
        }
        pw.write("</tbody></table>");
    }

    private String getInstanceState(int n) {
        String string;
        if (!this.__MgetInstanceState$int) {
            return this.__getInstanceState(n);
        }
        try {
            this.__IM.onEntry((Object)this, "getInstanceState$int", new Object[]{new Integer(n)});
            string = this.__getInstanceState(n);
            this.__IM.onExit((Object)this, "getInstanceState$int", (Object)string);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getInstanceState$int", throwable);
            throw throwable;
        }
        return string;
    }

    private String __getInstanceState(int state) {
        switch (state) {
            case 2: {
                return "valid";
            }
            case 1: {
                return "invalid";
            }
            case -1: {
                return "disposed";
            }
            case 0: {
                return "stopped";
            }
        }
        return "unknown";
    }

    private String getFactoryState(int n) {
        String string;
        if (!this.__MgetFactoryState$int) {
            return this.__getFactoryState(n);
        }
        try {
            this.__IM.onEntry((Object)this, "getFactoryState$int", new Object[]{new Integer(n)});
            string = this.__getFactoryState(n);
            this.__IM.onExit((Object)this, "getFactoryState$int", (Object)string);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getFactoryState$int", throwable);
            throw throwable;
        }
        return string;
    }

    private String __getFactoryState(int state) {
        switch (state) {
            case 1: {
                return "valid";
            }
            case 0: {
                return "invalid";
            }
        }
        return "unknown";
    }

    private String getDependencyState(int n) {
        String string;
        if (!this.__MgetDependencyState$int) {
            return this.__getDependencyState(n);
        }
        try {
            this.__IM.onEntry((Object)this, "getDependencyState$int", new Object[]{new Integer(n)});
            string = this.__getDependencyState(n);
            this.__IM.onExit((Object)this, "getDependencyState$int", (Object)string);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getDependencyState$int", throwable);
            throw throwable;
        }
        return string;
    }

    private String __getDependencyState(int state) {
        switch (state) {
            case 1: {
                return "resolved";
            }
            case 0: {
                return "unresolved";
            }
            case -1: {
                return "broken";
            }
        }
        return "unknown (" + state + ")";
    }

    private String getDependencyBindingPolicy(int n) {
        String string;
        if (!this.__MgetDependencyBindingPolicy$int) {
            return this.__getDependencyBindingPolicy(n);
        }
        try {
            this.__IM.onEntry((Object)this, "getDependencyBindingPolicy$int", new Object[]{new Integer(n)});
            string = this.__getDependencyBindingPolicy(n);
            this.__IM.onExit((Object)this, "getDependencyBindingPolicy$int", (Object)string);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getDependencyBindingPolicy$int", throwable);
            throw throwable;
        }
        return string;
    }

    private String __getDependencyBindingPolicy(int policy) {
        switch (policy) {
            case 0: {
                return "dynamic";
            }
            case 2: {
                return "dynamic-priority";
            }
            case 1: {
                return "static";
            }
        }
        return "unknown (" + policy + ")";
    }

    private String getProvidedServiceState(int n) {
        String string;
        if (!this.__MgetProvidedServiceState$int) {
            return this.__getProvidedServiceState(n);
        }
        try {
            this.__IM.onEntry((Object)this, "getProvidedServiceState$int", new Object[]{new Integer(n)});
            string = this.__getProvidedServiceState(n);
            this.__IM.onExit((Object)this, "getProvidedServiceState$int", (Object)string);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getProvidedServiceState$int", throwable);
            throw throwable;
        }
        return string;
    }

    private String __getProvidedServiceState(int state) {
        switch (state) {
            case 1: {
                return "registered";
            }
            case 0: {
                return "unregistered";
            }
        }
        return "unknown (" + state + ")";
    }

    private void _setInstanceManager(InstanceManager instanceManager) {
        if (instanceManager == null) {
            return;
        }
        this.__IM = instanceManager;
        Set set = this.__IM.getRegistredFields();
        if (set != null) {
            if (set.contains("m_title")) {
                this.__Fm_title = true;
            }
            if (set.contains("m_handlers")) {
                this.__Fm_handlers = true;
            }
            if (set.contains("m_label")) {
                this.__Fm_label = true;
            }
            if (set.contains("m_factories")) {
                this.__Fm_factories = true;
            }
            if (set.contains("m_archs")) {
                this.__Fm_archs = true;
            }
        }
        if ((set = this.__IM.getRegistredMethods()) != null) {
            if (set.contains("stop")) {
                this.__Mstop = true;
            }
            if (set.contains("getLabel")) {
                this.__MgetLabel = true;
            }
            if (set.contains("getTitle")) {
                this.__MgetTitle = true;
            }
            if (set.contains("getValidCount")) {
                this.__MgetValidCount = true;
            }
            if (set.contains("getInvalidCount")) {
                this.__MgetInvalidCount = true;
            }
            if (set.contains("renderContent$javax_servlet_http_HttpServletRequest$javax_servlet_http_HttpServletResponse")) {
                this.__MrenderContent$javax_servlet_http_HttpServletRequest$javax_servlet_http_HttpServletResponse = true;
            }
            if (set.contains("printFactoryDetail$java_io_PrintWriter$java_lang_String")) {
                this.__MprintFactoryDetail$java_io_PrintWriter$java_lang_String = true;
            }
            if (set.contains("getProperties$org_apache_felix_ipojo_architecture_PropertyDescription__")) {
                this.__MgetProperties$org_apache_felix_ipojo_architecture_PropertyDescription__ = true;
            }
            if (set.contains("printInstanceList$java_io_PrintWriter")) {
                this.__MprintInstanceList$java_io_PrintWriter = true;
            }
            if (set.contains("addEntry$java_io_PrintWriter$java_lang_String$java_lang_String")) {
                this.__MaddEntry$java_io_PrintWriter$java_lang_String$java_lang_String = true;
            }
            if (set.contains("addEntry$java_lang_String$java_lang_String")) {
                this.__MaddEntry$java_lang_String$java_lang_String = true;
            }
            if (set.contains("getFactoryLinkIfPossible$org_apache_felix_ipojo_architecture_InstanceDescription")) {
                this.__MgetFactoryLinkIfPossible$org_apache_felix_ipojo_architecture_InstanceDescription = true;
            }
            if (set.contains("getInvalidHandlerList$org_apache_felix_ipojo_architecture_HandlerDescription__")) {
                this.__MgetInvalidHandlerList$org_apache_felix_ipojo_architecture_HandlerDescription__ = true;
            }
            if (set.contains("printInstanceDetail$java_io_PrintWriter$java_lang_String")) {
                this.__MprintInstanceDetail$java_io_PrintWriter$java_lang_String = true;
            }
            if (set.contains("getInstanceLink$java_lang_String")) {
                this.__MgetInstanceLink$java_lang_String = true;
            }
            if (set.contains("getServiceProperties$java_util_Properties")) {
                this.__MgetServiceProperties$java_util_Properties = true;
            }
            if (set.contains("getInstanceList$java_lang_String")) {
                this.__MgetInstanceList$java_lang_String = true;
            }
            if (set.contains("getServiceReferenceList$java_util_List")) {
                this.__MgetServiceReferenceList$java_util_List = true;
            }
            if (set.contains("getProvidedServiceDetail$org_apache_felix_ipojo_architecture_HandlerDescription")) {
                this.__MgetProvidedServiceDetail$org_apache_felix_ipojo_architecture_HandlerDescription = true;
            }
            if (set.contains("getRequiredServiceDetail$org_apache_felix_ipojo_architecture_HandlerDescription")) {
                this.__MgetRequiredServiceDetail$org_apache_felix_ipojo_architecture_HandlerDescription = true;
            }
            if (set.contains("getInstanceDescriptionByName$java_lang_String")) {
                this.__MgetInstanceDescriptionByName$java_lang_String = true;
            }
            if (set.contains("printFactoryList$java_io_PrintWriter")) {
                this.__MprintFactoryList$java_io_PrintWriter = true;
            }
            if (set.contains("printHandlerList$java_io_PrintWriter")) {
                this.__MprintHandlerList$java_io_PrintWriter = true;
            }
            if (set.contains("getInstanceState$int")) {
                this.__MgetInstanceState$int = true;
            }
            if (set.contains("getFactoryState$int")) {
                this.__MgetFactoryState$int = true;
            }
            if (set.contains("getDependencyState$int")) {
                this.__MgetDependencyState$int = true;
            }
            if (set.contains("getDependencyBindingPolicy$int")) {
                this.__MgetDependencyBindingPolicy$int = true;
            }
            if (set.contains("getProvidedServiceState$int")) {
                this.__MgetProvidedServiceState$int = true;
            }
        }
    }

    public ComponentInstance getComponentInstance() {
        return this.__IM;
    }

    private final class RequestInfo {
        public final String m_name;
        public final String m_type;
        public final boolean m_all;

        protected RequestInfo(HttpServletRequest request) {
            String factory = request.getParameter(IPOJOServlet.FACTORY);
            String instance = request.getParameter(IPOJOServlet.INSTANCE);
            String handler = request.getParameter(IPOJOServlet.HANDLER);
            if (factory != null) {
                this.m_type = IPOJOServlet.FACTORY;
                this.m_name = factory;
            } else if (instance != null) {
                this.m_type = IPOJOServlet.INSTANCE;
                this.m_name = instance;
            } else if (handler != null) {
                this.m_type = IPOJOServlet.HANDLER;
                this.m_name = handler;
            } else {
                this.m_type = IPOJOServlet.INSTANCE;
                this.m_name = IPOJOServlet.ALL;
            }
            this.m_all = IPOJOServlet.ALL.equals(this.m_name);
            request.setAttribute(IPOJOServlet.class.getName(), (Object)this);
        }

        public String toString() {
            return "Request: " + this.m_type + "=" + this.m_name;
        }
    }
}

