/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.gogo.runtime;

import org.apache.felix.gogo.runtime.EOFError;
import org.apache.felix.gogo.runtime.Evaluate;
import org.apache.felix.gogo.runtime.SyntaxError;
import org.apache.felix.gogo.runtime.Token;

public class Tokenizer {
    private static final boolean DEBUG = false;
    private static final char EOT = '\uffff';
    private final CharSequence text;
    private final Evaluate evaluate;
    private final boolean inArray;
    private final boolean inQuote;
    private Type type = Type.NEWLINE;
    private CharSequence value;
    private Token token;
    private short line;
    private short column;
    private char ch;
    private int index;
    private boolean firstWord;

    public Tokenizer(CharSequence text) {
        this(text, null, false);
    }

    public Tokenizer(CharSequence text, Evaluate evaluate, boolean inQuote) {
        this.text = text;
        this.evaluate = evaluate;
        this.inQuote = inQuote;
        this.index = 0;
        this.column = 1;
        this.line = 1;
        boolean array = false;
        if (text instanceof Token) {
            Token t = (Token)text;
            this.line = t.line;
            this.column = t.column;
            array = Type.ARRAY == t.type;
        }
        this.inArray = array;
        this.getch();
    }

    public Type type() {
        return this.type;
    }

    public CharSequence value() {
        return this.value;
    }

    public Token token() {
        return this.token;
    }

    public Type next() {
        short tColumn;
        short tLine;
        Type prevType = this.type;
        this.token = null;
        this.value = null;
        block11: while (true) {
            this.skipSpace();
            tLine = this.line;
            tColumn = this.column;
            switch (this.ch) {
                case '\uffff': {
                    this.type = Type.EOT;
                    break block11;
                }
                case '\n': {
                    this.getch();
                    if (this.inArray) continue block11;
                    switch (prevType) {
                        case PIPE: 
                        case SEMICOLON: 
                        case NEWLINE: {
                            continue block11;
                        }
                    }
                    this.type = Type.NEWLINE;
                    break block11;
                }
                case '(': 
                case '[': 
                case '{': {
                    this.value = this.group();
                    this.getch();
                    break block11;
                }
                case ';': {
                    this.getch();
                    this.type = Type.SEMICOLON;
                    break block11;
                }
                case '|': {
                    this.getch();
                    this.type = Type.PIPE;
                    break block11;
                }
                case '=': {
                    if (this.firstWord || this.inArray) {
                        this.getch();
                        this.type = Type.ASSIGN;
                        break block11;
                    }
                }
                default: {
                    this.value = this.word();
                    this.type = Type.WORD;
                }
            }
            break;
        }
        this.firstWord = Type.WORD == this.type && Type.WORD != prevType && Type.ASSIGN != prevType;
        this.token = new Token(this.type, this.value, tLine, tColumn);
        return this.type;
    }

    private CharSequence word() {
        int start = this.index - 1;
        int skipCR = 0;
        block8: do {
            switch (this.ch) {
                case '\n': {
                    if (this.index >= 2 && this.text.charAt(this.index - 2) == '\r') {
                        skipCR = 1;
                    }
                }
                case '=': {
                    if ((Type.WORD == this.type || Type.ASSIGN == this.type) && '=' == this.ch && !this.inArray) continue block8;
                }
                case '\t': 
                case ' ': 
                case ';': 
                case '|': {
                    return this.text.subSequence(start, this.index - 1 - skipCR);
                }
                case '{': {
                    this.group();
                    break;
                }
                case '\\': {
                    this.escape();
                    break;
                }
                case '\"': 
                case '\'': {
                    this.skipQuote();
                }
            }
        } while (this.getch() != '\uffff');
        return this.text.subSequence(start, this.index - 1);
    }

    private CharSequence group() {
        char pop;
        char push = this.ch;
        switch (this.ch) {
            case '{': {
                this.type = Type.CLOSURE;
                pop = '}';
                break;
            }
            case '(': {
                this.type = Type.EXECUTION;
                pop = ')';
                break;
            }
            case '[': {
                this.type = Type.ARRAY;
                pop = ']';
                break;
            }
            default: {
                assert (false);
                pop = '\u0000';
            }
        }
        short sLine = this.line;
        short sCol = this.column;
        int start = this.index;
        int depth = 1;
        block12: while (true) {
            boolean comment = false;
            switch (this.ch) {
                case '\n': 
                case '(': 
                case '[': 
                case '{': {
                    comment = true;
                }
            }
            if (this.getch() == '\uffff') {
                throw new EOFError(sLine, sCol, "unexpected EOT looking for matching '" + pop + "'");
            }
            if (comment || this.isBlank(this.ch)) {
                this.skipSpace();
            }
            switch (this.ch) {
                case '\"': 
                case '\'': {
                    this.skipQuote();
                    continue block12;
                }
                case '\\': {
                    this.ch = this.escape();
                    continue block12;
                }
            }
            if (push == this.ch) {
                ++depth;
                continue;
            }
            if (pop == this.ch && --depth == 0) break;
        }
        return this.text.subSequence(start, this.index - 1);
    }

    private char escape() {
        assert ('\\' == this.ch);
        switch (this.getch()) {
            case 'u': {
                this.getch();
                this.getch();
                this.getch();
                this.getch();
                if ('\uffff' == this.ch) {
                    throw new EOFError(this.line, this.column, "unexpected EOT in \\u escape");
                }
                String u = ((Object)this.text.subSequence(this.index - 4, this.index)).toString();
                try {
                    return (char)Integer.parseInt(u, 16);
                }
                catch (NumberFormatException e) {
                    throw new SyntaxError(this.line, this.column, "bad unicode escape: \\u" + u);
                }
            }
            case '\uffff': {
                throw new EOFError(this.line, this.column, "unexpected EOT in \\ escape");
            }
            case '\n': {
                return '\u0000';
            }
            case '\"': 
            case '$': 
            case '\'': 
            case '\\': {
                return this.ch;
            }
        }
        return this.ch;
    }

    private void skipQuote() {
        assert ('\'' == this.ch || '\"' == this.ch);
        char quote = this.ch;
        short sLine = this.line;
        short sCol = this.column;
        while (this.getch() != '\uffff') {
            if (quote == this.ch) {
                return;
            }
            if (quote != '\"' || '\\' != this.ch) continue;
            this.escape();
        }
        throw new EOFError(sLine, sCol, "unexpected EOT looking for matching quote: " + quote);
    }

    private void skipSpace() {
        block0: while (true) {
            if (this.isBlank(this.ch)) {
                this.getch();
                continue;
            }
            if ('\\' == this.ch && this.peek() == '\n') {
                this.getch();
                this.getch();
                continue;
            }
            if ('/' != this.ch && '#' != this.ch) break;
            if ('#' == this.ch || this.peek() == '/') {
                while (true) {
                    if (this.getch() == '\uffff' || '\n' == this.ch) continue block0;
                }
            }
            if ('*' != this.peek()) break;
            short sLine = this.line;
            short sCol = this.column;
            this.getch();
            while (this.getch() != '\uffff' && ('*' != this.ch || this.peek() != '/')) {
            }
            if ('\uffff' == this.ch) {
                throw new EOFError(sLine, sCol, "unexpected EOT looking for closing comment: */");
            }
            this.getch();
            this.getch();
        }
    }

    private boolean isBlank(char ch) {
        return ' ' == ch || '\t' == ch;
    }

    private boolean isName(char ch) {
        return Character.isJavaIdentifierPart(ch) && ch != '$' || '.' == ch;
    }

    public static Object expand(CharSequence word, Evaluate eval) {
        return Tokenizer.expand(word, eval, false);
    }

    private static Object expand(CharSequence word, Evaluate eval, boolean inQuote) {
        String special = "$\\\"'";
        int i = word.length();
        while (--i >= 0 && "$\\\"'".indexOf(word.charAt(i)) == -1) {
        }
        if (i < 0) {
            return word;
        }
        return new Tokenizer(word, eval, inQuote).expand();
    }

    public Object expand(CharSequence word, short line, short column) {
        return Tokenizer.expand(new Token(Type.WORD, word, line, column), this.evaluate, this.inQuote);
    }

    private Token word(CharSequence value) {
        return new Token(Type.WORD, value, this.line, this.column);
    }

    private Object expand() {
        StringBuilder buf = new StringBuilder();
        block6: while (this.ch != '\uffff') {
            int start = this.index;
            switch (this.ch) {
                case '$': {
                    Object val = this.expandVar();
                    if ('\uffff' == this.ch && buf.length() == 0) {
                        return val;
                    }
                    if (null == val) continue block6;
                    buf.append(val);
                    continue block6;
                }
                case '\\': {
                    int n = this.ch = this.inQuote && "u$\\\n\"".indexOf(this.peek()) == -1 ? 92 : this.escape();
                    if (this.ch == '\u0000') break;
                    buf.append(this.ch);
                    break;
                }
                case '\"': {
                    Token ww = this.word(null);
                    this.skipQuote();
                    ww.value = this.text.subSequence(start, this.index - 1);
                    this.value = ww;
                    Object expand = Tokenizer.expand(this.value, this.evaluate, true);
                    if (this.eot() && buf.length() == 0 && this.value.equals(expand)) {
                        return ww.value;
                    }
                    if (null == expand) break;
                    buf.append(expand.toString());
                    break;
                }
                case '\'': {
                    if (!this.inQuote) {
                        this.skipQuote();
                        this.value = this.text.subSequence(start, this.index - 1);
                        if (this.eot() && buf.length() == 0) {
                            return this.value;
                        }
                        buf.append(this.value);
                        break;
                    }
                }
                default: {
                    buf.append(this.ch);
                }
            }
            this.getch();
        }
        return buf.toString();
    }

    private Object expandVar() {
        Object val;
        assert ('$' == this.ch);
        if (this.getch() != '{') {
            int start = this.index - 1;
            while (this.isName(this.ch)) {
                this.getch();
            }
            if (this.index - 1 == start) {
                val = "$";
            } else {
                String name = ((Object)this.text.subSequence(start, this.index - 1)).toString();
                val = this.evaluate.get(name);
            }
        } else {
            int i;
            short sLine = this.line;
            short sCol = this.column;
            CharSequence group = this.group();
            block9: for (i = 0; i < group.length(); ++i) {
                switch (group.charAt(i)) {
                    case '+': 
                    case '-': 
                    case ':': 
                    case '=': 
                    case '?': {
                        break block9;
                    }
                    default: {
                        continue block9;
                    }
                }
            }
            sCol = (short)(sCol + i);
            String name = String.valueOf(this.expand(group.subSequence(0, i), sLine, sCol));
            for (int j = 0; j < name.length(); ++j) {
                if (this.isName(name.charAt(j))) continue;
                throw new SyntaxError(sLine, sCol, "bad name: ${" + group + "}");
            }
            val = this.evaluate.get(name);
            if (i < group.length()) {
                int c;
                if (58 == (c = group.charAt(i++))) {
                    c = i < group.length() ? (int)group.charAt(i++) : 65535;
                }
                CharSequence word = group.subSequence(i, group.length());
                switch (c) {
                    case 45: 
                    case 61: {
                        if (null != val) break;
                        val = Tokenizer.expand(word, this.evaluate, false);
                        if (61 != c) break;
                        this.evaluate.put(name, val);
                        break;
                    }
                    case 43: {
                        if (null == val) break;
                        val = Tokenizer.expand(word, this.evaluate, false);
                        break;
                    }
                    case 63: {
                        if (null != val) break;
                        val = Tokenizer.expand(word, this.evaluate, false);
                        if (null == val || val.toString().length() == 0) {
                            val = "parameter not set";
                        }
                        throw new IllegalArgumentException(name + ": " + val);
                    }
                    default: {
                        throw new SyntaxError(sLine, sCol, "bad substitution: ${" + group + "}");
                    }
                }
            }
            this.getch();
        }
        return val;
    }

    private boolean eot() {
        return this.index >= this.text.length();
    }

    private char getch() {
        this.ch = this.getch(false);
        return this.ch;
    }

    private char peek() {
        return this.getch(true);
    }

    private char getch(boolean peek) {
        char c;
        if (this.eot()) {
            if (!peek) {
                ++this.index;
                this.ch = (char)65535;
            }
            return '\uffff';
        }
        int current = this.index;
        if ('\r' == (c = this.text.charAt(this.index++)) && !this.eot() && this.text.charAt(this.index) == '\n') {
            c = this.text.charAt(this.index++);
        }
        if (peek) {
            this.index = current;
        } else if ('\n' == c) {
            this.line = (short)(this.line + 1);
            this.column = 0;
        } else {
            this.column = (short)(this.column + 1);
        }
        return c;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        ASSIGN('='),
        PIPE('|'),
        SEMICOLON(';'),
        NEWLINE,
        ARRAY,
        CLOSURE,
        EXECUTION,
        WORD,
        EOT;

        private char c;

        private Type() {
        }

        private Type(char c) {
            this.c = c;
        }

        public String toString() {
            return this.c == '\u0000' ? super.toString() : "'" + this.c + "'";
        }
    }
}

