/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.dm.impl.metatype;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.felix.dm.PropertyMetaData;
import org.apache.felix.dm.impl.metatype.AttributeDefinitionImpl;
import org.apache.felix.dm.impl.metatype.PropertyMetaDataImpl;
import org.apache.felix.dm.impl.metatype.Resource;
import org.osgi.service.metatype.AttributeDefinition;
import org.osgi.service.metatype.ObjectClassDefinition;

public class ObjectClassDefinitionImpl
implements ObjectClassDefinition {
    private String m_name;
    private String m_description;
    private String m_id;
    private final List<PropertyMetaData> m_propertiesMetaData;
    private Resource m_resource;

    public ObjectClassDefinitionImpl(String id, String name, String description, List<PropertyMetaData> propertiesMetaData, Resource resource) {
        this.m_id = id;
        this.m_name = name;
        this.m_description = description;
        this.m_propertiesMetaData = propertiesMetaData;
        this.m_resource = resource;
    }

    public AttributeDefinition[] getAttributeDefinitions(int filter) {
        ArrayList<AttributeDefinitionImpl> attrs = new ArrayList<AttributeDefinitionImpl>();
        int i = 0;
        while (i < this.m_propertiesMetaData.size()) {
            PropertyMetaDataImpl metaData = (PropertyMetaDataImpl)this.m_propertiesMetaData.get(i);
            switch (filter) {
                case -1: {
                    attrs.add(new AttributeDefinitionImpl(metaData, this.m_resource));
                    break;
                }
                case 2: {
                    if (metaData.isRequired()) break;
                    attrs.add(new AttributeDefinitionImpl(metaData, this.m_resource));
                    break;
                }
                case 1: {
                    if (!metaData.isRequired()) break;
                    attrs.add(new AttributeDefinitionImpl(metaData, this.m_resource));
                }
            }
            ++i;
        }
        AttributeDefinitionImpl[] array = new AttributeDefinitionImpl[attrs.size()];
        return attrs.toArray(array);
    }

    public String getDescription() {
        return this.m_resource.localize(this.m_description);
    }

    public String getID() {
        return this.m_id;
    }

    public InputStream getIcon(int size) throws IOException {
        return null;
    }

    public String getName() {
        return this.m_resource.localize(this.m_name);
    }
}

