/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.dm.impl;

import java.util.Dictionary;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import org.apache.felix.dm.Component;
import org.apache.felix.dm.ComponentDeclaration;
import org.apache.felix.dm.ComponentDependencyDeclaration;
import org.apache.felix.dm.ComponentStateListener;
import org.apache.felix.dm.Dependency;
import org.apache.felix.dm.DependencyManager;
import org.apache.felix.dm.Logger;
import org.apache.felix.dm.context.ComponentContext;
import org.apache.felix.dm.context.DependencyContext;
import org.apache.felix.dm.context.Event;
import org.apache.felix.dm.context.EventType;
import org.apache.felix.dm.impl.AbstractDecorator;
import org.apache.felix.dm.impl.ComponentImpl;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

public class FilterComponent
implements Component,
ComponentContext,
ComponentDeclaration {
    protected volatile ComponentImpl m_component;
    protected volatile List<ComponentStateListener> m_stateListeners = new CopyOnWriteArrayList<ComponentStateListener>();
    protected volatile String m_init = "init";
    protected volatile String m_start = "start";
    protected volatile String m_stop = "stop";
    protected volatile String m_destroy = "destroy";
    protected volatile Object m_callbackObject;
    protected volatile Object m_compositionInstance;
    protected volatile String m_compositionMethod;
    protected volatile String[] m_serviceInterfaces;
    protected volatile Object m_serviceImpl;
    protected volatile Object m_factory;
    protected volatile String m_factoryCreateMethod;
    protected volatile Dictionary<String, Object> m_serviceProperties;

    public FilterComponent(Component service) {
        this.m_component = (ComponentImpl)service;
    }

    @Override
    public Executor getExecutor() {
        return this.m_component.getExecutor();
    }

    public String toString() {
        return this.m_component.toString();
    }

    @Override
    public Component add(Dependency ... dependencies) {
        AbstractDecorator ad;
        this.m_component.add(dependencies);
        Dependency[] dependencyArray = dependencies;
        int n = dependencies.length;
        int n2 = 0;
        while (n2 < n) {
            Dependency dependency = dependencyArray[n2];
            if (((DependencyContext)dependency).isRequired()) {
                return this;
            }
            ++n2;
        }
        Object[] instances = this.m_component.getInstances();
        if (instances.length > 0 && (ad = (AbstractDecorator)instances[0]) != null) {
            ad.addDependency(dependencies);
        }
        return this;
    }

    @Override
    public Component add(ComponentStateListener listener) {
        AbstractDecorator ad;
        this.m_stateListeners.add(listener);
        Object[] instances = this.m_component.getInstances();
        if (instances.length > 0 && (ad = (AbstractDecorator)instances[0]) != null) {
            ad.addStateListener(listener);
        }
        return this;
    }

    @Override
    public List<DependencyContext> getDependencies() {
        return this.m_component.getDependencies();
    }

    @Override
    public String getClassName() {
        return this.m_component.getClassName();
    }

    public Dictionary<String, Object> getServiceProperties() {
        return this.m_serviceProperties;
    }

    @Override
    public ServiceRegistration getServiceRegistration() {
        return this.m_component.getServiceRegistration();
    }

    @Override
    public Component remove(Dependency dependency) {
        AbstractDecorator ad;
        Object[] instances;
        this.m_component.remove(dependency);
        if (!((DependencyContext)dependency).isRequired() && (instances = this.m_component.getInstances()).length > 0 && (ad = (AbstractDecorator)instances[0]) != null) {
            ad.removeDependency(dependency);
        }
        return this;
    }

    @Override
    public Component remove(ComponentStateListener listener) {
        AbstractDecorator ad;
        this.m_stateListeners.remove(listener);
        Object[] instances = this.m_component.getInstances();
        if (instances.length > 0 && (ad = (AbstractDecorator)instances[0]) != null) {
            ad.removeStateListener(listener);
        }
        return this;
    }

    @Override
    public Component setCallbacks(Object instance, String init, String start, String stop, String destroy) {
        this.m_component.ensureNotActive();
        this.m_callbackObject = instance;
        this.m_init = init;
        this.m_start = start;
        this.m_stop = stop;
        this.m_destroy = destroy;
        return this;
    }

    @Override
    public Component setCallbacks(String init, String start, String stop, String destroy) {
        this.setCallbacks(null, init, start, stop, destroy);
        return this;
    }

    @Override
    public Component setComposition(Object instance, String getMethod) {
        this.m_component.ensureNotActive();
        this.m_compositionInstance = instance;
        this.m_compositionMethod = getMethod;
        return this;
    }

    @Override
    public Component setComposition(String getMethod) {
        this.m_component.ensureNotActive();
        this.m_compositionMethod = getMethod;
        return this;
    }

    @Override
    public Component setFactory(Object factory, String createMethod) {
        this.m_component.ensureNotActive();
        this.m_factory = factory;
        this.m_factoryCreateMethod = createMethod;
        return this;
    }

    @Override
    public Component setFactory(String createMethod) {
        return this.setFactory(null, createMethod);
    }

    @Override
    public Component setImplementation(Object implementation) {
        this.m_component.ensureNotActive();
        this.m_serviceImpl = implementation;
        return this;
    }

    @Override
    public Component setInterface(String serviceName, Dictionary<?, ?> properties) {
        return this.setInterface(new String[]{serviceName}, properties);
    }

    @Override
    public Component setInterface(String[] serviceInterfaces, Dictionary<?, ?> properties) {
        this.m_component.ensureNotActive();
        if (serviceInterfaces != null) {
            this.m_serviceInterfaces = new String[serviceInterfaces.length];
            System.arraycopy(serviceInterfaces, 0, this.m_serviceInterfaces, 0, serviceInterfaces.length);
            this.m_serviceProperties = properties;
        }
        return this;
    }

    @Override
    public Component setServiceProperties(Dictionary<?, ?> serviceProperties) {
        AbstractDecorator ad;
        Object[] instances;
        this.m_serviceProperties = serviceProperties;
        if (serviceProperties != null && (instances = this.m_component.getInstances()).length > 0 && (ad = (AbstractDecorator)instances[0]) != null) {
            ad.setServiceProperties(serviceProperties);
        }
        return this;
    }

    @Override
    public void start() {
        this.m_component.start();
    }

    @Override
    public void stop() {
        this.m_component.stop();
    }

    @Override
    public void invokeCallbackMethod(Object[] instances, String methodName, Class<?>[][] signatures, Object[][] parameters) {
        this.m_component.invokeCallbackMethod(instances, methodName, signatures, parameters);
    }

    @Override
    public DependencyManager getDependencyManager() {
        return this.m_component.getDependencyManager();
    }

    @Override
    public Component setAutoConfig(Class<?> clazz, boolean autoConfig) {
        this.m_component.setAutoConfig(clazz, autoConfig);
        return this;
    }

    @Override
    public Component setAutoConfig(Class<?> clazz, String instanceName) {
        this.m_component.setAutoConfig(clazz, instanceName);
        return this;
    }

    @Override
    public boolean getAutoConfig(Class<?> clazz) {
        return this.m_component.getAutoConfig(clazz);
    }

    @Override
    public String getAutoConfigInstance(Class<?> clazz) {
        return this.m_component.getAutoConfigInstance(clazz);
    }

    @Override
    public ComponentDependencyDeclaration[] getComponentDependencies() {
        return this.m_component.getComponentDependencies();
    }

    @Override
    public String getName() {
        return this.m_component.getName();
    }

    @Override
    public int getState() {
        return this.m_component.getState();
    }

    @Override
    public long getId() {
        return this.m_component.getId();
    }

    @Override
    public String[] getServices() {
        return this.m_component.getServices();
    }

    @Override
    public BundleContext getBundleContext() {
        return this.m_component.getBundleContext();
    }

    @Override
    public boolean isActive() {
        return this.m_component.isActive();
    }

    @Override
    public boolean isAvailable() {
        return this.m_component.isAvailable();
    }

    @Override
    public void handleEvent(DependencyContext dc, EventType type, Event ... e) {
        this.m_component.handleEvent(dc, type, e);
    }

    @Override
    public <T> T getInstance() {
        return this.m_component.getInstance();
    }

    @Override
    public Object[] getInstances() {
        return this.m_component.getInstances();
    }

    @Override
    public Event getDependencyEvent(DependencyContext dc) {
        return this.m_component.getDependencyEvent(dc);
    }

    @Override
    public Set<Event> getDependencyEvents(DependencyContext dc) {
        return this.m_component.getDependencyEvents(dc);
    }

    @Override
    public ComponentDeclaration getComponentDeclaration() {
        return this;
    }

    @Override
    public Component setDebug(String label) {
        this.m_component.setDebug(label);
        return this;
    }

    @Override
    public void setThreadPool(Executor threadPool) {
        this.m_component.setThreadPool(threadPool);
    }

    @Override
    public Map<String, Long> getCallbacksTime() {
        return this.m_component.getCallbacksTime();
    }

    @Override
    public Bundle getBundle() {
        return this.m_component.getBundle();
    }

    @Override
    public Logger getLogger() {
        return this.m_component.getLogger();
    }
}

