/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.dm.tracker;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.felix.dm.impl.SerialExecutor;
import org.apache.felix.dm.tracker.AbstractCustomizerActionSet;

abstract class AbstractTracked {
    private static final boolean DEBUG = false;
    private Map tracked;
    private int trackingCount = 0;
    private final List adding;
    volatile boolean closed = false;
    private final LinkedList initial;
    private final SerialExecutor m_executor = new SerialExecutor(null);

    AbstractTracked() {
        this.tracked = new HashMap();
        this.adding = new ArrayList(6);
        this.initial = new LinkedList();
    }

    void setTracked(HashMap map) {
        this.tracked = map;
    }

    void setInitial(Object[] list) {
        if (list == null) {
            return;
        }
        for (Object item : list) {
            if (item == null) continue;
            this.initial.add(item);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void trackInitial() {
        while (true) {
            AbstractTracked abstractTracked = this;
            synchronized (abstractTracked) {
                if (this.closed || this.initial.size() == 0) {
                    return;
                }
                Object item = this.initial.removeFirst();
                if (this.tracked.get(item) != null) {
                    continue;
                }
                if (this.adding.contains(item)) {
                    continue;
                }
                this.adding.add(item);
                final AbstractCustomizerActionSet actionSet = this.trackAdding(item, null);
                this.m_executor.schedule(new Runnable(){

                    @Override
                    public void run() {
                        actionSet.execute();
                    }
                });
            }
        }
    }

    void close() {
        this.closed = true;
    }

    abstract AbstractCustomizerActionSet createCustomizerActionSet();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    AbstractCustomizerActionSet track(Object item, Object related) {
        Object object;
        AbstractCustomizerActionSet actionSet = this.createCustomizerActionSet();
        AbstractTracked abstractTracked = this;
        synchronized (abstractTracked) {
            if (this.closed) {
                return actionSet;
            }
            object = this.tracked.get(item);
            if (object == null) {
                if (this.adding.contains(item)) {
                    return actionSet;
                }
                this.adding.add(item);
            } else {
                this.modified();
            }
        }
        if (object == null) {
            actionSet.appendActionSet(this.trackAdding(item, related));
        } else {
            actionSet.addCustomizerModified(item, related, object);
        }
        return actionSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AbstractCustomizerActionSet trackAdding(Object item, Object related) {
        AbstractCustomizerActionSet actionSet = this.createCustomizerActionSet();
        Object object = null;
        boolean becameUntracked = false;
        try {
            object = this.customizerAdding(item, related);
        }
        finally {
            boolean needToCallback = false;
            AbstractTracked abstractTracked = this;
            synchronized (abstractTracked) {
                if (this.adding.remove(item) && !this.closed) {
                    if (object != null) {
                        this.tracked.put(item, object);
                        this.modified();
                        this.notifyAll();
                        needToCallback = true;
                    }
                } else {
                    becameUntracked = true;
                }
            }
            if (needToCallback) {
                actionSet.addCustomizerAdded(item, related, object);
            }
        }
        if (becameUntracked && object != null) {
            actionSet.addCustomizerRemoved(item, related, object);
        }
        return actionSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    AbstractCustomizerActionSet untrack(Object item, Object related) {
        Object object;
        AbstractCustomizerActionSet actionSet = this.createCustomizerActionSet();
        AbstractTracked abstractTracked = this;
        synchronized (abstractTracked) {
            if (this.initial.remove(item)) {
                return actionSet;
            }
            if (this.adding.remove(item)) {
                return actionSet;
            }
            object = this.tracked.remove(item);
            if (object == null) {
                return actionSet;
            }
            this.modified();
        }
        actionSet.addCustomizerRemoved(item, related, object);
        return actionSet;
    }

    int size() {
        return this.tracked.size();
    }

    Object getCustomizedObject(Object item) {
        return this.tracked.get(item);
    }

    Object[] getTracked(Object[] list) {
        return this.tracked.keySet().toArray(list);
    }

    void modified() {
        ++this.trackingCount;
    }

    int getTrackingCount() {
        return this.trackingCount;
    }

    SerialExecutor getExecutor() {
        return this.m_executor;
    }

    abstract Object customizerAdding(Object var1, Object var2);

    abstract void customizerAdded(Object var1, Object var2, Object var3);

    abstract void customizerModified(Object var1, Object var2, Object var3);

    abstract void customizerRemoved(Object var1, Object var2, Object var3);
}

