/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.dm.impl;

import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.felix.dm.Logger;

public class DispatchExecutor
implements Executor,
Runnable {
    private final Executor m_threadPool;
    protected final ConcurrentLinkedQueue<Runnable> m_tasks = new ConcurrentLinkedQueue();
    private volatile Thread m_executingThread;
    private final AtomicBoolean m_scheduled = new AtomicBoolean();
    private final Logger m_logger;

    public DispatchExecutor(Executor threadPool, Logger logger) {
        this.m_logger = logger;
        this.m_threadPool = threadPool;
    }

    public void schedule(Runnable task) {
        this.m_tasks.add(task);
    }

    @Override
    public void execute(Runnable task) {
        this.execute(task, true);
    }

    public void execute(Runnable task, boolean threadpool) {
        Thread currThread = Thread.currentThread();
        if (this.m_executingThread == currThread) {
            this.runTask(task);
        } else {
            this.schedule(task);
            this.execute(threadpool);
        }
    }

    public void execute() {
        this.execute(true);
    }

    public void execute(boolean threadpool) {
        if (this.m_scheduled.compareAndSet(false, true)) {
            try {
                if (threadpool) {
                    this.m_threadPool.execute(this);
                } else {
                    this.run();
                }
            }
            catch (RejectedExecutionException e) {
                this.run();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            Runnable task;
            this.m_executingThread = Thread.currentThread();
            while ((task = this.m_tasks.poll()) != null) {
                this.runTask(task);
            }
        }
        finally {
            this.m_scheduled.set(false);
            this.m_executingThread = null;
            if (this.m_tasks.peek() != null) {
                this.execute();
            }
        }
    }

    private void runTask(Runnable task) {
        try {
            task.run();
        }
        catch (Throwable t) {
            this.m_logger.log(1, "Error processing tasks", t);
        }
    }
}

