/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.dm.impl;

import java.lang.reflect.InvocationTargetException;
import java.util.Dictionary;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.felix.dm.Component;
import org.apache.felix.dm.ConfigurationDependency;
import org.apache.felix.dm.Logger;
import org.apache.felix.dm.PropertyMetaData;
import org.apache.felix.dm.context.AbstractDependency;
import org.apache.felix.dm.context.DependencyContext;
import org.apache.felix.dm.context.Event;
import org.apache.felix.dm.context.EventType;
import org.apache.felix.dm.impl.ConfigurationEventImpl;
import org.apache.felix.dm.impl.InvocationUtil;
import org.apache.felix.dm.impl.metatype.MetaTypeProviderImpl;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ManagedService;

public class ConfigurationDependencyImpl
extends AbstractDependency<ConfigurationDependency>
implements ConfigurationDependency,
ManagedService {
    private Dictionary<String, Object> m_settings;
    private String m_pid;
    private ServiceRegistration m_registration;
    private MetaTypeProviderImpl m_metaType;
    private final AtomicBoolean m_updateInvokedCache = new AtomicBoolean();
    private final Logger m_logger;
    private final BundleContext m_context;

    public ConfigurationDependencyImpl() {
        this(null, null);
    }

    public ConfigurationDependencyImpl(BundleContext context, Logger logger) {
        this.m_context = context;
        this.m_logger = logger;
        this.setRequired(true);
        this.setCallback("updated");
    }

    public ConfigurationDependencyImpl(ConfigurationDependencyImpl prototype) {
        super(prototype);
        this.m_context = prototype.m_context;
        this.m_pid = prototype.m_pid;
        this.m_logger = prototype.m_logger;
        this.m_metaType = prototype.m_metaType != null ? new MetaTypeProviderImpl(prototype.m_metaType, this, null) : null;
    }

    @Override
    public Class<?> getAutoConfigType() {
        return null;
    }

    @Override
    public DependencyContext createCopy() {
        return new ConfigurationDependencyImpl(this);
    }

    @Override
    public ConfigurationDependencyImpl setCallback(String callback) {
        super.setCallbacks(callback, null);
        return this;
    }

    @Override
    public ConfigurationDependencyImpl setCallback(Object instance, String callback) {
        super.setCallbacks(instance, callback, null);
        return this;
    }

    @Override
    public boolean needsInstance() {
        return this.m_callbackInstance == null;
    }

    @Override
    public void start() {
        BundleContext context = this.m_component.getBundleContext();
        if (context != null) {
            Properties props = new Properties();
            props.put("service.pid", this.m_pid);
            Object ms = this;
            if (this.m_metaType != null) {
                ms = this.m_metaType;
            }
            this.m_registration = context.registerService(ManagedService.class.getName(), ms, (Dictionary)props);
        }
        super.start();
    }

    @Override
    public void stop() {
        if (this.m_registration != null) {
            try {
                this.m_registration.unregister();
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
            this.m_registration = null;
        }
        super.stop();
    }

    @Override
    public ConfigurationDependency setPid(String pid) {
        this.ensureNotActive();
        this.m_pid = pid;
        return this;
    }

    @Override
    public String getSimpleName() {
        return this.m_pid;
    }

    @Override
    public String getFilter() {
        return null;
    }

    @Override
    public String getType() {
        return "configuration";
    }

    @Override
    public ConfigurationDependency add(PropertyMetaData properties) {
        this.createMetaTypeImpl();
        this.m_metaType.add(properties);
        return this;
    }

    @Override
    public ConfigurationDependency setDescription(String description) {
        this.createMetaTypeImpl();
        this.m_metaType.setDescription(description);
        return this;
    }

    @Override
    public ConfigurationDependency setHeading(String heading) {
        this.createMetaTypeImpl();
        this.m_metaType.setName(heading);
        return this;
    }

    @Override
    public ConfigurationDependency setLocalization(String path) {
        this.createMetaTypeImpl();
        this.m_metaType.setLocalization(path);
        return this;
    }

    @Override
    public Dictionary<String, Object> getProperties() {
        if (this.m_settings == null) {
            throw new IllegalStateException("cannot find configuration");
        }
        return this.m_settings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updated(Dictionary settings) throws ConfigurationException {
        this.m_updateInvokedCache.set(false);
        Dictionary<String, Object> oldSettings = null;
        ConfigurationDependencyImpl configurationDependencyImpl = this;
        synchronized (configurationDependencyImpl) {
            oldSettings = this.m_settings;
        }
        if (oldSettings == null && settings == null) {
            return;
        }
        Object[] instances = this.m_component.getInstances();
        if (instances != null) {
            try {
                this.invokeUpdated(settings);
            }
            catch (ConfigurationException e) {
                this.logConfigurationException(e);
                throw e;
            }
        }
        ConfigurationDependencyImpl configurationDependencyImpl2 = this;
        synchronized (configurationDependencyImpl2) {
            this.m_settings = settings;
        }
        if (oldSettings == null && settings != null) {
            this.m_component.handleEvent(this, EventType.ADDED, new ConfigurationEventImpl(this.m_pid, settings));
        } else if (oldSettings != null && settings != null) {
            this.m_component.handleEvent(this, EventType.CHANGED, new ConfigurationEventImpl(this.m_pid, settings));
        } else if (oldSettings != null && settings == null) {
            this.m_component.handleEvent(this, EventType.REMOVED, new ConfigurationEventImpl(this.m_pid, oldSettings));
        }
    }

    @Override
    public void invokeCallback(EventType type, Event ... event) {
        switch (type) {
            case ADDED: {
                try {
                    this.invokeUpdated(this.m_settings);
                }
                catch (ConfigurationException e) {
                    this.logConfigurationException(e);
                }
                break;
            }
            case CHANGED: {
                break;
            }
            case REMOVED: {
                this.m_updateInvokedCache.set(false);
                break;
            }
        }
    }

    private void invokeUpdated(Dictionary<?, ?> settings) throws ConfigurationException {
        Object[] instances;
        if (this.m_updateInvokedCache.compareAndSet(false, true) && (instances = super.getInstances()) != null) {
            for (int i = 0; i < instances.length; ++i) {
                try {
                    InvocationUtil.invokeCallbackMethod(instances[i], this.m_add, new Class[][]{{Dictionary.class}, {Component.class, Dictionary.class}, new Class[0]}, new Object[][]{{settings}, {this.m_component, settings}, new Object[0]});
                    continue;
                }
                catch (InvocationTargetException e) {
                    if (e.getTargetException() instanceof ConfigurationException) {
                        throw (ConfigurationException)e.getTargetException();
                    }
                    throw new ConfigurationException(null, "Configuration update failed", e.getTargetException());
                }
                catch (NoSuchMethodException e) {
                    continue;
                }
                catch (Throwable t) {
                    throw new ConfigurationException(null, "Configuration update failed", t);
                }
            }
        }
    }

    private synchronized void createMetaTypeImpl() {
        if (this.m_metaType == null) {
            this.m_metaType = new MetaTypeProviderImpl(this.m_pid, this.m_context, this.m_logger, this, null);
        }
    }

    private void logConfigurationException(ConfigurationException e) {
        if (this.m_logger != null) {
            this.m_logger.log(1, "Got exception while handling configuration update for pid " + this.m_pid, e);
        }
    }
}

