/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.dm.tracker;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.felix.dm.impl.ServiceUtil;
import org.apache.felix.dm.tracker.AbstractCustomizerActionSet;
import org.apache.felix.dm.tracker.AbstractTracked;
import org.apache.felix.dm.tracker.ServiceTrackerCustomizer;
import org.osgi.framework.AllServiceListener;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.Version;

public class ServiceTracker
implements ServiceTrackerCustomizer {
    static final boolean DEBUG = false;
    protected final BundleContext context;
    protected final Filter filter;
    final ServiceTrackerCustomizer customizer;
    final String listenerFilter;
    private final String trackClass;
    private final ServiceReference trackReference;
    private volatile Tracked tracked;
    private volatile ServiceReference cachedReference;
    private volatile Object cachedService;
    private static final Version endMatchVersion = new Version(1, 5, 0);
    public boolean m_trackAllAspects;
    private boolean debug = false;
    private String debugKey;

    private Tracked tracked() {
        return this.tracked;
    }

    public void setDebug(String debugKey) {
        this.debug = true;
        this.debugKey = debugKey;
    }

    public ServiceTracker(BundleContext context, ServiceReference reference, ServiceTrackerCustomizer customizer) {
        this.context = context;
        this.trackReference = reference;
        this.trackClass = null;
        this.customizer = customizer == null ? this : customizer;
        this.listenerFilter = "(service.id=" + reference.getProperty("service.id").toString() + ")";
        try {
            this.filter = context.createFilter(this.listenerFilter);
        }
        catch (InvalidSyntaxException e) {
            IllegalArgumentException iae = new IllegalArgumentException("unexpected InvalidSyntaxException: " + e.getMessage());
            iae.initCause(e);
            throw iae;
        }
    }

    public ServiceTracker(BundleContext context, String clazz, ServiceTrackerCustomizer customizer) {
        this.context = context;
        this.trackReference = null;
        this.trackClass = clazz;
        this.customizer = customizer == null ? this : customizer;
        this.listenerFilter = "(objectClass=" + clazz.toString() + ")";
        try {
            this.filter = context.createFilter(this.listenerFilter);
        }
        catch (InvalidSyntaxException e) {
            IllegalArgumentException iae = new IllegalArgumentException("unexpected InvalidSyntaxException: " + e.getMessage());
            iae.initCause(e);
            throw iae;
        }
    }

    public ServiceTracker(final BundleContext context, Filter filter, ServiceTrackerCustomizer customizer) {
        this.context = context;
        this.trackReference = null;
        this.trackClass = null;
        Version frameworkVersion = AccessController.doPrivileged(new PrivilegedAction<Version>(){

            @Override
            public Version run() {
                String version = context.getProperty("org.osgi.framework.version");
                return version == null ? Version.emptyVersion : new Version(version);
            }
        });
        boolean endMatchSupported = frameworkVersion.compareTo((Object)endMatchVersion) >= 0;
        this.listenerFilter = endMatchSupported ? filter.toString() : null;
        this.filter = filter;
        ServiceTrackerCustomizer serviceTrackerCustomizer = this.customizer = customizer == null ? this : customizer;
        if (context == null || filter == null) {
            throw new NullPointerException();
        }
    }

    public void open() {
        this.open(false);
    }

    public void open(boolean trackAllServices) {
        this.open(trackAllServices, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void open(boolean trackAllServices, boolean trackAllAspects) {
        Tracked t;
        if (this.debug) {
            System.out.println("[ServiceTracker] " + this.debugKey + " T" + Thread.currentThread().getId() + " open");
        }
        ServiceTracker serviceTracker = this;
        synchronized (serviceTracker) {
            if (this.tracked != null) {
                return;
            }
            this.m_trackAllAspects = trackAllAspects;
            Tracked tracked = t = trackAllServices ? new AllTracked() : new Tracked();
            synchronized (tracked) {
                try {
                    this.context.addServiceListener((ServiceListener)t, this.listenerFilter);
                    Object[] references = null;
                    if (this.trackClass != null) {
                        references = this.getInitialReferences(trackAllServices, this.trackClass, null);
                    } else if (this.trackReference != null) {
                        if (this.trackReference.getBundle() != null) {
                            references = new ServiceReference[]{this.trackReference};
                        }
                    } else {
                        references = this.getInitialReferences(trackAllServices, null, this.listenerFilter != null ? this.listenerFilter : this.filter.toString());
                    }
                    t.setInitial(references);
                    t.trackInitial();
                }
                catch (InvalidSyntaxException e) {
                    throw new RuntimeException("unexpected InvalidSyntaxException: " + e.getMessage(), e);
                }
            }
            this.tracked = t;
        }
        t.getExecutor().execute();
    }

    private ServiceReference[] getInitialReferences(boolean trackAllServices, String className, String filterString) throws InvalidSyntaxException {
        if (trackAllServices) {
            return this.context.getAllServiceReferences(className, filterString);
        }
        return this.context.getServiceReferences(className, filterString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        ServiceReference[] references;
        Tracked outgoing;
        Object object = this;
        synchronized (object) {
            outgoing = this.tracked;
            if (outgoing == null) {
                return;
            }
            outgoing.close();
            references = this.getServiceReferences();
            this.tracked = null;
            try {
                this.context.removeServiceListener((ServiceListener)outgoing);
            }
            catch (IllegalStateException e) {
                // empty catch block
            }
        }
        this.modified();
        object = outgoing;
        synchronized (object) {
            outgoing.notifyAll();
        }
        if (references != null) {
            for (int i = 0; i < references.length; ++i) {
                outgoing.untrack(references[i], null).execute();
            }
        }
    }

    @Override
    public Object addingService(ServiceReference reference) {
        return this.context.getService(reference);
    }

    @Override
    public void addedService(ServiceReference reference, Object service) {
    }

    @Override
    public void modifiedService(ServiceReference reference, Object service) {
    }

    @Override
    public void removedService(ServiceReference reference, Object service) {
        this.context.ungetService(reference);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object waitForService(long timeout) throws InterruptedException {
        if (timeout < 0L) {
            throw new IllegalArgumentException("timeout value is negative");
        }
        Object object = this.getService();
        while (object == null) {
            Tracked t = this.tracked();
            if (t == null) {
                return null;
            }
            Tracked tracked = t;
            synchronized (tracked) {
                if (t.size() == 0) {
                    t.wait(timeout);
                }
            }
            object = this.getService();
            if (timeout <= 0L) continue;
            return object;
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServiceReference[] getServiceReferences() {
        Tracked t = this.tracked();
        if (t == null) {
            return null;
        }
        Tracked tracked = t;
        synchronized (tracked) {
            int length = t.size();
            if (length == 0) {
                return null;
            }
            return (ServiceReference[])t.getTracked(new ServiceReference[length]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasReference() {
        if (this.cachedReference != null) {
            return true;
        }
        Tracked t = this.tracked();
        if (t == null) {
            return false;
        }
        Tracked tracked = t;
        synchronized (tracked) {
            int length = t.size();
            return length > 0;
        }
    }

    public ServiceReference getServiceReference() {
        int length;
        ServiceReference reference = this.cachedReference;
        if (reference != null) {
            return reference;
        }
        ServiceReference[] references = this.getServiceReferences();
        int n = length = references == null ? 0 : references.length;
        if (length == 0) {
            return null;
        }
        int index = 0;
        if (length > 1) {
            int[] rankings = new int[length];
            int count = 0;
            int maxRanking = Integer.MIN_VALUE;
            for (int i = 0; i < length; ++i) {
                int ranking;
                Object property = references[i].getProperty("service.ranking");
                rankings[i] = ranking = property instanceof Integer ? (Integer)property : 0;
                if (ranking > maxRanking) {
                    index = i;
                    maxRanking = ranking;
                    count = 1;
                    continue;
                }
                if (ranking != maxRanking) continue;
                ++count;
            }
            if (count > 1) {
                long minId = Long.MAX_VALUE;
                for (int i = 0; i < length; ++i) {
                    long id;
                    if (rankings[i] != maxRanking || (id = ((Long)references[i].getProperty("service.id")).longValue()) >= minId) continue;
                    index = i;
                    minId = id;
                }
            }
        }
        this.cachedReference = references[index];
        return this.cachedReference;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getService(ServiceReference reference) {
        Tracked t = this.tracked();
        if (t == null) {
            return null;
        }
        Tracked tracked = t;
        synchronized (tracked) {
            return t.getCustomizedObject(reference);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] getServices() {
        Tracked t = this.tracked();
        if (t == null) {
            return null;
        }
        Tracked tracked = t;
        synchronized (tracked) {
            int length;
            ServiceReference[] references = this.getServiceReferences();
            int n = length = references == null ? 0 : references.length;
            if (length == 0) {
                return null;
            }
            Object[] objects = new Object[length];
            for (int i = 0; i < length; ++i) {
                objects[i] = this.getService(references[i]);
            }
            return objects;
        }
    }

    public Object getService() {
        Object service = this.cachedService;
        if (service != null) {
            return service;
        }
        ServiceReference reference = this.getServiceReference();
        if (reference == null) {
            return null;
        }
        this.cachedService = this.getService(reference);
        return this.cachedService;
    }

    public void remove(ServiceReference reference) {
        Tracked t = this.tracked();
        if (t == null) {
            return;
        }
        t.untrack(reference, null).execute();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        Tracked t = this.tracked();
        if (t == null) {
            return 0;
        }
        Tracked tracked = t;
        synchronized (tracked) {
            return t.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getTrackingCount() {
        Tracked t = this.tracked();
        if (t == null) {
            return -1;
        }
        Tracked tracked = t;
        synchronized (tracked) {
            return t.getTrackingCount();
        }
    }

    void modified() {
        this.cachedReference = null;
        this.cachedService = null;
    }

    private void debug(String message) {
        if (this.customizer.toString().equals("ServiceDependency[interface dm.it.AspectRaceTest$S (&(!(org.apache.felix.dependencymanager.aspect=*))(id=1))]")) {
            // empty if block
        }
    }

    @Override
    public void swappedService(ServiceReference reference, Object service, ServiceReference newReference, Object newService) {
    }

    Tracked getTracked() {
        return this.tracked;
    }

    private static final class RankedService {
        private int m_ranking;
        private ServiceReference m_serviceReference;

        public RankedService(int ranking, ServiceReference serviceReference) {
            this.m_ranking = ranking;
            this.m_serviceReference = serviceReference;
        }

        public void update(int ranking, ServiceReference serviceReference) {
            this.m_ranking = ranking;
            this.m_serviceReference = serviceReference;
        }

        public int getRanking() {
            return this.m_ranking;
        }

        public ServiceReference getServiceReference() {
            return this.m_serviceReference;
        }
    }

    class AllTracked
    extends Tracked
    implements AllServiceListener {
        AllTracked() {
            this.setTracked(new Tracked.HashMapCache());
        }
    }

    class Tracked
    extends AbstractTracked
    implements ServiceListener {
        private final Map<Long, TreeSet<ServiceReference>> m_highestTrackedCache = new HashMap<Long, TreeSet<ServiceReference>>();
        private final Map<Long, TreeSet<ServiceReference>> m_highestHiddenCache = new HashMap<Long, TreeSet<ServiceReference>>();
        private AtomicInteger step = new AtomicInteger();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private ServiceReference highestTrackedCache(long serviceId) {
            Long sid = serviceId;
            Tracked tracked = this;
            synchronized (tracked) {
                TreeSet<ServiceReference> services = this.m_highestTrackedCache.get(sid);
                if (services != null && services.size() > 0) {
                    ServiceReference result = services.last();
                    return result;
                }
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void addHighestTrackedCache(ServiceReference reference) {
            Long serviceId = ServiceUtil.getServiceIdObject(reference);
            Tracked tracked = this;
            synchronized (tracked) {
                TreeSet<Object> services = this.m_highestTrackedCache.get(serviceId);
                if (services == null) {
                    services = new TreeSet();
                    this.m_highestTrackedCache.put(serviceId, services);
                }
                services.add(reference);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void removeHighestTrackedCache(ServiceReference reference) {
            Long serviceId = ServiceUtil.getServiceIdObject(reference);
            Tracked tracked = this;
            synchronized (tracked) {
                TreeSet<ServiceReference> services = this.m_highestTrackedCache.get(serviceId);
                if (services != null) {
                    services.remove(reference);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void clearHighestTrackedCache() {
            Tracked tracked = this;
            synchronized (tracked) {
                this.m_highestTrackedCache.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private ServiceReference highestHiddenCache(long serviceId) {
            Long sid = serviceId;
            Tracked tracked = this;
            synchronized (tracked) {
                TreeSet<ServiceReference> services = this.m_highestHiddenCache.get(sid);
                if (services != null && services.size() > 0) {
                    ServiceReference result = services.last();
                    return result;
                }
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void addHighestHiddenCache(ServiceReference reference) {
            Long serviceId = ServiceUtil.getServiceIdObject(reference);
            Tracked tracked = this;
            synchronized (tracked) {
                TreeSet<Object> services = this.m_highestHiddenCache.get(serviceId);
                if (services == null) {
                    services = new TreeSet();
                    this.m_highestHiddenCache.put(serviceId, services);
                }
                services.add(reference);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void removeHighestHiddenCache(ServiceReference reference) {
            Long serviceId = ServiceUtil.getServiceIdObject(reference);
            Tracked tracked = this;
            synchronized (tracked) {
                TreeSet<ServiceReference> services = this.m_highestHiddenCache.get(serviceId);
                if (services != null) {
                    services.remove(reference);
                }
            }
        }

        private void hide(ServiceReference ref) {
            this.addHighestHiddenCache(ref);
        }

        private void unhide(ServiceReference ref) {
            this.removeHighestHiddenCache(ref);
        }

        Tracked() {
            this.setTracked(new HashMapCache());
        }

        @Override
        void setInitial(Object[] list) {
            if (list == null) {
                return;
            }
            if (ServiceTracker.this.m_trackAllAspects) {
                super.setInitial(list);
            } else {
                HashMap<Long, RankedService> highestRankedServiceMap = new HashMap<Long, RankedService>();
                for (int i = 0; i < list.length; ++i) {
                    ServiceReference sr = (ServiceReference)list[i];
                    if (sr == null) continue;
                    Long serviceId = ServiceUtil.getServiceIdAsLong(sr);
                    int ranking = ServiceUtil.getRanking(sr);
                    RankedService rs = (RankedService)highestRankedServiceMap.get(serviceId);
                    if (rs == null) {
                        highestRankedServiceMap.put(serviceId, new RankedService(ranking, sr));
                        continue;
                    }
                    if (ranking > rs.getRanking()) {
                        this.hide(rs.getServiceReference());
                        rs.update(ranking, sr);
                        continue;
                    }
                    this.hide(sr);
                }
                if (highestRankedServiceMap.size() > 0) {
                    Object[] result = new Object[highestRankedServiceMap.size()];
                    int index = 0;
                    for (Map.Entry entry : highestRankedServiceMap.entrySet()) {
                        result[index] = ((RankedService)entry.getValue()).getServiceReference();
                        ++index;
                    }
                    super.setInitial(result);
                }
            }
        }

        public void serviceChanged(ServiceEvent event) {
            if (ServiceTracker.this.m_trackAllAspects) {
                this.serviceChangedIncludeAspects(event);
            } else {
                this.serviceChangedHideAspects(event);
            }
        }

        public void serviceChangedIncludeAspects(ServiceEvent event) {
            if (this.closed) {
                return;
            }
            ServiceReference reference = event.getServiceReference();
            if (ServiceTracker.this.debug) {
                System.out.println("[ServiceTracker] " + ServiceTracker.this.debugKey + " T" + Thread.currentThread().getId() + " [serviceChangedIncludeAspects] " + reference.getProperty("service.ranking"));
            }
            switch (event.getType()) {
                case 1: 
                case 2: {
                    if (ServiceTracker.this.listenerFilter != null) {
                        this.track(reference, event).execute();
                        break;
                    }
                    if (ServiceTracker.this.filter.match(reference)) {
                        this.track(reference, event).execute();
                        break;
                    }
                    this.untrack(reference, event).execute();
                    break;
                }
                case 4: 
                case 8: {
                    this.untrack(reference, event).execute();
                }
            }
        }

        private boolean isModifiedEndmatchSupported() {
            return ServiceTracker.this.listenerFilter != null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void serviceChangedHideAspects(ServiceEvent event) {
            int n = this.step.getAndIncrement();
            if (this.closed) {
                return;
            }
            ServiceReference reference = event.getServiceReference();
            long sid = ServiceUtil.getServiceId(reference);
            AbstractCustomizerActionSet actionSet = null;
            Tracked tracked = this;
            synchronized (tracked) {
                switch (event.getType()) {
                    case 1: 
                    case 2: {
                        ServiceReference higherRankedReference = null;
                        ServiceReference lowerRankedReference = null;
                        ServiceReference highestTrackedReference = this.highestTrackedCache(sid);
                        if (highestTrackedReference != null) {
                            int highestTrackedRanking;
                            int ranking = ServiceUtil.getRanking(reference);
                            if (ranking > (highestTrackedRanking = ServiceUtil.getRanking(highestTrackedReference))) {
                                higherRankedReference = highestTrackedReference;
                            } else if (ranking < highestTrackedRanking) {
                                lowerRankedReference = highestTrackedReference;
                            }
                        }
                        if (this.isModifiedEndmatchSupported()) {
                            actionSet = this.registerOrUpdate(event, reference, higherRankedReference, lowerRankedReference);
                            break;
                        }
                        if (ServiceTracker.this.filter.match(reference)) {
                            actionSet = this.registerOrUpdate(event, reference, higherRankedReference, lowerRankedReference);
                            break;
                        }
                        actionSet = this.unregister(event, reference, sid);
                        break;
                    }
                    case 4: 
                    case 8: {
                        actionSet = this.unregister(event, reference, sid);
                    }
                }
                final AbstractCustomizerActionSet commandActionSet = actionSet;
                if (commandActionSet != null) {
                    this.getExecutor().schedule(new Runnable(){

                        @Override
                        public void run() {
                            commandActionSet.execute();
                        }
                    });
                }
            }
            this.getExecutor().execute();
        }

        private AbstractCustomizerActionSet registerOrUpdate(ServiceEvent event, ServiceReference reference, ServiceReference higher, ServiceReference lower) {
            if (ServiceTracker.this.debug) {
                // empty if block
            }
            AbstractCustomizerActionSet actionSet = null;
            if (lower != null) {
                this.hide(reference);
            } else {
                actionSet = this.track(reference, event);
                if (higher != null) {
                    actionSet.appendActionSet(this.untrack(higher, null));
                    this.hide(higher);
                }
            }
            return actionSet;
        }

        private AbstractCustomizerActionSet unregister(ServiceEvent event, ServiceReference reference, long sid) {
            if (ServiceTracker.this.debug) {
                System.out.println("[ServiceTracker] " + ServiceTracker.this.debugKey + " T" + Thread.currentThread().getId() + " [unregister] " + reference.getProperty("service.ranking"));
            }
            AbstractCustomizerActionSet actionSet = null;
            ServiceReference ht = this.highestTrackedCache(sid);
            if (reference.equals(ht)) {
                ServiceReference hh = this.highestHiddenCache(sid);
                if (hh != null) {
                    this.unhide(hh);
                    actionSet = this.track(hh, null);
                }
                if (actionSet == null) {
                    actionSet = this.untrack(reference, event);
                } else {
                    actionSet.appendActionSet(this.untrack(reference, event));
                }
            } else {
                this.unhide(reference);
            }
            return actionSet;
        }

        @Override
        void modified() {
            super.modified();
            ServiceTracker.this.modified();
        }

        @Override
        Object customizerAdding(Object item, Object related) {
            return ServiceTracker.this.customizer.addingService((ServiceReference)item);
        }

        @Override
        void customizerAdded(Object item, Object related, Object object) {
            ServiceTracker.this.customizer.addedService((ServiceReference)item, object);
        }

        @Override
        void customizerModified(Object item, Object related, Object object) {
            ServiceTracker.this.customizer.modifiedService((ServiceReference)item, object);
        }

        @Override
        void customizerRemoved(Object item, Object related, Object object) {
            ServiceTracker.this.customizer.removedService((ServiceReference)item, object);
        }

        @Override
        AbstractCustomizerActionSet createCustomizerActionSet() {
            return new AbstractCustomizerActionSet(){

                @Override
                public void addCustomizerAdded(Object item, Object related, Object object) {
                    if (ServiceTracker.this.debug) {
                        // empty if block
                    }
                    super.addCustomizerAdded(item, related, object);
                }

                @Override
                public void addCustomizerModified(Object item, Object related, Object object) {
                    if (ServiceTracker.this.debug) {
                        // empty if block
                    }
                    super.addCustomizerModified(item, related, object);
                }

                @Override
                public void addCustomizerRemoved(Object item, Object related, Object object) {
                    if (ServiceTracker.this.debug) {
                        // empty if block
                    }
                    super.addCustomizerRemoved(item, related, object);
                }

                @Override
                void execute() {
                    List<AbstractCustomizerActionSet.CustomizerAction> actions = this.getActions();
                    if (actions.size() > 2) {
                        throw new IllegalStateException("Unexpected action count: " + actions.size());
                    }
                    if (actions.size() == 2 && actions.get(0).getType() == AbstractCustomizerActionSet.Type.ADDED && actions.get(1).getType() == AbstractCustomizerActionSet.Type.REMOVED) {
                        ServiceTracker.this.debug("swapped");
                        if (ServiceTracker.this.debug) {
                            System.out.println("[ServiceTracker] " + ServiceTracker.this.debugKey + " T" + Thread.currentThread().getId() + " swapping " + actions.get(1).getObject() + " with " + actions.get(0).getObject());
                        }
                        ServiceTracker.this.customizer.swappedService((ServiceReference)actions.get(1).getItem(), actions.get(1).getObject(), (ServiceReference)actions.get(0).getItem(), actions.get(0).getObject());
                    } else {
                        for (AbstractCustomizerActionSet.CustomizerAction action : this.getActions()) {
                            try {
                                switch (action.getType()) {
                                    case ADDED: {
                                        ServiceTracker.this.debug(Thread.currentThread().getId() + " added");
                                        if (ServiceTracker.this.debug) {
                                            System.out.println("[ServiceTracker] " + ServiceTracker.this.debugKey + " T" + Thread.currentThread().getId() + " adding " + action.getObject());
                                        }
                                        Tracked.this.customizerAdded(action.getItem(), action.getRelated(), action.getObject());
                                        break;
                                    }
                                    case MODIFIED: {
                                        ServiceTracker.this.debug("modified");
                                        Tracked.this.customizerModified(action.getItem(), action.getRelated(), action.getObject());
                                        break;
                                    }
                                    case REMOVED: {
                                        ServiceTracker.this.debug("removed");
                                        if (ServiceTracker.this.debug) {
                                            System.out.println("[ServiceTracker] " + ServiceTracker.this.debugKey + " T" + Thread.currentThread().getId() + " removing " + action.getObject());
                                        }
                                        Tracked.this.customizerRemoved(action.getItem(), action.getRelated(), action.getObject());
                                    }
                                }
                            }
                            catch (Exception e) {}
                        }
                    }
                }
            };
        }

        class HashMapCache<K, V>
        extends LinkedHashMap<K, V> {
            private static final long serialVersionUID = 1627005136730183946L;

            HashMapCache() {
            }

            @Override
            public V put(K key, V value) {
                Tracked.this.addHighestTrackedCache((ServiceReference)key);
                return super.put(key, value);
            }

            @Override
            public void putAll(Map<? extends K, ? extends V> m) {
                Iterator<K> i = m.keySet().iterator();
                while (i.hasNext()) {
                    Tracked.this.addHighestTrackedCache((ServiceReference)i.next());
                }
                super.putAll(m);
            }

            @Override
            public V remove(Object key) {
                Tracked.this.removeHighestTrackedCache((ServiceReference)key);
                return super.remove(key);
            }

            @Override
            public void clear() {
                Tracked.this.clearHighestTrackedCache();
                super.clear();
            }
        }
    }
}

