/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.dm.impl.metatype;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.felix.dm.PropertyMetaData;

public class PropertyMetaDataImpl
implements PropertyMetaData {
    List<String> m_optionsLabels = new ArrayList<String>();
    List<String> m_optionsValues = new ArrayList<String>();
    private int m_cardinality;
    private String[] m_defaults;
    private String m_description;
    private String m_heading;
    private String m_id;
    private boolean m_required;
    private int m_type = 1;
    private static final Map<Class<?>, Integer> m_typeMapping = new HashMap(){
        {
            this.put(Boolean.class, new Integer(11));
            this.put(Byte.class, new Integer(6));
            this.put(Character.class, new Integer(5));
            this.put(Double.class, new Integer(8));
            this.put(Integer.class, new Integer(3));
            this.put(Long.class, new Integer(2));
            this.put(Short.class, new Integer(4));
            this.put(String.class, new Integer(1));
        }
    };

    @Override
    public PropertyMetaData addOption(String optionLabel, String optionValue) {
        this.m_optionsLabels.add(optionLabel);
        this.m_optionsValues.add(optionValue);
        return this;
    }

    @Override
    public PropertyMetaData setCardinality(int cardinality) {
        this.m_cardinality = cardinality;
        return this;
    }

    @Override
    public PropertyMetaData setDefaults(String[] defaults) {
        this.m_defaults = defaults;
        return this;
    }

    @Override
    public PropertyMetaData setDescription(String description) {
        this.m_description = description;
        return this;
    }

    @Override
    public PropertyMetaData setHeading(String heading) {
        this.m_heading = heading;
        return this;
    }

    @Override
    public PropertyMetaData setId(String id) {
        this.m_id = id;
        return this;
    }

    @Override
    public PropertyMetaData setRequired(boolean required) {
        this.m_required = required;
        return this;
    }

    @Override
    public PropertyMetaData setType(Class<?> classType) {
        Integer type = m_typeMapping.get(classType);
        if (type == null) {
            throw new IllegalArgumentException("Invalid type: " + classType + ". Valid types are " + m_typeMapping.keySet());
        }
        this.m_type = type;
        return this;
    }

    public String[] getOptionLabels() {
        String[] optionLabels = new String[this.m_optionsLabels.size()];
        return this.m_optionsLabels.toArray(optionLabels);
    }

    public String[] getOptionValues() {
        String[] optionValues = new String[this.m_optionsValues.size()];
        return this.m_optionsValues.toArray(optionValues);
    }

    public int getCardinality() {
        return this.m_cardinality;
    }

    public String[] getDefaults() {
        return this.m_defaults;
    }

    public String getDescription() {
        return this.m_description;
    }

    public String getHeading() {
        return this.m_heading;
    }

    public String getId() {
        return this.m_id;
    }

    public boolean isRequired() {
        return this.m_required;
    }

    public int getType() {
        return this.m_type;
    }

    public String toString() {
        int i;
        StringBuffer sb = new StringBuffer();
        sb.append("cardinality=").append(this.m_cardinality);
        sb.append("; defaults=");
        for (i = 0; i < this.m_defaults.length; ++i) {
            sb.append(this.m_defaults[i]).append(" ");
        }
        sb.append("; description=").append(this.m_description);
        sb.append("; heading=").append(this.m_heading);
        sb.append("; id=").append(this.m_id);
        sb.append("; required=").append(this.m_required);
        sb.append("; type=").append(this.getType());
        sb.append("; optionLabels=");
        for (i = 0; i < this.m_optionsLabels.size(); ++i) {
            sb.append(this.m_optionsLabels.get(i)).append(" ");
        }
        sb.append("; optionValues=");
        for (i = 0; i < this.m_optionsValues.size(); ++i) {
            sb.append(this.m_optionsValues.get(i)).append(" ");
        }
        return sb.toString();
    }
}

