/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.dm.impl;

import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import org.apache.felix.dm.Component;
import org.apache.felix.dm.ComponentStateListener;
import org.apache.felix.dm.DependencyManager;
import org.apache.felix.dm.ServiceDependency;
import org.apache.felix.dm.context.DependencyContext;
import org.apache.felix.dm.impl.AbstractDecorator;
import org.apache.felix.dm.impl.FilterComponent;
import org.osgi.framework.ServiceReference;

public class AdapterServiceImpl
extends FilterComponent {
    public AdapterServiceImpl(DependencyManager dm, Class<?> adapteeInterface, String adapteeFilter, String autoConfig, Object callbackInstance, String add, String change, String remove, String swap, boolean propagate) {
        super(dm.createComponent());
        this.m_component.setImplementation(new AdapterImpl(adapteeInterface, adapteeFilter, autoConfig, callbackInstance, add, change, remove, swap, propagate)).add(dm.createServiceDependency().setService(adapteeInterface, adapteeFilter).setAutoConfig(false).setCallbacks("added", null, "removed", "swapped")).setCallbacks("init", null, "stop", null);
    }

    public class AdapterImpl
    extends AbstractDecorator {
        private final Class<?> m_adapteeInterface;
        private final String m_adapteeFilter;
        private final Object m_dependencyCallbackInstance;
        private final String m_add;
        private final String m_change;
        private final String m_remove;
        private final String m_swap;
        private final String m_autoConfig;
        private final boolean m_propagate;

        public AdapterImpl(Class<?> adapteeInterface, String adapteeFilter, String autoConfig, Object callbackInstance, String add, String change, String remove, String swap, boolean propagate) {
            this.m_adapteeInterface = adapteeInterface;
            this.m_adapteeFilter = adapteeFilter;
            this.m_autoConfig = autoConfig;
            this.m_dependencyCallbackInstance = callbackInstance;
            this.m_add = add;
            this.m_change = change;
            this.m_swap = swap;
            this.m_remove = remove;
            this.m_propagate = propagate;
        }

        @Override
        public Component createService(Object[] properties) {
            ServiceReference ref = (ServiceReference)properties[0];
            Object aspect = ref.getProperty("org.apache.felix.dependencymanager.aspect");
            String serviceIdToTrack = aspect != null ? aspect.toString() : ref.getProperty("service.id").toString();
            List<DependencyContext> dependencies = AdapterServiceImpl.this.m_component.getDependencies();
            dependencies.remove(0);
            ServiceDependency dependency = this.m_manager.createServiceDependency().setService(this.m_adapteeInterface, "(|(service.id=" + serviceIdToTrack + ")(" + "org.apache.felix.dependencymanager.aspect" + "=" + serviceIdToTrack + "))").setRequired(true);
            if (this.m_add != null || this.m_change != null || this.m_remove != null || this.m_swap != null) {
                dependency.setCallbacks(this.m_dependencyCallbackInstance, this.m_add, this.m_change, this.m_remove, this.m_swap);
            }
            if (this.m_autoConfig != null) {
                dependency.setAutoConfig(this.m_autoConfig);
            } else {
                dependency.setAutoConfig(this.m_add == null || this.m_add != null && this.m_dependencyCallbackInstance != null);
            }
            if (this.m_propagate) {
                dependency.setPropagate(this, "propagateAdapteeProperties");
            }
            Component service = this.m_manager.createComponent().setInterface(AdapterServiceImpl.this.m_serviceInterfaces, this.getServiceProperties(ref)).setImplementation(AdapterServiceImpl.this.m_serviceImpl).setFactory(AdapterServiceImpl.this.m_factory, AdapterServiceImpl.this.m_factoryCreateMethod).setComposition(AdapterServiceImpl.this.m_compositionInstance, AdapterServiceImpl.this.m_compositionMethod).setCallbacks(AdapterServiceImpl.this.m_callbackObject, AdapterServiceImpl.this.m_init, AdapterServiceImpl.this.m_start, AdapterServiceImpl.this.m_stop, AdapterServiceImpl.this.m_destroy).add(dependency);
            this.configureAutoConfigState(service, AdapterServiceImpl.this.m_component);
            for (DependencyContext dc : dependencies) {
                service.add(dc.createCopy());
            }
            for (ComponentStateListener stateListener : AdapterServiceImpl.this.m_stateListeners) {
                service.add(stateListener);
            }
            return service;
        }

        public String toString() {
            return "Adapter for " + this.m_adapteeInterface + (this.m_adapteeFilter != null ? " with filter " + this.m_adapteeFilter : "");
        }

        public Dictionary<String, Object> getServiceProperties(ServiceReference ref) {
            Hashtable<String, Object> props = new Hashtable<String, Object>();
            if (AdapterServiceImpl.this.m_serviceProperties != null) {
                Enumeration e = AdapterServiceImpl.this.m_serviceProperties.keys();
                while (e.hasMoreElements()) {
                    String key = (String)e.nextElement();
                    ((Dictionary)props).put(key, AdapterServiceImpl.this.m_serviceProperties.get(key));
                }
            }
            return props;
        }

        public Dictionary<String, Object> propagateAdapteeProperties(ServiceReference ref) {
            Hashtable<String, Object> props = new Hashtable<String, Object>();
            String[] keys = ref.getPropertyKeys();
            for (int i = 0; i < keys.length; ++i) {
                String key = keys[i];
                if (key.equals("org.apache.felix.dependencymanager.aspect") || key.equals("service.id") || key.equals("service.ranking") || key.equals("objectClass")) continue;
                ((Dictionary)props).put(key, ref.getProperty(key));
            }
            return props;
        }
    }
}

