/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.dm;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.felix.dm.BundleDependency;
import org.apache.felix.dm.Component;
import org.apache.felix.dm.ConfigurationDependency;
import org.apache.felix.dm.PropertyMetaData;
import org.apache.felix.dm.ResourceDependency;
import org.apache.felix.dm.ServiceDependency;
import org.apache.felix.dm.TemporalServiceDependency;
import org.apache.felix.dm.impl.AdapterServiceImpl;
import org.apache.felix.dm.impl.AspectServiceImpl;
import org.apache.felix.dm.impl.BundleAdapterServiceImpl;
import org.apache.felix.dm.impl.ComponentImpl;
import org.apache.felix.dm.impl.FactoryConfigurationAdapterServiceImpl;
import org.apache.felix.dm.impl.Logger;
import org.apache.felix.dm.impl.ResourceAdapterServiceImpl;
import org.apache.felix.dm.impl.dependencies.BundleDependencyImpl;
import org.apache.felix.dm.impl.dependencies.ConfigurationDependencyImpl;
import org.apache.felix.dm.impl.dependencies.ResourceDependencyImpl;
import org.apache.felix.dm.impl.dependencies.ServiceDependencyImpl;
import org.apache.felix.dm.impl.dependencies.TemporalServiceDependencyImpl;
import org.apache.felix.dm.impl.index.AdapterFilterIndex;
import org.apache.felix.dm.impl.index.AspectFilterIndex;
import org.apache.felix.dm.impl.index.MultiPropertyExactFilter;
import org.apache.felix.dm.impl.index.ServiceRegistryCache;
import org.apache.felix.dm.impl.metatype.PropertyMetaDataImpl;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.FrameworkUtil;

public class DependencyManager {
    public static final String ASPECT = "org.apache.felix.dependencymanager.aspect";
    public static final String SERVICEREGISTRY_CACHE_INDICES = "org.apache.felix.dependencymanager.filterindex";
    public static final String METHOD_CACHE_SIZE = "org.apache.felix.dependencymanager.methodcache";
    private final BundleContext m_context;
    private final Logger m_logger;
    private List m_components = Collections.synchronizedList(new ArrayList());
    private static ServiceRegistryCache m_serviceRegistryCache;
    private static final Set m_dependencyManagers;
    static /* synthetic */ Class class$org$apache$felix$dm$DependencyManager;

    public DependencyManager(BundleContext context) {
        this(context, new Logger(context));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DependencyManager(BundleContext context, Logger logger) {
        this.m_context = this.createContext(context);
        this.m_logger = logger;
        Set set = m_dependencyManagers;
        synchronized (set) {
            m_dependencyManagers.add(new WeakReference<DependencyManager>(this));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List getDependencyManagers() {
        ArrayList<DependencyManager> result = new ArrayList<DependencyManager>();
        Set set = m_dependencyManagers;
        synchronized (set) {
            Iterator iterator = m_dependencyManagers.iterator();
            while (iterator.hasNext()) {
                WeakReference reference = (WeakReference)iterator.next();
                DependencyManager manager = (DependencyManager)reference.get();
                if (manager != null) {
                    try {
                        manager.getBundleContext().getBundle();
                        result.add(manager);
                        continue;
                    }
                    catch (IllegalStateException e) {
                        // empty catch block
                    }
                }
                iterator.remove();
            }
        }
        return result;
    }

    private BundleContext createContext(BundleContext context) {
        if (m_serviceRegistryCache != null) {
            return m_serviceRegistryCache.createBundleContextInterceptor(context);
        }
        return context;
    }

    public BundleContext getBundleContext() {
        return this.m_context;
    }

    public void add(Component service) {
        this.m_components.add(service);
        service.start();
    }

    public void remove(Component service) {
        service.stop();
        this.m_components.remove(service);
    }

    public Component createComponent() {
        return new ComponentImpl(this.m_context, this, this.m_logger);
    }

    public ServiceDependency createServiceDependency() {
        return new ServiceDependencyImpl(this.m_context, this.m_logger);
    }

    public TemporalServiceDependency createTemporalServiceDependency() {
        return new TemporalServiceDependencyImpl(this.m_context, this.m_logger);
    }

    public ConfigurationDependency createConfigurationDependency() {
        return new ConfigurationDependencyImpl(this.m_context, this.m_logger);
    }

    public PropertyMetaData createPropertyMetaData() {
        return new PropertyMetaDataImpl();
    }

    public BundleDependency createBundleDependency() {
        return new BundleDependencyImpl(this.m_context, this.m_logger);
    }

    public ResourceDependency createResourceDependency() {
        return new ResourceDependencyImpl(this.m_context, this.m_logger);
    }

    public Component createAspectService(Class serviceInterface, String serviceFilter, int ranking, String autoConfig) {
        return new AspectServiceImpl(this, serviceInterface, serviceFilter, ranking, autoConfig, null, null, null, null);
    }

    public Component createAspectService(Class serviceInterface, String serviceFilter, int ranking) {
        return new AspectServiceImpl(this, serviceInterface, serviceFilter, ranking, null, null, null, null, null);
    }

    public Component createAspectService(Class serviceInterface, String serviceFilter, int ranking, String add, String change, String remove) {
        return new AspectServiceImpl(this, serviceInterface, serviceFilter, ranking, null, add, change, remove, null);
    }

    public Component createAspectService(Class serviceInterface, String serviceFilter, int ranking, String add, String change, String remove, String swap) {
        return new AspectServiceImpl(this, serviceInterface, serviceFilter, ranking, null, add, change, remove, swap);
    }

    public Component createAdapterService(Class serviceInterface, String serviceFilter) {
        return new AdapterServiceImpl(this, serviceInterface, serviceFilter, null, null, null, null);
    }

    public Component createAdapterService(Class serviceInterface, String serviceFilter, String autoConfig) {
        return new AdapterServiceImpl(this, serviceInterface, serviceFilter, autoConfig, null, null, null);
    }

    public Component createAdapterService(Class serviceInterface, String serviceFilter, String add, String change, String remove, String swap) {
        return new AdapterServiceImpl(this, serviceInterface, serviceFilter, null, add, change, remove, swap);
    }

    public Component createAdapterService(Class serviceInterface, String serviceFilter, String add, String change, String remove) {
        return new AdapterServiceImpl(this, serviceInterface, serviceFilter, null, add, change, remove);
    }

    public Component createResourceAdapterService(String resourceFilter, boolean propagate, Object callbackInstance, String callbackChanged) {
        return new ResourceAdapterServiceImpl(this, resourceFilter, propagate, callbackInstance, null, callbackChanged);
    }

    public Component createResourceAdapterService(String resourceFilter, boolean propagate, Object callbackInstance, String callbackSet, String callbackChanged) {
        return new ResourceAdapterServiceImpl(this, resourceFilter, propagate, callbackInstance, callbackSet, callbackChanged);
    }

    public Component createResourceAdapterService(String resourceFilter, Object propagateCallbackInstance, String propagateCallbackMethod, Object callbackInstance, String callbackChanged) {
        return new ResourceAdapterServiceImpl(this, resourceFilter, propagateCallbackInstance, propagateCallbackMethod, callbackInstance, null, callbackChanged);
    }

    public Component createResourceAdapterService(String resourceFilter, Object propagateCallbackInstance, String propagateCallbackMethod, Object callbackInstance, String callbackSet, String callbackChanged) {
        return new ResourceAdapterServiceImpl(this, resourceFilter, propagateCallbackInstance, propagateCallbackMethod, callbackInstance, callbackSet, callbackChanged);
    }

    public Component createBundleAdapterService(int bundleStateMask, String bundleFilter, boolean propagate) {
        return new BundleAdapterServiceImpl(this, bundleStateMask, bundleFilter, propagate);
    }

    public Component createFactoryConfigurationAdapterService(String factoryPid, String update, boolean propagate) {
        return new FactoryConfigurationAdapterServiceImpl(this, factoryPid, update, propagate);
    }

    public Component createFactoryConfigurationAdapterService(String factoryPid, String update, boolean propagate, String heading, String desc, String localization, PropertyMetaData[] propertiesMetaData) {
        return new FactoryConfigurationAdapterServiceImpl(this, factoryPid, update, propagate, this.m_context, this.m_logger, heading, desc, localization, propertiesMetaData);
    }

    public List getComponents() {
        return Collections.unmodifiableList(this.m_components);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Component[] components;
        List list = this.m_components;
        synchronized (list) {
            components = this.m_components.toArray(new Component[this.m_components.size()]);
        }
        for (int i = components.length - 1; i >= 0; --i) {
            Component component = components[i];
            this.remove(component);
            if (!(component instanceof ComponentImpl)) continue;
            ComponentImpl si = (ComponentImpl)component;
            si.removeStateListeners();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        m_dependencyManagers = new HashSet();
        String index = System.getProperty(SERVICEREGISTRY_CACHE_INDICES);
        if (index != null) {
            Bundle bundle = FrameworkUtil.getBundle((Class)(class$org$apache$felix$dm$DependencyManager == null ? (class$org$apache$felix$dm$DependencyManager = DependencyManager.class$("org.apache.felix.dm.DependencyManager")) : class$org$apache$felix$dm$DependencyManager));
            try {
                if (bundle.getState() != 32) {
                    bundle.start();
                }
                BundleContext bundleContext = bundle.getBundleContext();
                m_serviceRegistryCache = new ServiceRegistryCache(bundleContext);
                m_serviceRegistryCache.open();
                String[] props = index.split(";");
                for (int i = 0; i < props.length; ++i) {
                    if (props[i].equals("*aspect*")) {
                        m_serviceRegistryCache.addFilterIndex(new AspectFilterIndex());
                        continue;
                    }
                    if (props[i].equals("*adapter*")) {
                        m_serviceRegistryCache.addFilterIndex(new AdapterFilterIndex());
                        continue;
                    }
                    String[] propList = props[i].split(",");
                    m_serviceRegistryCache.addFilterIndex(new MultiPropertyExactFilter(propList));
                }
            }
            catch (BundleException bundleException) {
                // empty catch block
            }
        }
    }
}

