/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.dependencymanager;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.felix.dependencymanager.DefaultNullObject;
import org.apache.felix.dependencymanager.Dependency;
import org.apache.felix.dependencymanager.Logger;
import org.apache.felix.dependencymanager.Service;
import org.apache.felix.dependencymanager.ServiceComponentDependency;
import org.apache.felix.dependencymanager.ServiceImpl;
import org.apache.felix.dependencymanager.ServiceTracker;
import org.apache.felix.dependencymanager.ServiceTrackerCustomizer;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;

public class ServiceDependency
implements Dependency,
ServiceTrackerCustomizer,
ServiceComponentDependency {
    private boolean m_isRequired;
    private Service m_service;
    private volatile ServiceTracker m_tracker;
    private BundleContext m_context;
    private boolean m_isAvailable;
    private volatile Class m_trackedServiceName;
    private Object m_nullObject;
    private volatile String m_trackedServiceFilter;
    private volatile ServiceReference m_trackedServiceReference;
    private volatile boolean m_isStarted;
    private Object m_callbackInstance;
    private String m_callbackAdded;
    private String m_callbackChanged;
    private String m_callbackRemoved;
    private boolean m_autoConfig;
    private ServiceReference m_reference;
    private Object m_serviceInstance;
    private final Logger m_logger;
    private String m_autoConfigInstance;
    private Object m_defaultImplementation;
    private Object m_defaultImplementationInstance;
    private static final Comparator COMPARATOR = new Comparator(){

        public int getRank(ServiceReference ref) {
            Object ranking = ref.getProperty("service.ranking");
            if (ranking != null && ranking instanceof Integer) {
                return (Integer)ranking;
            }
            return 0;
        }

        public int compare(Object a, Object b) {
            int rankb;
            ServiceReference ra = (ServiceReference)a;
            ServiceReference rb = (ServiceReference)b;
            int ranka = this.getRank(ra);
            if (ranka < (rankb = this.getRank(rb))) {
                return -1;
            }
            if (ranka > rankb) {
                return 1;
            }
            return 0;
        }
    };
    static /* synthetic */ Class class$org$osgi$framework$ServiceReference;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$java$util$Map;

    public ServiceDependency(BundleContext context, Logger logger) {
        this.m_context = context;
        this.m_logger = logger;
        this.m_autoConfig = true;
    }

    public synchronized boolean isRequired() {
        return this.m_isRequired;
    }

    public synchronized boolean isAvailable() {
        return this.m_isAvailable;
    }

    public synchronized boolean isAutoConfig() {
        return this.m_autoConfig;
    }

    public synchronized Object getService() {
        Object service = null;
        if (this.m_isStarted) {
            service = this.m_tracker.getService();
        }
        if (service == null && (service = this.getDefaultImplementation()) == null) {
            service = this.getNullObject();
        }
        return service;
    }

    /*
     * Unable to fully structure code
     */
    public Object lookupService() {
        service = null;
        if (this.m_isStarted) {
            service = this.m_tracker.getService();
        } else {
            refs = null;
            ref = null;
            if (this.m_trackedServiceName != null) {
                if (this.m_trackedServiceFilter != null) {
                    try {
                        refs = this.m_context.getServiceReferences(this.m_trackedServiceName.getName(), this.m_trackedServiceFilter);
                        if (refs == null) ** GOTO lbl18
                        Arrays.sort(refs, ServiceDependency.COMPARATOR);
                        ref = refs[0];
                    }
                    catch (InvalidSyntaxException e) {
                        throw new IllegalStateException("Invalid filter definition for dependency.");
                    }
                } else {
                    ref = this.m_trackedServiceReference != null ? this.m_trackedServiceReference : this.m_context.getServiceReference(this.m_trackedServiceName.getName());
                }
lbl18:
                // 3 sources

                if (ref != null) {
                    service = this.m_context.getService(ref);
                }
            } else {
                throw new IllegalStateException("Could not lookup dependency, no service name specified.");
            }
        }
        if (service == null && (service = this.getDefaultImplementation()) == null) {
            service = this.getNullObject();
        }
        return service;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getNullObject() {
        if (this.m_nullObject == null) {
            Class trackedServiceName;
            ServiceDependency serviceDependency = this;
            synchronized (serviceDependency) {
                trackedServiceName = this.m_trackedServiceName;
            }
            try {
                this.m_nullObject = Proxy.newProxyInstance(trackedServiceName.getClassLoader(), new Class[]{trackedServiceName}, (InvocationHandler)new DefaultNullObject());
            }
            catch (Exception e) {
                this.m_logger.log(1, "Could not create null object for " + trackedServiceName + ".", e);
            }
        }
        return this.m_nullObject;
    }

    private Object getDefaultImplementation() {
        if (this.m_defaultImplementation != null) {
            if (this.m_defaultImplementation instanceof Class) {
                try {
                    this.m_defaultImplementationInstance = ((Class)this.m_defaultImplementation).newInstance();
                }
                catch (Exception e) {
                    this.m_logger.log(1, "Could not create default implementation instance of class " + this.m_defaultImplementation + ".", e);
                }
            } else {
                this.m_defaultImplementationInstance = this.m_defaultImplementation;
            }
        }
        return this.m_defaultImplementationInstance;
    }

    public synchronized Class getInterface() {
        return this.m_trackedServiceName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(Service service) {
        ServiceDependency serviceDependency = this;
        synchronized (serviceDependency) {
            if (this.m_isStarted) {
                throw new IllegalStateException("Service dependency was already started." + this.m_trackedServiceName);
            }
            this.m_service = service;
            if (this.m_trackedServiceName != null) {
                if (this.m_trackedServiceFilter != null) {
                    try {
                        this.m_tracker = new ServiceTracker(this.m_context, this.m_context.createFilter(this.m_trackedServiceFilter), (ServiceTrackerCustomizer)this);
                    }
                    catch (InvalidSyntaxException e) {
                        throw new IllegalStateException("Invalid filter definition for dependency.");
                    }
                } else {
                    this.m_tracker = this.m_trackedServiceReference != null ? new ServiceTracker(this.m_context, this.m_trackedServiceReference, (ServiceTrackerCustomizer)this) : new ServiceTracker(this.m_context, this.m_trackedServiceName.getName(), (ServiceTrackerCustomizer)this);
                }
            } else {
                throw new IllegalStateException("Could not create tracker for dependency, no service name specified.");
            }
            this.m_isStarted = true;
        }
        this.m_tracker.open();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(Service service) {
        ServiceDependency serviceDependency = this;
        synchronized (serviceDependency) {
            if (!this.m_isStarted) {
                throw new IllegalStateException("Service dependency was not started.");
            }
            this.m_isStarted = false;
        }
        this.m_tracker.close();
        this.m_tracker = null;
    }

    public Object addingService(ServiceReference ref) {
        Object service = this.m_context.getService(ref);
        if (!this.m_trackedServiceName.isInstance(service)) {
            return null;
        }
        this.m_reference = ref;
        this.m_serviceInstance = service;
        return service;
    }

    public void addedService(ServiceReference ref, Object service) {
        if (this.makeAvailable()) {
            this.m_service.dependencyAvailable(this);
        } else {
            this.m_service.dependencyChanged(this);
        }
        if (!this.isRequired()) {
            this.invokeAdded(ref, service);
        }
    }

    public void invokeAdded() {
        this.invokeAdded(this.m_reference, this.m_serviceInstance);
    }

    public void invokeAdded(ServiceReference reference, Object serviceInstance) {
        Object callbackInstance = this.getCallbackInstance();
        if (callbackInstance != null && this.m_callbackAdded != null) {
            try {
                this.invokeCallbackMethod(callbackInstance, this.m_callbackAdded, reference, serviceInstance);
            }
            catch (NoSuchMethodException e) {
                this.m_logger.log(1, "Could not invoke method " + this.m_callbackAdded + " on " + callbackInstance + ".", e);
            }
        }
    }

    public void modifiedService(ServiceReference ref, Object service) {
        this.m_reference = ref;
        this.m_serviceInstance = service;
        this.m_service.dependencyChanged(this);
        if (((ServiceImpl)this.m_service).isRegistered()) {
            this.invokeChanged(ref, service);
        }
    }

    public void invokeChanged(ServiceReference reference, Object serviceInstance) {
        Object callbackInstance = this.getCallbackInstance();
        if (callbackInstance != null && this.m_callbackChanged != null) {
            try {
                if (this.m_reference == null) {
                    Thread.dumpStack();
                }
                this.invokeCallbackMethod(callbackInstance, this.m_callbackChanged, reference, serviceInstance);
            }
            catch (NoSuchMethodException e) {
                this.m_logger.log(1, "Could not invoke method " + this.m_callbackChanged + " on " + callbackInstance + ".", e);
            }
        }
    }

    public void removedService(ServiceReference ref, Object service) {
        if (this.makeUnavailable()) {
            this.m_service.dependencyUnavailable(this);
        }
        if (!this.isRequired()) {
            this.invokeRemoved(ref, service);
        }
        this.m_context.ungetService(ref);
    }

    public void invokeRemoved() {
        this.invokeRemoved(this.m_reference, this.m_serviceInstance);
    }

    public void invokeRemoved(ServiceReference reference, Object serviceInstance) {
        Object callbackInstance = this.getCallbackInstance();
        if (callbackInstance != null && this.m_callbackRemoved != null) {
            try {
                if (this.m_reference == null) {
                    Thread.dumpStack();
                }
                this.invokeCallbackMethod(callbackInstance, this.m_callbackRemoved, reference, serviceInstance);
            }
            catch (NoSuchMethodException e) {
                this.m_logger.log(1, "Could not invoke method " + this.m_callbackRemoved + " on " + callbackInstance + ".", e);
            }
        }
    }

    private synchronized boolean makeAvailable() {
        if (!this.m_isAvailable) {
            this.m_isAvailable = true;
            return true;
        }
        return false;
    }

    private synchronized boolean makeUnavailable() {
        if (this.m_isAvailable && this.m_tracker.getServiceReference() == null) {
            this.m_isAvailable = false;
            return true;
        }
        return false;
    }

    private synchronized Object getCallbackInstance() {
        Object callbackInstance = this.m_callbackInstance;
        if (callbackInstance == null) {
            callbackInstance = this.m_service.getService();
        }
        return callbackInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invokeCallbackMethod(Object instance, String methodName, ServiceReference reference, Object service) throws NoSuchMethodException {
        Class<?> currentClazz = instance.getClass();
        boolean done = false;
        while (!done && currentClazz != null) {
            Class trackedServiceName;
            ServiceDependency serviceDependency = this;
            synchronized (serviceDependency) {
                trackedServiceName = this.m_trackedServiceName;
            }
            done = this.invokeMethod(instance, currentClazz, methodName, new Class[][]{{class$org$osgi$framework$ServiceReference == null ? ServiceDependency.class$("org.osgi.framework.ServiceReference") : class$org$osgi$framework$ServiceReference, trackedServiceName}, {class$org$osgi$framework$ServiceReference == null ? ServiceDependency.class$("org.osgi.framework.ServiceReference") : class$org$osgi$framework$ServiceReference, class$java$lang$Object == null ? ServiceDependency.class$("java.lang.Object") : class$java$lang$Object}, {class$org$osgi$framework$ServiceReference == null ? ServiceDependency.class$("org.osgi.framework.ServiceReference") : class$org$osgi$framework$ServiceReference}, {trackedServiceName}, {class$java$lang$Object == null ? ServiceDependency.class$("java.lang.Object") : class$java$lang$Object}, new Class[0], {class$java$util$Map == null ? ServiceDependency.class$("java.util.Map") : class$java$util$Map, trackedServiceName}}, new Object[][]{{reference, service}, {reference, service}, {reference}, {service}, {service}, new Object[0], {new ServicePropertiesMap(reference), service}}, false);
            if (done) continue;
            currentClazz = currentClazz.getSuperclass();
        }
        if (!done && currentClazz == null) {
            throw new NoSuchMethodException(methodName);
        }
    }

    private boolean invokeMethod(Object object, Class clazz, String name, Class[][] signatures, Object[][] parameters, boolean isSuper) {
        Method m = null;
        for (int i = 0; i < signatures.length; ++i) {
            Class[] signature = signatures[i];
            try {
                m = clazz.getDeclaredMethod(name, signature);
                if (isSuper && Modifier.isPrivate(m.getModifiers())) continue;
                m.setAccessible(true);
                try {
                    m.invoke(object, parameters[i]);
                }
                catch (InvocationTargetException e) {
                    this.m_logger.log(1, "Exception while invoking method " + m + ".", e);
                }
                return true;
            }
            catch (NoSuchMethodException e) {
                continue;
            }
            catch (Exception e) {
                this.m_logger.log(1, "Exception while trying to invoke method " + m + ".", e);
            }
        }
        return false;
    }

    public synchronized ServiceDependency setService(Class serviceName) {
        this.ensureNotActive();
        if (serviceName == null) {
            throw new IllegalArgumentException("Service name cannot be null.");
        }
        this.m_trackedServiceName = serviceName;
        this.m_trackedServiceReference = null;
        this.m_trackedServiceFilter = null;
        return this;
    }

    public synchronized ServiceDependency setService(Class serviceName, String serviceFilter) {
        this.ensureNotActive();
        if (serviceName == null) {
            throw new IllegalArgumentException("Service name cannot be null.");
        }
        this.m_trackedServiceName = serviceName;
        this.m_trackedServiceFilter = serviceFilter;
        this.m_trackedServiceReference = null;
        return this;
    }

    public synchronized ServiceDependency setService(Class serviceName, ServiceReference serviceReference) {
        this.ensureNotActive();
        if (serviceName == null) {
            throw new IllegalArgumentException("Service name cannot be null.");
        }
        this.m_trackedServiceName = serviceName;
        this.m_trackedServiceReference = serviceReference;
        this.m_trackedServiceFilter = null;
        return this;
    }

    public synchronized ServiceDependency setDefaultImplementation(Object implementation) {
        this.ensureNotActive();
        this.m_defaultImplementation = implementation;
        return this;
    }

    public synchronized ServiceDependency setRequired(boolean required) {
        this.ensureNotActive();
        this.m_isRequired = required;
        return this;
    }

    public synchronized ServiceDependency setAutoConfig(boolean autoConfig) {
        this.ensureNotActive();
        this.m_autoConfig = autoConfig;
        return this;
    }

    public synchronized ServiceDependency setAutoConfig(String instanceName) {
        this.ensureNotActive();
        this.m_autoConfig = instanceName != null;
        this.m_autoConfigInstance = instanceName;
        return this;
    }

    public synchronized ServiceDependency setCallbacks(String added, String removed) {
        return this.setCallbacks(null, added, null, removed);
    }

    public synchronized ServiceDependency setCallbacks(String added, String changed, String removed) {
        return this.setCallbacks(null, added, changed, removed);
    }

    public synchronized ServiceDependency setCallbacks(Object instance, String added, String removed) {
        return this.setCallbacks(instance, added, null, removed);
    }

    public synchronized ServiceDependency setCallbacks(Object instance, String added, String changed, String removed) {
        this.ensureNotActive();
        this.m_callbackInstance = instance;
        this.m_callbackAdded = added;
        this.m_callbackChanged = changed;
        this.m_callbackRemoved = removed;
        return this;
    }

    private void ensureNotActive() {
        if (this.m_tracker != null) {
            throw new IllegalStateException("Cannot modify state while active.");
        }
    }

    public synchronized String toString() {
        return "ServiceDependency[" + this.m_trackedServiceName + " " + this.m_trackedServiceFilter + "]";
    }

    public String getAutoConfigName() {
        return this.m_autoConfigInstance;
    }

    public String getName() {
        return this.m_trackedServiceName.getName();
    }

    public int getState() {
        return (this.isAvailable() ? 1 : 0) + (this.isRequired() ? 2 : 0);
    }

    public String getType() {
        return "service";
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static final class ServicePropertiesMap
    extends AbstractMap {
        private final ServiceReference m_ref;

        public ServicePropertiesMap(ServiceReference ref) {
            this.m_ref = ref;
        }

        public Object get(Object key) {
            return this.m_ref.getProperty(key.toString());
        }

        public int size() {
            return this.m_ref.getPropertyKeys().length;
        }

        public Set entrySet() {
            HashSet<ServicePropertiesMapEntry> set = new HashSet<ServicePropertiesMapEntry>();
            String[] keys = this.m_ref.getPropertyKeys();
            for (int i = 0; i < keys.length; ++i) {
                set.add(new ServicePropertiesMapEntry(keys[i], this.m_ref.getProperty(keys[i])));
            }
            return set;
        }
    }

    private static final class ServicePropertiesMapEntry
    implements Map.Entry {
        private final String m_key;
        private Object m_value;

        public ServicePropertiesMapEntry(String key, Object value) {
            this.m_key = key;
            this.m_value = value;
        }

        public Object getKey() {
            return this.m_key;
        }

        public Object getValue() {
            return this.m_value;
        }

        public String toString() {
            return this.m_key + "=" + this.m_value;
        }

        public Object setValue(Object value) {
            Object oldValue = this.m_value;
            this.m_value = value;
            return oldValue;
        }

        public boolean equals(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            return ServicePropertiesMapEntry.eq(this.m_key, e.getKey()) && ServicePropertiesMapEntry.eq(this.m_value, e.getValue());
        }

        public int hashCode() {
            return (this.m_key == null ? 0 : this.m_key.hashCode()) ^ (this.m_value == null ? 0 : this.m_value.hashCode());
        }

        private static final boolean eq(Object o1, Object o2) {
            return o1 == null ? o2 == null : o1.equals(o2);
        }
    }
}

