/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.util.converter;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.osgi.util.converter.CollectionSetDelegate;
import org.osgi.util.converter.ConvertingImpl;

class SetDelegate<T>
implements Set<T> {
    private volatile Set<T> delegate;
    private volatile boolean cloned;
    private final ConvertingImpl convertingImpl;

    static <T> Set<T> forCollection(Collection<T> collection, ConvertingImpl converting) {
        if (collection instanceof Set) {
            return new SetDelegate<T>((Set)collection, converting);
        }
        return new SetDelegate<T>(new CollectionSetDelegate<T>(collection), converting);
    }

    SetDelegate(Set<T> collection, ConvertingImpl converting) {
        this.delegate = collection;
        this.convertingImpl = converting;
    }

    private void cloneDelegate() {
        if (this.cloned) {
            return;
        }
        this.cloned = true;
        this.delegate = new HashSet<T>(this.delegate);
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    @Override
    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.containsAll(Collections.singletonList(o));
    }

    @Override
    public Iterator<T> iterator() {
        return new SetDelegateIterator();
    }

    @Override
    public Object[] toArray() {
        return this.toArray((X[])new Object[this.size()]);
    }

    @Override
    public <X> X[] toArray(X[] a) {
        int mySize = this.size();
        if (Array.getLength(a) < this.size()) {
            a = (Object[])Array.newInstance(a.getClass().getComponentType(), mySize);
        }
        Iterator<T> it = this.iterator();
        for (int i = 0; i < a.length; ++i) {
            a[i] = mySize > i && it.hasNext() ? it.next() : null;
        }
        return a;
    }

    @Override
    public boolean add(T e) {
        this.cloneDelegate();
        return this.delegate.add(e);
    }

    @Override
    public boolean remove(Object o) {
        this.cloneDelegate();
        return this.delegate.remove(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        List<Object> l = Arrays.asList(this.toArray());
        for (Object o : c) {
            if (l.contains(o)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        this.cloneDelegate();
        return this.delegate.addAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        this.cloneDelegate();
        return this.delegate.retainAll(c);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        this.cloneDelegate();
        return this.delegate.removeAll(c);
    }

    @Override
    public int hashCode() {
        return this.delegate.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Set)) {
            return false;
        }
        HashSet s1 = new HashSet(this);
        HashSet s2 = new HashSet((Set)obj);
        return s1.equals(s2);
    }

    public String toString() {
        return this.delegate.toString();
    }

    @Override
    public void clear() {
        this.cloned = true;
        this.delegate = new HashSet<T>();
    }

    private class SetDelegateIterator
    implements Iterator<T> {
        final Iterator<?> delegateIterator;

        SetDelegateIterator() {
            this.delegateIterator = SetDelegate.this.delegate.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.delegateIterator.hasNext();
        }

        @Override
        public T next() {
            Object obj = this.delegateIterator.next();
            return SetDelegate.this.convertingImpl.convertCollectionValue(obj);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove");
        }
    }
}

