/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.cm.impl.persistence;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.felix.cm.PersistenceManager;
import org.apache.felix.cm.impl.CaseInsensitiveDictionary;
import org.apache.felix.cm.impl.SimpleFilter;
import org.apache.felix.cm.impl.persistence.ExtPersistenceManager;

public class PersistenceManagerProxy
implements ExtPersistenceManager {
    private final PersistenceManager pm;
    private final ReadWriteLock globalLock = new ReentrantReadWriteLock();

    public PersistenceManagerProxy(PersistenceManager pm) {
        this.pm = pm;
    }

    @Override
    public PersistenceManager getDelegatee() {
        return this.pm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete(String pid) throws IOException {
        Lock lock = this.globalLock.writeLock();
        try {
            lock.lock();
            this.pm.delete(pid);
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean exists(String pid) {
        Lock lock = this.globalLock.readLock();
        try {
            lock.lock();
            boolean bl = this.pm.exists(pid);
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public Enumeration getDictionaries() throws IOException {
        return Collections.enumeration(this.getDictionaries(null));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<Dictionary> getDictionaries(SimpleFilter filter) throws IOException {
        Lock lock = this.globalLock.readLock();
        try {
            HashSet<String> pids = new HashSet<String>();
            ArrayList<Dictionary> result = new ArrayList<Dictionary>();
            lock.lock();
            Enumeration fromPm = this.pm.getDictionaries();
            while (fromPm.hasMoreElements()) {
                Dictionary next = (Dictionary)fromPm.nextElement();
                String pid = (String)next.get("service.pid");
                if (pid == null || pids.contains(pid) || filter != null && !filter.matches(next)) continue;
                pids.add(pid);
                result.add(new CaseInsensitiveDictionary(next));
            }
            ArrayList<Dictionary> arrayList = result;
            return arrayList;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Dictionary load(String pid) throws IOException {
        Lock lock = this.globalLock.readLock();
        try {
            lock.lock();
            Dictionary loaded = this.pm.load(pid);
            if (loaded != null) {
                CaseInsensitiveDictionary caseInsensitiveDictionary = new CaseInsensitiveDictionary(loaded);
                return caseInsensitiveDictionary;
            }
            Dictionary dictionary = null;
            return dictionary;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void store(String pid, Dictionary properties) throws IOException {
        Lock lock = this.globalLock.writeLock();
        try {
            lock.lock();
            this.pm.store(pid, properties);
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<String> getFactoryConfigurationPids(List<String> targetedFactoryPids) throws IOException {
        HashSet<String> pids = new HashSet<String>();
        Lock lock = this.globalLock.readLock();
        try {
            lock.lock();
            Enumeration fromPm = this.pm.getDictionaries();
            block3: while (fromPm.hasMoreElements()) {
                String factoryPid;
                Dictionary next = (Dictionary)fromPm.nextElement();
                String pid = (String)next.get("service.pid");
                if (pid == null || (factoryPid = (String)next.get("service.factoryPid")) == null) continue;
                for (String targetFactoryPid : targetedFactoryPids) {
                    if (!targetedFactoryPids.equals(factoryPid)) continue;
                    pids.add(pid);
                    continue block3;
                }
            }
        }
        finally {
            lock.unlock();
        }
        return pids;
    }
}

