/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.cm.impl;

import java.util.Dictionary;
import java.util.Hashtable;
import org.apache.felix.cm.PersistenceManager;
import org.apache.felix.cm.file.FilePersistenceManager;
import org.apache.felix.cm.impl.Log;
import org.apache.felix.cm.impl.persistence.PersistenceManagerTracker;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceRegistration;

public class Activator
implements BundleActivator {
    private static final String CM_CONFIG_DIR = "felix.cm.dir";
    private static final String CM_CONFIG_PM = "felix.cm.pm";
    private volatile PersistenceManagerTracker tracker;
    private volatile ServiceRegistration<PersistenceManager> filepmRegistration;

    public void start(BundleContext bundleContext) throws BundleException {
        Log.logger.start(bundleContext);
        PersistenceManager defaultPM = this.registerFilePersistenceManager(bundleContext);
        if (defaultPM == null) {
            throw new BundleException("Unable to register default persistence manager.");
        }
        String configuredPM = bundleContext.getProperty(CM_CONFIG_PM);
        if (configuredPM != null && configuredPM.isEmpty()) {
            configuredPM = null;
        }
        try {
            this.tracker = new PersistenceManagerTracker(bundleContext, defaultPM, configuredPM);
        }
        catch (InvalidSyntaxException iae) {
            Log.logger.log(1, "Cannot create the persistence manager tracker", iae);
            throw new BundleException(iae.getMessage(), (Throwable)iae);
        }
    }

    public void stop(BundleContext bundleContext) {
        Log.logger.stop();
        if (this.tracker != null) {
            this.tracker.stop();
            this.tracker = null;
        }
        this.unregisterFilePersistenceManager();
    }

    private PersistenceManager registerFilePersistenceManager(BundleContext bundleContext) {
        try {
            FilePersistenceManager fpm = new FilePersistenceManager(bundleContext, bundleContext.getProperty(CM_CONFIG_DIR));
            Hashtable<String, Object> props = new Hashtable<String, Object>();
            ((Dictionary)props).put("service.description", "Platform Filesystem Persistence Manager");
            ((Dictionary)props).put("service.vendor", "The Apache Software Foundation");
            ((Dictionary)props).put("service.ranking", new Integer(Integer.MIN_VALUE));
            ((Dictionary)props).put("name", "file");
            this.filepmRegistration = bundleContext.registerService(PersistenceManager.class, (Object)fpm, props);
            return fpm;
        }
        catch (IllegalArgumentException iae) {
            Log.logger.log(1, "Cannot create the FilePersistenceManager", iae);
            return null;
        }
    }

    private void unregisterFilePersistenceManager() {
        if (this.filepmRegistration != null) {
            this.filepmRegistration.unregister();
            this.filepmRegistration = null;
        }
    }
}

