/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri.servlet;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Set;
import javax.servlet.AsyncContext;
import javax.servlet.AsyncEvent;
import javax.servlet.AsyncListener;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ReadListener;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.WriteListener;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.dubbo.common.io.StreamUtils;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.remoting.http12.HttpChannel;
import org.apache.dubbo.remoting.http12.HttpInputMessage;
import org.apache.dubbo.remoting.http12.HttpMetadata;
import org.apache.dubbo.remoting.http12.HttpVersion;
import org.apache.dubbo.remoting.http12.h1.Http1InputMessage;
import org.apache.dubbo.remoting.http12.h1.Http1ServerTransportListener;
import org.apache.dubbo.remoting.http12.h2.H2StreamChannel;
import org.apache.dubbo.remoting.http12.h2.Http2InputMessageFrame;
import org.apache.dubbo.remoting.http12.h2.Http2ServerTransportListenerFactory;
import org.apache.dubbo.remoting.http12.h2.Http2TransportListener;
import org.apache.dubbo.rpc.PathResolver;
import org.apache.dubbo.rpc.TriRpcStatus;
import org.apache.dubbo.rpc.model.FrameworkModel;
import org.apache.dubbo.rpc.protocol.tri.RequestPath;
import org.apache.dubbo.rpc.protocol.tri.ServletExchanger;
import org.apache.dubbo.rpc.protocol.tri.TripleHeaderEnum;
import org.apache.dubbo.rpc.protocol.tri.h12.grpc.GrpcHeaderNames;
import org.apache.dubbo.rpc.protocol.tri.h12.grpc.GrpcHttp2ServerTransportListener;
import org.apache.dubbo.rpc.protocol.tri.h12.grpc.GrpcUtils;
import org.apache.dubbo.rpc.protocol.tri.h12.http1.DefaultHttp11ServerTransportListenerFactory;
import org.apache.dubbo.rpc.protocol.tri.h12.http2.GenericHttp2ServerTransportListenerFactory;
import org.apache.dubbo.rpc.protocol.tri.rest.mapping.DefaultRequestMappingRegistry;
import org.apache.dubbo.rpc.protocol.tri.rest.mapping.RequestMappingRegistry;
import org.apache.dubbo.rpc.protocol.tri.servlet.HttpMetadataAdapter;
import org.apache.dubbo.rpc.protocol.tri.servlet.ServletStreamChannel;

public class TripleFilter
implements Filter {
    private static final Logger LOGGER = LoggerFactory.getLogger(TripleFilter.class);
    private PathResolver pathResolver;
    private RequestMappingRegistry mappingRegistry;

    public void init(FilterConfig config) {
        FrameworkModel frameworkModel = FrameworkModel.defaultModel();
        this.pathResolver = (PathResolver)frameworkModel.getDefaultExtension(PathResolver.class);
        this.mappingRegistry = (RequestMappingRegistry)frameworkModel.getBeanFactory().getOrRegisterBean(DefaultRequestMappingRegistry.class);
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain chain) throws ServletException, IOException {
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        boolean isHttp2 = HttpVersion.HTTP2.getProtocol().equals(request.getProtocol());
        if (isHttp2) {
            if (this.hasGrpcMapping(request) || this.mappingRegistry.exists(request.getRequestURI(), request.getMethod())) {
                this.handleHttp2(request, response);
                return;
            }
        } else if (this.mappingRegistry.exists(request.getRequestURI(), request.getMethod())) {
            this.handleHttp1(request, response);
            return;
        }
        chain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    private void handleHttp2(HttpServletRequest request, HttpServletResponse response) {
        AsyncContext context = request.startAsync((ServletRequest)request, (ServletResponse)response);
        ServletStreamChannel channel = new ServletStreamChannel(request, response, context);
        try {
            Http2TransportListener listener = this.determineHttp2ServerTransportListenerFactory(request.getContentType()).newInstance((H2StreamChannel)channel, ServletExchanger.getUrl(), FrameworkModel.defaultModel());
            boolean isGrpc = listener instanceof GrpcHttp2ServerTransportListener;
            channel.setGrpc(isGrpc);
            context.setTimeout((long)TripleFilter.resolveTimeout(request, isGrpc));
            context.addListener((AsyncListener)new TripleAsyncListener(channel));
            ServletInputStream is = request.getInputStream();
            is.setReadListener((ReadListener)new TripleReadListener(listener, channel, is));
            response.getOutputStream().setWriteListener((WriteListener)new TripleWriteListener(channel));
            listener.onMetadata((HttpMetadata)new HttpMetadataAdapter(request));
        }
        catch (Throwable t) {
            LOGGER.info("Failed to process request", t);
            channel.writeError(TriRpcStatus.Code.UNKNOWN.code, t);
        }
    }

    private void handleHttp1(HttpServletRequest request, HttpServletResponse response) {
        AsyncContext context = request.startAsync((ServletRequest)request, (ServletResponse)response);
        ServletStreamChannel channel = new ServletStreamChannel(request, response, context);
        try {
            Http1ServerTransportListener listener = DefaultHttp11ServerTransportListenerFactory.INSTANCE.newInstance((HttpChannel)channel, ServletExchanger.getUrl(), FrameworkModel.defaultModel());
            channel.setGrpc(false);
            context.setTimeout((long)TripleFilter.resolveTimeout(request, false));
            ServletInputStream is = request.getInputStream();
            response.getOutputStream().setWriteListener((WriteListener)new TripleWriteListener(channel));
            listener.onMetadata((HttpMetadata)new HttpMetadataAdapter(request));
            listener.onData((HttpInputMessage)new Http1InputMessage((InputStream)(is.available() == 0 ? StreamUtils.EMPTY : new ByteArrayInputStream(StreamUtils.readBytes((InputStream)is)))));
        }
        catch (Throwable t) {
            LOGGER.info("Failed to process request", t);
            channel.writeError(TriRpcStatus.Code.UNKNOWN.code, t);
        }
    }

    public void destroy() {
    }

    private boolean hasGrpcMapping(HttpServletRequest request) {
        if (!GrpcUtils.isGrpcRequest((String)request.getContentType())) {
            return false;
        }
        RequestPath path = RequestPath.parse((String)request.getRequestURI());
        if (path == null) {
            return false;
        }
        String group = request.getHeader(TripleHeaderEnum.SERVICE_GROUP.getName());
        String version = request.getHeader(TripleHeaderEnum.SERVICE_VERSION.getName());
        return this.pathResolver.resolve(path.getPath(), group, version) != null;
    }

    private Http2ServerTransportListenerFactory determineHttp2ServerTransportListenerFactory(String contentType) {
        Set http2ServerTransportListenerFactories = FrameworkModel.defaultModel().getExtensionLoader(Http2ServerTransportListenerFactory.class).getSupportedExtensionInstances();
        for (Http2ServerTransportListenerFactory factory : http2ServerTransportListenerFactories) {
            if (!factory.supportContentType(contentType)) continue;
            return factory;
        }
        return GenericHttp2ServerTransportListenerFactory.INSTANCE;
    }

    private static int resolveTimeout(HttpServletRequest request, boolean isGrpc) {
        try {
            if (isGrpc) {
                Long timeout;
                String timeoutString = request.getHeader(GrpcHeaderNames.GRPC_TIMEOUT.getName());
                if (timeoutString != null && (timeout = GrpcUtils.parseTimeoutToMills((String)timeoutString)) != null) {
                    return timeout.intValue() + 2000;
                }
            } else {
                String timeoutString = request.getHeader(TripleHeaderEnum.SERVICE_TIMEOUT.getName());
                if (timeoutString != null) {
                    return Integer.parseInt(timeoutString) + 2000;
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return 0;
    }

    private static final class TripleAsyncListener
    implements AsyncListener {
        private final ServletStreamChannel streamChannel;

        TripleAsyncListener(ServletStreamChannel streamChannel) {
            this.streamChannel = streamChannel;
        }

        public void onComplete(AsyncEvent event) {
        }

        public void onTimeout(AsyncEvent event) {
            this.streamChannel.writeError(TriRpcStatus.Code.DEADLINE_EXCEEDED.code, event.getThrowable());
        }

        public void onError(AsyncEvent event) {
            this.streamChannel.writeError(TriRpcStatus.Code.CANCELLED.code, event.getThrowable());
        }

        public void onStartAsync(AsyncEvent event) {
        }
    }

    private static final class TripleReadListener
    implements ReadListener {
        private final Http2TransportListener listener;
        private final ServletStreamChannel channel;
        private final ServletInputStream input;
        private final byte[] buffer = new byte[4096];

        TripleReadListener(Http2TransportListener listener, ServletStreamChannel channel, ServletInputStream input) {
            this.listener = listener;
            this.channel = channel;
            this.input = input;
        }

        public void onDataAvailable() throws IOException {
            while (this.input.isReady()) {
                int length = this.input.read(this.buffer);
                if (length == -1) {
                    return;
                }
                byte[] copy = Arrays.copyOf(this.buffer, length);
                this.listener.onData((HttpInputMessage)new Http2InputMessageFrame((InputStream)new ByteArrayInputStream(copy), false));
            }
        }

        public void onAllDataRead() {
            this.listener.onData((HttpInputMessage)new Http2InputMessageFrame((InputStream)StreamUtils.EMPTY, true));
        }

        public void onError(Throwable t) {
            this.channel.writeError(TriRpcStatus.Code.CANCELLED.code, t);
        }
    }

    private static final class TripleWriteListener
    implements WriteListener {
        private final ServletStreamChannel channel;

        TripleWriteListener(ServletStreamChannel channel) {
            this.channel = channel;
        }

        public void onWritePossible() {
            this.channel.onWritePossible();
        }

        public void onError(Throwable t) {
            this.channel.writeError(TriRpcStatus.Code.CANCELLED.code, t);
        }
    }
}

