/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.common.serialize.nativejava;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.lang.reflect.Type;
import org.apache.dubbo.common.serialize.ObjectInput;
import org.apache.dubbo.common.utils.Assert;

public class NativeJavaObjectInput
implements ObjectInput {
    private final ObjectInputStream inputStream;

    public NativeJavaObjectInput(InputStream is) throws IOException {
        this(new ObjectInputStream(is));
    }

    protected NativeJavaObjectInput(ObjectInputStream is) {
        Assert.notNull((Object)is, (String)"input == null");
        this.inputStream = is;
    }

    protected ObjectInputStream getObjectInputStream() {
        return this.inputStream;
    }

    public Object readObject() throws IOException, ClassNotFoundException {
        return this.inputStream.readObject();
    }

    public <T> T readObject(Class<T> cls) throws IOException, ClassNotFoundException {
        return (T)this.readObject();
    }

    public <T> T readObject(Class<T> cls, Type type) throws IOException, ClassNotFoundException {
        return (T)this.readObject();
    }

    public boolean readBool() throws IOException {
        return this.inputStream.readBoolean();
    }

    public byte readByte() throws IOException {
        return this.inputStream.readByte();
    }

    public short readShort() throws IOException {
        return this.inputStream.readShort();
    }

    public int readInt() throws IOException {
        return this.inputStream.readInt();
    }

    public long readLong() throws IOException {
        return this.inputStream.readLong();
    }

    public float readFloat() throws IOException {
        return this.inputStream.readFloat();
    }

    public double readDouble() throws IOException {
        return this.inputStream.readDouble();
    }

    public String readUTF() throws IOException {
        return this.inputStream.readUTF();
    }

    public byte[] readBytes() throws IOException {
        int len = this.inputStream.readInt();
        if (len < 0) {
            return null;
        }
        if (len == 0) {
            return new byte[0];
        }
        byte[] result = new byte[len];
        this.inputStream.readFully(result);
        return result;
    }
}

