/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.common.serialize.hessian2;

import com.alibaba.com.caucho.hessian.io.SerializerFactory;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.dubbo.common.serialize.hessian2.Hessian2SerializerFactory;
import org.apache.dubbo.common.utils.ConcurrentHashMapUtils;
import org.apache.dubbo.common.utils.DefaultSerializeClassChecker;
import org.apache.dubbo.common.utils.SerializeCheckStatus;
import org.apache.dubbo.common.utils.SerializeSecurityManager;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.common.utils.SystemPropertyConfigUtils;
import org.apache.dubbo.rpc.model.FrameworkModel;

public class Hessian2FactoryManager {
    private volatile SerializerFactory SYSTEM_SERIALIZER_FACTORY;
    private volatile SerializerFactory stickySerializerFactory = null;
    private final ConcurrentHashMap<ClassLoader, SerializerFactory> CL_2_SERIALIZER_FACTORY = new ConcurrentHashMap();
    private final SerializeSecurityManager serializeSecurityManager;
    private final DefaultSerializeClassChecker defaultSerializeClassChecker;

    public Hessian2FactoryManager(FrameworkModel frameworkModel) {
        this.serializeSecurityManager = (SerializeSecurityManager)frameworkModel.getBeanFactory().getOrRegisterBean(SerializeSecurityManager.class);
        this.defaultSerializeClassChecker = (DefaultSerializeClassChecker)frameworkModel.getBeanFactory().getOrRegisterBean(DefaultSerializeClassChecker.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SerializerFactory getSerializerFactory(ClassLoader classLoader) {
        SerializerFactory factory;
        SerializerFactory sticky = this.stickySerializerFactory;
        if (sticky != null && Objects.equals(sticky.getClassLoader(), classLoader)) {
            return sticky;
        }
        if (classLoader == null) {
            if (this.SYSTEM_SERIALIZER_FACTORY == null) {
                Hessian2FactoryManager hessian2FactoryManager = this;
                synchronized (hessian2FactoryManager) {
                    if (this.SYSTEM_SERIALIZER_FACTORY == null) {
                        this.SYSTEM_SERIALIZER_FACTORY = this.createSerializerFactory(null);
                    }
                }
            }
            this.stickySerializerFactory = this.SYSTEM_SERIALIZER_FACTORY;
            return this.SYSTEM_SERIALIZER_FACTORY;
        }
        this.stickySerializerFactory = factory = (SerializerFactory)ConcurrentHashMapUtils.computeIfAbsent(this.CL_2_SERIALIZER_FACTORY, (Object)classLoader, this::createSerializerFactory);
        return factory;
    }

    private SerializerFactory createSerializerFactory(ClassLoader classLoader) {
        String whitelist = SystemPropertyConfigUtils.getSystemProperty((String)"dubbo.application.hessian2.whitelist");
        if (StringUtils.isNotEmpty((String)whitelist)) {
            return this.createWhiteListSerializerFactory(classLoader);
        }
        return this.createDefaultSerializerFactory(classLoader);
    }

    private SerializerFactory createDefaultSerializerFactory(ClassLoader classLoader) {
        Hessian2SerializerFactory hessian2SerializerFactory = new Hessian2SerializerFactory(classLoader, this.defaultSerializeClassChecker);
        hessian2SerializerFactory.setAllowNonSerializable(Boolean.parseBoolean(SystemPropertyConfigUtils.getSystemProperty((String)"dubbo.hessian.allowNonSerializable", (String)"false")));
        hessian2SerializerFactory.getClassFactory().allow("org.apache.dubbo.*");
        return hessian2SerializerFactory;
    }

    public SerializerFactory createWhiteListSerializerFactory(ClassLoader classLoader) {
        Hessian2SerializerFactory serializerFactory = new Hessian2SerializerFactory(classLoader, this.defaultSerializeClassChecker);
        String whiteList = SystemPropertyConfigUtils.getSystemProperty((String)"dubbo.application.hessian2.whitelist");
        if ("true".equals(whiteList)) {
            serializerFactory.getClassFactory().setWhitelist(true);
            String allowPattern = SystemPropertyConfigUtils.getSystemProperty((String)"dubbo.application.hessian2.allow");
            if (StringUtils.isNotEmpty((String)allowPattern)) {
                for (String pattern : allowPattern.split(";")) {
                    serializerFactory.getClassFactory().allow(pattern);
                    this.serializeSecurityManager.addToAlwaysAllowed(pattern);
                }
            }
            this.serializeSecurityManager.setCheckStatus(SerializeCheckStatus.STRICT);
        } else {
            serializerFactory.getClassFactory().setWhitelist(false);
            String denyPattern = SystemPropertyConfigUtils.getSystemProperty((String)"dubbo.application.hessian2.deny");
            if (StringUtils.isNotEmpty((String)denyPattern)) {
                for (String pattern : denyPattern.split(";")) {
                    serializerFactory.getClassFactory().deny(pattern);
                    this.serializeSecurityManager.addToDisAllowed(pattern);
                }
            }
        }
        serializerFactory.setAllowNonSerializable(Boolean.parseBoolean(SystemPropertyConfigUtils.getSystemProperty((String)"dubbo.hessian.allowNonSerializable", (String)"false")));
        serializerFactory.getClassFactory().allow("org.apache.dubbo.*");
        return serializerFactory;
    }

    public void onRemoveClassLoader(ClassLoader classLoader) {
        this.CL_2_SERIALIZER_FACTORY.remove(classLoader);
    }
}

