/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.dubbo;

import java.io.IOException;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.Version;
import org.apache.dubbo.common.config.ConfigurationUtils;
import org.apache.dubbo.common.serialize.SerializationException;
import org.apache.dubbo.common.utils.AtomicPositiveInteger;
import org.apache.dubbo.remoting.RemotingException;
import org.apache.dubbo.remoting.TimeoutException;
import org.apache.dubbo.remoting.exchange.ExchangeClient;
import org.apache.dubbo.remoting.exchange.Request;
import org.apache.dubbo.rpc.AppResponse;
import org.apache.dubbo.rpc.AsyncRpcResult;
import org.apache.dubbo.rpc.FutureContext;
import org.apache.dubbo.rpc.Invocation;
import org.apache.dubbo.rpc.InvokeMode;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.Result;
import org.apache.dubbo.rpc.RpcContext;
import org.apache.dubbo.rpc.RpcException;
import org.apache.dubbo.rpc.RpcInvocation;
import org.apache.dubbo.rpc.model.ScopeModel;
import org.apache.dubbo.rpc.protocol.AbstractInvoker;
import org.apache.dubbo.rpc.protocol.dubbo.ClientsProvider;
import org.apache.dubbo.rpc.support.RpcUtils;

public class DubboInvoker<T>
extends AbstractInvoker<T> {
    private final ClientsProvider clientsProvider;
    private final AtomicPositiveInteger index = new AtomicPositiveInteger();
    private final ReentrantLock destroyLock = new ReentrantLock();
    private final Set<Invoker<?>> invokers;
    private final int serverShutdownTimeout;
    private static final boolean setFutureWhenSync = Boolean.parseBoolean(System.getProperty("future.sync.set", "true"));

    public DubboInvoker(Class<T> serviceType, URL url, ClientsProvider clientsProvider) {
        this(serviceType, url, clientsProvider, null);
    }

    public DubboInvoker(Class<T> serviceType, URL url, ClientsProvider clientsProvider, Set<Invoker<?>> invokers) {
        super(serviceType, url, new String[]{"interface", "group", "token"});
        this.clientsProvider = clientsProvider;
        this.invokers = invokers;
        this.serverShutdownTimeout = ConfigurationUtils.getServerShutdownTimeout((ScopeModel)this.getUrl().getScopeModel());
    }

    protected Result doInvoke(Invocation invocation) throws Throwable {
        RpcInvocation inv = (RpcInvocation)invocation;
        String methodName = RpcUtils.getMethodName((Invocation)invocation);
        inv.setAttachment("path", this.getUrl().getPath());
        inv.setAttachment("version", this.version);
        List<? extends ExchangeClient> exchangeClients = this.clientsProvider.getClients();
        ExchangeClient currentClient = exchangeClients.size() == 1 ? exchangeClients.get(0) : exchangeClients.get(this.index.getAndIncrement() % exchangeClients.size());
        RpcContext.getServiceContext().setLocalAddress(currentClient.getLocalAddress());
        try {
            boolean isOneway = RpcUtils.isOneway((URL)this.getUrl(), (Invocation)invocation);
            int timeout = RpcUtils.calculateTimeout((URL)this.getUrl(), (Invocation)invocation, (String)methodName, (long)1000L);
            if (timeout <= 0) {
                return AsyncRpcResult.newDefaultAsyncResult((Throwable)new RpcException(8, "No time left for making the following call: " + invocation.getServiceName() + "." + RpcUtils.getMethodName((Invocation)invocation) + ", terminate directly."), (Invocation)invocation);
            }
            invocation.setAttachment("timeout", String.valueOf(timeout));
            Integer payload = (Integer)this.getUrl().getParameter("payload", Integer.class);
            Request request = new Request();
            if (payload != null) {
                request.setPayload(payload.intValue());
            }
            request.setData((Object)inv);
            request.setVersion(Version.getProtocolVersion());
            if (isOneway) {
                boolean isSent = this.getUrl().getMethodParameter(methodName, "sent", false);
                request.setTwoWay(false);
                currentClient.send((Object)request, isSent);
                return AsyncRpcResult.newDefaultAsyncResult((Invocation)invocation);
            }
            request.setTwoWay(true);
            ExecutorService executor = this.getCallbackExecutor(this.getUrl(), (Invocation)inv);
            CompletionStage appResponseFuture = currentClient.request((Object)request, timeout, executor).thenApply(AppResponse.class::cast);
            if (setFutureWhenSync || ((RpcInvocation)invocation).getInvokeMode() != InvokeMode.SYNC) {
                FutureContext.getContext().setCompatibleFuture((CompletableFuture)appResponseFuture);
            }
            AsyncRpcResult result = new AsyncRpcResult((CompletableFuture)appResponseFuture, (Invocation)inv);
            result.setExecutor((Executor)executor);
            return result;
        }
        catch (TimeoutException e) {
            throw new RpcException(2, "Invoke remote method timeout. method: " + RpcUtils.getMethodName((Invocation)invocation) + ", provider: " + this.getUrl() + ", cause: " + e.getMessage(), (Throwable)e);
        }
        catch (RemotingException e) {
            String remoteExpMsg = "Failed to invoke remote method: " + RpcUtils.getMethodName((Invocation)invocation) + ", provider: " + this.getUrl() + ", cause: " + e.getMessage();
            if (e.getCause() instanceof IOException && e.getCause().getCause() instanceof SerializationException) {
                throw new RpcException(5, remoteExpMsg, (Throwable)e);
            }
            throw new RpcException(1, remoteExpMsg, (Throwable)e);
        }
    }

    public boolean isAvailable() {
        if (!super.isAvailable()) {
            return false;
        }
        for (ExchangeClient exchangeClient : this.clientsProvider.getClients()) {
            if (!exchangeClient.isConnected() || exchangeClient.hasAttribute("channel.readonly")) continue;
            return true;
        }
        return false;
    }

    public void destroy() {
        if (!super.isDestroyed()) {
            this.destroyLock.lock();
            try {
                if (super.isDestroyed()) {
                    return;
                }
                super.destroy();
                if (this.invokers != null) {
                    this.invokers.remove((Object)this);
                }
                this.clientsProvider.close(ConfigurationUtils.reCalShutdownTime((int)this.serverShutdownTimeout));
            }
            finally {
                this.destroyLock.unlock();
            }
        }
    }
}

