/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.dubbo.filter;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.dubbo.common.extension.Activate;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.common.utils.ConcurrentHashSet;
import org.apache.dubbo.remoting.Channel;
import org.apache.dubbo.rpc.Filter;
import org.apache.dubbo.rpc.Invocation;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.Result;
import org.apache.dubbo.rpc.RpcContext;
import org.apache.dubbo.rpc.RpcException;

@Activate(group={"provider"})
public class TraceFilter
implements Filter {
    private static final Logger logger = LoggerFactory.getLogger(TraceFilter.class);
    private static final String TRACE_MAX = "trace.max";
    private static final String TRACE_COUNT = "trace.count";
    private static final ConcurrentMap<String, Set<Channel>> TRACERS = new ConcurrentHashMap<String, Set<Channel>>();

    public static void addTracer(Class<?> type, String method, Channel channel, int max) {
        channel.setAttribute(TRACE_MAX, (Object)max);
        channel.setAttribute(TRACE_COUNT, (Object)new AtomicInteger());
        String key = method != null && method.length() > 0 ? type.getName() + "." + method : type.getName();
        Set channels = TRACERS.computeIfAbsent(key, k -> new ConcurrentHashSet());
        channels.add(channel);
    }

    public static void removeTracer(Class<?> type, String method, Channel channel) {
        channel.removeAttribute(TRACE_MAX);
        channel.removeAttribute(TRACE_COUNT);
        String key = method != null && method.length() > 0 ? type.getName() + "." + method : type.getName();
        Set channels = (Set)TRACERS.get(key);
        if (channels != null) {
            channels.remove(channel);
        }
    }

    public Result invoke(Invoker<?> invoker, Invocation invocation) throws RpcException {
        long start = System.currentTimeMillis();
        Result result = invoker.invoke(invocation);
        long end = System.currentTimeMillis();
        if (TRACERS.size() > 0) {
            String key = invoker.getInterface().getName() + "." + invocation.getMethodName();
            Set channels = (Set)TRACERS.get(key);
            if (channels == null || channels.isEmpty()) {
                key = invoker.getInterface().getName();
                channels = (Set)TRACERS.get(key);
            }
            if (CollectionUtils.isNotEmpty((Collection)channels)) {
                for (Channel channel : new ArrayList(channels)) {
                    if (channel.isConnected()) {
                        try {
                            int max = 1;
                            Integer m = (Integer)channel.getAttribute(TRACE_MAX);
                            if (m != null) {
                                max = m;
                            }
                            int count = 0;
                            AtomicInteger c = (AtomicInteger)channel.getAttribute(TRACE_COUNT);
                            if (c == null) {
                                c = new AtomicInteger();
                                channel.setAttribute(TRACE_COUNT, (Object)c);
                            }
                            if ((count = c.getAndIncrement()) < max) {
                                String prompt = channel.getUrl().getParameter("prompt", "dubbo>");
                                channel.send((Object)("\r\n" + RpcContext.getContext().getRemoteAddress() + " -> " + invoker.getInterface().getName() + "." + invocation.getMethodName() + "(" + JSON.toJSONString((Object)invocation.getArguments()) + ") -> " + JSON.toJSONString((Object)result.getValue()) + "\r\nelapsed: " + (end - start) + " ms.\r\n\r\n" + prompt));
                            }
                            if (count < max - 1) continue;
                            channels.remove(channel);
                        }
                        catch (Throwable e) {
                            channels.remove(channel);
                            logger.warn(e.getMessage(), e);
                        }
                        continue;
                    }
                    channels.remove(channel);
                }
            }
        }
        return result;
    }
}

