/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.proxy;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public interface MethodInvoker {
    public Object invoke(Object var1, String var2, Class<?>[] var3, Object[] var4) throws Throwable;

    public static MethodInvoker newInstance(Class<?> clazz) {
        Method[] methods = clazz.getMethods();
        HashMap<String, MethodInvoker> invokers = new HashMap<String, MethodInvoker>();
        HashMap<String, List> map = new HashMap<String, List>();
        for (Method method : methods) {
            map.computeIfAbsent(method.getName(), name -> new ArrayList()).add(method);
        }
        Set entries = map.entrySet();
        for (Map.Entry entry : entries) {
            String methodName = (String)entry.getKey();
            List ms = (List)entry.getValue();
            if (ms.size() == 1) {
                invokers.put(methodName, new SingleMethodInvoker((Method)ms.get(0)));
                continue;
            }
            invokers.put(methodName, new OverloadMethodInvoker(ms));
        }
        return new CompositeMethodInvoker(invokers);
    }

    public static class SingleMethodInvoker
    implements MethodInvoker {
        private final Method method;

        SingleMethodInvoker(Method method) {
            this.method = method;
        }

        @Override
        public Object invoke(Object instance, String methodName, Class<?>[] parameterTypes, Object[] arguments) throws Throwable {
            return this.method.invoke(instance, arguments);
        }
    }

    public static class OverloadMethodInvoker
    implements MethodInvoker {
        private final MethodMeta[] methods;

        OverloadMethodInvoker(List<Method> methods) {
            this.methods = (MethodMeta[])methods.stream().map(x$0 -> new MethodMeta((Method)x$0)).toArray(MethodMeta[]::new);
        }

        @Override
        public Object invoke(Object instance, String methodName, Class<?>[] parameterTypes, Object[] arguments) throws Throwable {
            for (MethodMeta meta : this.methods) {
                if (!Arrays.equals(meta.getParametersType(), parameterTypes)) continue;
                return meta.getMethod().invoke(instance, arguments);
            }
            throw new NoSuchMethodException(instance.getClass().getName() + "." + methodName + Arrays.toString(parameterTypes));
        }

        private static class MethodMeta {
            private final Method method;
            private final Class<?>[] parametersType;

            private MethodMeta(Method method) {
                this.method = method;
                this.parametersType = method.getParameterTypes();
            }

            public Method getMethod() {
                return this.method;
            }

            public Class<?>[] getParametersType() {
                return this.parametersType;
            }
        }
    }

    public static class CompositeMethodInvoker
    implements MethodInvoker {
        private final Map<String, MethodInvoker> invokers;

        public CompositeMethodInvoker(Map<String, MethodInvoker> invokers) {
            this.invokers = invokers;
        }

        Map<String, MethodInvoker> getInvokers() {
            return this.invokers;
        }

        @Override
        public Object invoke(Object instance, String methodName, Class<?>[] parameterTypes, Object[] arguments) throws Throwable {
            MethodInvoker invoker = this.invokers.get(methodName);
            if (invoker == null) {
                throw new NoSuchMethodException(instance.getClass().getName() + "." + methodName + Arrays.toString(parameterTypes));
            }
            return invoker.invoke(instance, methodName, parameterTypes, arguments);
        }
    }
}

