/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executor;
import org.apache.dubbo.rpc.CancellationListener;
import org.apache.dubbo.rpc.ExecutableListener;
import org.apache.dubbo.rpc.RpcServiceContext;

public class CancellationContext
implements Closeable {
    private volatile ArrayList<ExecutableListener> listeners;
    private Throwable cancellationCause;
    private boolean cancelled;

    public void addListener(CancellationListener cancellationListener, Executor executor) {
        this.addListener(cancellationListener, executor, null);
    }

    public void addListener(CancellationListener cancellationListener) {
        this.addListener(cancellationListener, Runnable::run, null);
    }

    public void addListener(CancellationListener cancellationListener, RpcServiceContext context) {
        this.addListener(cancellationListener, Runnable::run, context);
    }

    public void addListener(CancellationListener cancellationListener, Executor executor, RpcServiceContext context) {
        this.addListenerInternal(new ExecutableListener(executor, cancellationListener, context));
    }

    public synchronized void addListenerInternal(ExecutableListener executableListener) {
        if (this.isCancelled()) {
            executableListener.deliver();
        } else {
            if (this.listeners == null) {
                this.listeners = new ArrayList();
            }
            this.listeners.add(executableListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean cancel(Throwable cause) {
        boolean triggeredCancel = false;
        CancellationContext cancellationContext = this;
        synchronized (cancellationContext) {
            if (!this.cancelled) {
                this.cancelled = true;
                this.cancellationCause = cause;
                triggeredCancel = true;
            }
        }
        if (triggeredCancel) {
            this.notifyAndClearListeners();
        }
        return triggeredCancel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyAndClearListeners() {
        ArrayList<ExecutableListener> tmpListeners;
        CancellationContext cancellationContext = this;
        synchronized (cancellationContext) {
            if (this.listeners == null) {
                return;
            }
            tmpListeners = this.listeners;
            this.listeners = null;
        }
        for (ExecutableListener tmpListener : tmpListeners) {
            tmpListener.deliver();
        }
    }

    public synchronized boolean isCancelled() {
        return this.cancelled;
    }

    public List<ExecutableListener> getListeners() {
        return this.listeners;
    }

    public Throwable getCancellationCause() {
        return this.cancellationCause;
    }

    @Override
    public void close() throws IOException {
        this.cancel(null);
    }
}

