/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri.rest.support.spring;

import org.apache.dubbo.common.extension.Activate;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.rpc.model.FrameworkModel;
import org.apache.dubbo.rpc.protocol.tri.rest.cors.CorsUtils;
import org.apache.dubbo.rpc.protocol.tri.rest.mapping.RequestMapping;
import org.apache.dubbo.rpc.protocol.tri.rest.mapping.RequestMappingResolver;
import org.apache.dubbo.rpc.protocol.tri.rest.mapping.condition.Condition;
import org.apache.dubbo.rpc.protocol.tri.rest.mapping.condition.ServiceVersionCondition;
import org.apache.dubbo.rpc.protocol.tri.rest.mapping.meta.AnnotationEnum;
import org.apache.dubbo.rpc.protocol.tri.rest.mapping.meta.AnnotationMeta;
import org.apache.dubbo.rpc.protocol.tri.rest.mapping.meta.CorsMeta;
import org.apache.dubbo.rpc.protocol.tri.rest.mapping.meta.MethodMeta;
import org.apache.dubbo.rpc.protocol.tri.rest.mapping.meta.ServiceMeta;
import org.apache.dubbo.rpc.protocol.tri.rest.support.spring.Annotations;
import org.apache.dubbo.rpc.protocol.tri.rest.support.spring.SpringRestToolKit;
import org.apache.dubbo.rpc.protocol.tri.rest.util.RestToolKit;
import org.springframework.http.HttpStatus;

@Activate(onClass={"org.springframework.web.bind.annotation.RequestMapping"})
public class SpringMvcRequestMappingResolver
implements RequestMappingResolver {
    private final FrameworkModel frameworkModel;
    private volatile RestToolKit toolKit;
    private CorsMeta globalCorsMeta;

    public SpringMvcRequestMappingResolver(FrameworkModel frameworkModel) {
        this.frameworkModel = frameworkModel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RestToolKit getRestToolKit() {
        RestToolKit toolKit = this.toolKit;
        if (toolKit == null) {
            SpringMvcRequestMappingResolver springMvcRequestMappingResolver = this;
            synchronized (springMvcRequestMappingResolver) {
                toolKit = this.toolKit;
                if (toolKit == null) {
                    this.toolKit = toolKit = new SpringRestToolKit(this.frameworkModel);
                }
            }
        }
        return toolKit;
    }

    public RequestMapping resolve(ServiceMeta serviceMeta) {
        AnnotationMeta requestMapping = serviceMeta.findMergedAnnotation((AnnotationEnum)Annotations.RequestMapping);
        if (requestMapping == null) {
            return null;
        }
        AnnotationMeta responseStatus = serviceMeta.findMergedAnnotation((AnnotationEnum)Annotations.ResponseStatus);
        AnnotationMeta crossOrigin = serviceMeta.findMergedAnnotation((AnnotationEnum)Annotations.CrossOrigin);
        String[] methods = requestMapping.getStringArray("method");
        return this.builder(requestMapping, responseStatus).method(methods).name(serviceMeta.getType().getSimpleName()).contextPath(serviceMeta.getContextPath()).cors(this.buildCorsMeta(crossOrigin, methods)).build();
    }

    public RequestMapping resolve(MethodMeta methodMeta) {
        AnnotationMeta requestMapping = methodMeta.findMergedAnnotation((AnnotationEnum)Annotations.RequestMapping);
        if (requestMapping == null) {
            AnnotationMeta exceptionHandler = methodMeta.getAnnotation((AnnotationEnum)Annotations.ExceptionHandler);
            if (exceptionHandler != null) {
                methodMeta.getServiceMeta().addExceptionHandler(methodMeta);
            }
            return null;
        }
        ServiceMeta serviceMeta = methodMeta.getServiceMeta();
        AnnotationMeta responseStatus = methodMeta.findMergedAnnotation((AnnotationEnum)Annotations.ResponseStatus);
        AnnotationMeta crossOrigin = methodMeta.findMergedAnnotation((AnnotationEnum)Annotations.CrossOrigin);
        String[] methods = requestMapping.getStringArray("method");
        return this.builder(requestMapping, responseStatus).method(methods).name(methodMeta.getMethod().getName()).contextPath(serviceMeta.getContextPath()).custom((Condition)new ServiceVersionCondition(serviceMeta.getServiceGroup(), serviceMeta.getServiceVersion())).cors(this.buildCorsMeta(crossOrigin, methods)).build();
    }

    private RequestMapping.Builder builder(AnnotationMeta<?> requestMapping, AnnotationMeta<?> responseStatus) {
        RequestMapping.Builder builder = RequestMapping.builder();
        if (responseStatus != null) {
            HttpStatus value = (HttpStatus)responseStatus.getEnum("value");
            builder.responseStatus(value.value());
            String reason = responseStatus.getString("reason");
            if (StringUtils.isNotEmpty((String)reason)) {
                builder.responseReason(reason);
            }
        }
        return builder.path(requestMapping.getValueArray()).param(requestMapping.getStringArray("params")).header(requestMapping.getStringArray("headers")).consume(requestMapping.getStringArray("consumes")).produce(requestMapping.getStringArray("produces"));
    }

    private CorsMeta buildCorsMeta(AnnotationMeta<?> crossOrigin, String[] methods) {
        if (this.globalCorsMeta == null) {
            this.globalCorsMeta = CorsUtils.getGlobalCorsMeta((FrameworkModel)this.frameworkModel);
        }
        if (crossOrigin == null) {
            return this.globalCorsMeta;
        }
        String[] allowedMethods = crossOrigin.getStringArray("methods");
        if (allowedMethods.length == 0 && (allowedMethods = methods).length == 0) {
            allowedMethods = new String[]{"*"};
        }
        CorsMeta corsMeta = CorsMeta.builder().allowedOrigins(crossOrigin.getStringArray("origins")).allowedMethods(allowedMethods).allowedHeaders(crossOrigin.getStringArray("allowedHeaders")).exposedHeaders(crossOrigin.getStringArray("exposedHeaders")).allowCredentials(crossOrigin.getString("allowCredentials")).maxAge((Long)crossOrigin.getNumber("maxAge")).build();
        return this.globalCorsMeta.combine(corsMeta);
    }
}

