/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri.rest.support.spring;

import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import org.apache.dubbo.common.extension.Activate;
import org.apache.dubbo.common.io.StreamUtils;
import org.apache.dubbo.remoting.http12.HttpRequest;
import org.apache.dubbo.remoting.http12.HttpResponse;
import org.apache.dubbo.rpc.protocol.tri.rest.RestException;
import org.apache.dubbo.rpc.protocol.tri.rest.mapping.meta.AnnotationMeta;
import org.apache.dubbo.rpc.protocol.tri.rest.mapping.meta.NamedValueMeta;
import org.apache.dubbo.rpc.protocol.tri.rest.mapping.meta.ParameterMeta;
import org.apache.dubbo.rpc.protocol.tri.rest.support.spring.AbstractSpringArgumentResolver;
import org.apache.dubbo.rpc.protocol.tri.rest.support.spring.Annotations;
import org.apache.dubbo.rpc.protocol.tri.rest.support.spring.Helper;
import org.apache.dubbo.rpc.protocol.tri.rest.util.RequestUtils;

@Activate(onClass={"org.springframework.web.bind.annotation.RequestBody"})
public class RequestBodyArgumentResolver
extends AbstractSpringArgumentResolver {
    public Class<Annotation> accept() {
        return Annotations.RequestBody.type();
    }

    @Override
    protected NamedValueMeta createNamedValueMeta(ParameterMeta param, AnnotationMeta<Annotation> ann) {
        return new NamedValueMeta(Helper.isRequired(ann), null);
    }

    protected Object resolveValue(NamedValueMeta meta, HttpRequest request, HttpResponse response) {
        if (RequestUtils.isFormOrMultiPart((HttpRequest)request)) {
            if (meta.parameterMeta().isSimple()) {
                return request.formParameter(meta.name());
            }
            return meta.parameterMeta().bind(request, response);
        }
        return RequestUtils.decodeBody((HttpRequest)request, (Class)meta.type());
    }

    protected Object resolveCollectionValue(NamedValueMeta meta, HttpRequest request, HttpResponse response) {
        Class type = meta.type();
        if (type == byte[].class) {
            try {
                return StreamUtils.readBytes((InputStream)request.inputStream());
            }
            catch (IOException e) {
                throw new RestException((Throwable)e);
            }
        }
        if (RequestUtils.isFormOrMultiPart((HttpRequest)request)) {
            return request.formParameterValues(meta.name());
        }
        return RequestUtils.decodeBody((HttpRequest)request, (Class)meta.type());
    }

    protected Object resolveMapValue(NamedValueMeta meta, HttpRequest request, HttpResponse response) {
        if (RequestUtils.isFormOrMultiPart((HttpRequest)request)) {
            return RequestUtils.getFormParametersMap((HttpRequest)request);
        }
        return RequestUtils.decodeBody((HttpRequest)request, (Class)meta.type());
    }
}

